/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ModuleLocator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.EjbJar30ExportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.XmlBasedImportStrategyImpl;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class EjbJar30NoDDImportStrategyImpl
extends XmlBasedImportStrategyImpl {
    static final String className = EjbJar30NoDDImportStrategyImpl.class.getName();
    protected static Discriminator discriminator;

    public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
        return EjbJar30NoDDImportStrategyImpl.getDiscriminator().createImportStrategy(old, newArchive);
    }

    public static ArchiveTypeDiscriminator getDiscriminator() {
        if (discriminator == null) {
            discriminator = new Discriminator();
        }
        return discriminator;
    }

    public EJBJarFile getEJBJarFile() {
        return (EJBJarFile)this.getArchive();
    }

    public boolean isNoDDStrategy() {
        return true;
    }

    public void importMetaData() throws Exception {
        this.loadDeploymentDescriptor();
    }

    protected boolean allowNullResource() {
        return true;
    }

    public void loadDeploymentDescriptor() throws Exception {
        String methodName = "loadDeploymentDescriptor";
        logger.logp(Level.FINER, className, methodName, "Creating an ejb-jar.xml (with no EJBs) for the EJB Module");
        EJBJarFile jarFile = this.getEJBJarFile();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "EJB jar file = [ {0} ]", jarFile);
            logger.logp(Level.FINER, className, methodName, "EJB jar file binaries path = [ {0} ]", jarFile.getBinariesPath());
        }
        XMLResource resource = (XMLResource)jarFile.makeDeploymentDescriptorResource();
        resource.setModuleVersionID(30);
        EJBJar ejbJar = (EJBJar)this.primLoadDeploymentDescriptor();
        ejbJar.setVersion("3.0");
        ejbJar.setMetadataComplete(false);
        jarFile.setDeploymentDescriptor(ejbJar);
        XMLResource xmlRes = (XMLResource)jarFile.eResource();
        if (xmlRes != null) {
            xmlRes.setModuleVersionID(30);
        }
        this.versionCheck(ejbJar);
        jarFile.setExportStrategy(new EjbJar30ExportStrategyImpl());
        jarFile.setGeneratedDD(true);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public static class Discriminator
    extends ArchiveTypeDiscriminatorImpl {
        static final String className = Discriminator.class.getName();

        public boolean canImport(Archive anArchive) {
            String methodName = "canImport";
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "ENTRY archive [ {0} ]", anArchive);
            Archive.ModuleVersionEnum version = Archive.ModuleVersionEnum.EJB30;
            if (anArchive.isSetCanImportAs(version)) {
                boolean canImport = anArchive.getCanImportAs(version);
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN cached EJB30 value [ {0} ]", canImport);
                return canImport;
            }
            boolean canImport = this.hasEjbContents(anArchive);
            anArchive.setCanImportAs(version, canImport);
            anArchive.closeArchiveZipFile();
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN EJB30 [ {0} ]", Boolean.toString(canImport));
            return canImport;
        }

        private boolean hasEjbContents(Archive anArchive) {
            String methodName = "hasEjbContents";
            String archiveURI = anArchive.getURI();
            XmlBasedImportStrategyImpl.logger.entering(className, methodName);
            if (!archiveURI.endsWith(".jar")) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false - Archive [ {0} ] does not end with .jar", archiveURI);
                return false;
            }
            if (anArchive.containsFile("WEB-INF")) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false - Archive [ {0} ] contains a web application directory", archiveURI);
                return false;
            }
            EList archiveList = anArchive.getFiles();
            Iterator archiveFiles = archiveList.iterator();
            File serFile = null;
            boolean isDirectory = anArchive.getLoadStrategy() instanceof DirectoryArchiveLoadStrategyImpl;
            while (serFile == null && archiveFiles.hasNext()) {
                File nextFile = (File)archiveFiles.next();
                if (isDirectory || !nextFile.getURI().endsWith(".ser")) continue;
                serFile = nextFile;
            }
            if (serFile != null) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false -  Found .ser file [ {0} ]", serFile.getURI());
                return false;
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "No .ser file was detected.");
            if (XmlBasedImportStrategyImpl.hasBlockingExtension(archiveURI, Archive.ModuleTypeEnum.EJB)) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN Blocked by other file extension");
                return false;
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "No blocking extensions");
            if (XmlBasedImportStrategyImpl.containsBlockingDescriptor(anArchive, Archive.ModuleTypeEnum.EJB)) {
                XmlBasedImportStrategyImpl.logger.exiting(className, methodName, "RETURN false - Blocked by other descriptor");
                return false;
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "No blocking descriptors");
            ModuleLocator ml = new ModuleLocator();
            if (ml.isEJBModule(anArchive)) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN true - archive [ {0} ] contains EJB Module annotations", anArchive);
                return true;
            }
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false - Could not find anything in Archive [ {0} ] to indicate that it is an EJB Jar file", archiveURI);
            return false;
        }

        public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
            return new EjbJar30NoDDImportStrategyImpl();
        }

        public String getUnableToOpenMessage() {
            return this.getXmlDDMessage(CommonArchiveResourceHandler.EJB_Jar_File, "META-INF/ejb-jar.xml");
        }

        public Archive createConvertedArchive() {
            return EjbJar30NoDDImportStrategyImpl.getArchiveFactory().createEJBJarFile();
        }
    }
}

