/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveURIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class DirectorySaveStrategyImpl
extends SaveStrategyImpl
implements SaveStrategy {
    protected static String className = DirectorySaveStrategyImpl.class.getName();
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    protected String directoryName;
    protected int expansionFlags;
    protected URIConverter uriConverter;
    public static final String BASE_TEMP_FILE = "WTPSAVE_";

    public boolean saveIncrementally() {
        return this.getArchive().getOptions().getSaveIncrementally();
    }

    public boolean isDirectory() {
        return true;
    }

    public void setDirectoryName(String newDirectoryName) {
        this.directoryName = newDirectoryName;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    protected void mkdirs(String directoryPath) {
        java.io.File aDirectory = new java.io.File(this.getDirectoryName() + java.io.File.separatorChar + directoryPath);
        aDirectory.mkdirs();
    }

    public void setExpansionFlags(int newExpansionFlags) {
        this.expansionFlags = newExpansionFlags;
    }

    public int getExpansionFlags() {
        return this.expansionFlags;
    }

    protected boolean shouldExpand(Archive anArchive) {
        int flag = 0;
        flag = anArchive.isWARFile() ? 2 : (anArchive.isEARFile() ? 4 : (anArchive.isRARFile() ? 64 : (anArchive.isEJBJarFile() ? 8 : (anArchive.isApplicationClientFile() ? 16 : 32))));
        return (this.getExpansionFlags() & flag) != 0;
    }

    protected boolean shouldIterateOver(Archive anArchive) {
        return super.shouldIterateOver(anArchive) || this.shouldExpand(anArchive);
    }

    public void setUriConverter(URIConverter newUriConverter) {
        this.uriConverter = newUriConverter;
    }

    public URIConverter getUriConverter() {
        return this.uriConverter;
    }

    protected OutputStream getOutputStreamForResource(Resource aResource) throws IOException {
        return this.getUriConverter().createOutputStream(aResource.getURI());
    }

    public DirectorySaveStrategyImpl() {
    }

    public DirectorySaveStrategyImpl(String dirName, int flags) {
        logger.logp(Level.FINER, className, "Constructor(String, int) on dir [ {0} ]", dirName);
        this.setDirectoryName(dirName);
        this.setExpansionFlags(flags);
        this.initialize();
    }

    public void initialize() {
        ArchiveURIConverterImpl converter = new ArchiveURIConverterImpl(this.getArchive(), this.getDirectoryName());
        converter.setOutputFilepath(this.getDirectoryName());
        this.setUriConverter(converter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(ArchiveManifest aManifest) throws SaveFailureException {
        String methodName = "save(ArchiveManifest)";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        try {
            OutputStream out = this.getUriConverter().createOutputStream(URI.createURI("META-INF/MANIFEST.MF"));
            try {
                aManifest.write(out);
            }
            finally {
                out.close();
            }
            if (this.getArchive().getOptions().isReadOnly()) {
                this.setTimestampAfterSaving("META-INF/MANIFEST.MF");
            }
        }
        catch (IOException iox) {
            throw new SaveFailureException("META-INF/MANIFEST.MF", iox);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File aFile, InputStream in) throws SaveFailureException {
        String methodName;
        block16: {
            methodName = "save(File, InputStream)";
            String entryName = aFile.getURI();
            logger.logp(Level.FINER, className, methodName, "File URI [ {0} ]", entryName);
            java.io.File tempFile = null;
            String tempName = null;
            try {
                OutputStream out;
                if (this.saveIncrementally()) {
                    try {
                        tempFile = ArchiveUtil.createTempFile(BASE_TEMP_FILE);
                        tempName = tempFile.getName();
                    }
                    catch (IOException e) {
                        throw new SaveFailureException("Failed to create temp file for [ " + entryName + " ]", e);
                    }
                    try {
                        out = new FileOutputStream(tempFile);
                    }
                    catch (IOException e) {
                        throw new SaveFailureException("Failed to open output stream to temp file [ " + tempName + " ] for [ " + entryName + " ]", e);
                    }
                    try {
                        ArchiveUtil.copy(in, out);
                    }
                    catch (IOException e) {
                        throw new SaveFailureException("Failed to transfer to temp file [ " + tempName + " ] for [ " + entryName + " ]", e);
                    }
                    try {
                        in = new FileInputStream(tempFile);
                    }
                    catch (IOException e) {
                        throw new SaveFailureException("Failed to reopen temp file [ " + tempName + " ] for [ " + entryName + " ]", e);
                    }
                }
                if (aFile.isDirectoryEntry()) {
                    this.mkdirs(entryName);
                    break block16;
                }
                try {
                    out = this.getUriConverter().createOutputStream(URI.createURI(entryName));
                    ArchiveUtil.copy(in, out);
                    this.setTimestampAfterSaving(aFile);
                }
                catch (IOException iox) {
                    throw new SaveFailureException("Failed to save [ " + entryName + " ]", iox);
                }
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMofResource(Resource aResource, OutputStream os) throws IOException {
        try {
            super.saveMofResource(aResource, os);
        }
        finally {
            os.close();
        }
    }

    protected void setTimestampAfterSaving(File aFile) {
        long lastMod = aFile.getLastModified();
        if (lastMod == 0L) {
            return;
        }
        String absPath = ArchiveUtil.getOSUri(this.getDirectoryName(), aFile.getURI());
        java.io.File ioFile = new java.io.File(absPath);
        ioFile.setLastModified(lastMod);
    }

    protected void setTimestampAfterSaving(String uri) {
        File aFile = null;
        try {
            aFile = this.getArchive().getFile(uri);
        }
        catch (FileNotFoundException mustBeANewEntry) {
            return;
        }
        this.setTimestampAfterSaving(aFile);
    }

    protected SaveStrategy createNestedSaveStrategy(Archive anArchive) throws IOException {
        if (this.shouldExpand(anArchive)) {
            return this.createNestedDirectoryStrategy(anArchive);
        }
        return this.createNestedZipStrategy(anArchive);
    }

    protected SaveStrategy createNestedDirectoryStrategy(Archive anArchive) {
        String methodName = "createNestedDirectoryStrategy";
        String archiveUri = anArchive.getURI();
        String useDirName = this.getDirectoryName();
        logger.logp(Level.FINER, className, methodName, "For archive [ {0} ]", archiveUri);
        logger.logp(Level.FINER, className, methodName, "From directory [ {0} ]", useDirName);
        String uri = ArchiveUtil.getOSUri(useDirName, archiveUri);
        return new DirectorySaveStrategyImpl(uri, this.getExpansionFlags());
    }

    protected SaveStrategy createNestedZipStrategy(Archive anArchive) throws IOException {
        String methodName = "createNestedZipStrategy";
        String archiveUri = anArchive.getURI();
        String useDirName = this.getDirectoryName();
        logger.logp(Level.FINER, className, methodName, "For archive [ {0} ]", archiveUri);
        logger.logp(Level.FINER, className, methodName, "From directory [ {0} ]", useDirName);
        OutputStream out = this.getUriConverter().createOutputStream(URI.createURI(archiveUri));
        return new ZipStreamSaveStrategyImpl(out);
    }
}

