/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import com.ibm.icu.util.StringTokenizer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class ArchiveManifestImpl
extends Manifest
implements ArchiveManifest {
    public ArchiveManifestImpl() {
    }

    public ArchiveManifestImpl(InputStream is) throws IOException {
        super(is);
    }

    public ArchiveManifestImpl(Manifest man) {
        super(man);
    }

    public void addEntry(String entryName) {
        Attributes attr = new Attributes();
        this.addEntry(entryName, attr);
    }

    public void addEntry(String entryName, Attributes attr) {
        this.getEntries().put(entryName, attr);
    }

    public void addEntryAttribute(String entryName, String key, String value) {
        Attributes attr = this.getAttributes(entryName);
        if (attr == null) {
            this.addEntry(entryName);
        }
        attr = this.getAttributes(entryName);
        attr.putValue(key, value);
    }

    public void addVersionIfNecessary() {
        if (this.getManifestVersion() == null || this.getManifestVersion().equals("")) {
            this.setManifestVersion("1.0");
        }
    }

    public void appendClassPath(String extension2) {
        String classPath = this.getClassPath();
        if (classPath != null) {
            this.setClassPath(classPath + " " + extension2);
        } else {
            this.setClassPath(extension2);
        }
    }

    public String getClassPath() {
        return ArchiveUtil.getValueIgnoreKeyCase(Attributes.Name.CLASS_PATH.toString(), this.getMainAttributes());
    }

    public String[] getClassPathTokenized() {
        String classPath = this.getClassPath();
        if (classPath == null) {
            return new String[0];
        }
        return ArchiveUtil.getTokens(classPath);
    }

    public String getEntryAttribute(String entryName, String key) {
        Attributes attr = this.getAttributes(entryName);
        if (attr == null) {
            return null;
        }
        return attr.getValue(key);
    }

    public String getMainClass() {
        return ArchiveUtil.getValueIgnoreKeyCase(Attributes.Name.MAIN_CLASS.toString(), this.getMainAttributes());
    }

    public String getManifestVersion() {
        return this.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION);
    }

    public void mergeClassPath(String[] classPathEntries) {
        StringBuffer sb = new StringBuffer();
        List<String> existing = Arrays.asList(this.getClassPathTokenized());
        String cp = this.getClassPath();
        if (cp != null) {
            sb.append(cp);
        }
        boolean empty = cp == null || "".equals(cp);
        for (int i = 0; i < classPathEntries.length; ++i) {
            if (existing.contains(classPathEntries[i])) continue;
            if (!empty) {
                sb.append(" ");
            } else {
                empty = false;
            }
            sb.append(classPathEntries[i]);
        }
        this.setClassPath(sb.toString());
    }

    public void removeEntry(String entryName) {
        this.getEntries().remove(entryName);
    }

    public void removeEntryAttribute(String entryName, Object key) {
        Attributes attr = this.getAttributes(entryName);
        if (attr != null) {
            attr.remove(key);
        }
    }

    public void setClassPath(String aSpaceDelimitedPath) {
        Attributes attributes = this.getMainAttributes();
        if (aSpaceDelimitedPath == null) {
            attributes.remove(Attributes.Name.CLASS_PATH);
        } else {
            attributes.putValue(Attributes.Name.CLASS_PATH.toString(), aSpaceDelimitedPath);
        }
    }

    public void setMainClass(String className) {
        Attributes attributes = this.getMainAttributes();
        if (className == null) {
            attributes.remove(Attributes.Name.MAIN_CLASS);
        } else {
            attributes.putValue(Attributes.Name.MAIN_CLASS.toString(), className);
        }
    }

    public void setManifestVersion(String version) {
        Attributes attributes = this.getMainAttributes();
        attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), version);
    }

    public void writeSplittingClasspath(OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        this.writeMainSplittingClasspath(this.getMainAttributes(), dos);
        for (Map.Entry<String, Attributes> e : this.getEntries().entrySet()) {
            StringBuffer buffer = new StringBuffer("Name: ");
            buffer.append(e.getKey());
            buffer.append("\r\n");
            ArchiveManifestImpl.localMake72Safe(buffer);
            dos.writeBytes(buffer.toString());
            this.write(e.getValue(), dos);
        }
        dos.flush();
    }

    protected void write(Attributes attributes, DataOutputStream os) throws IOException {
        for (Map.Entry<Object, Object> e : attributes.entrySet()) {
            StringBuffer buffer = new StringBuffer(((Attributes.Name)e.getKey()).toString());
            buffer.append(": ");
            buffer.append(this.toUtf8((String)e.getValue()));
            buffer.append("\r\n");
            ArchiveManifestImpl.localMake72Safe(buffer);
            os.writeBytes(buffer.toString());
        }
        os.writeBytes("\r\n");
    }

    protected void writeMainSplittingClasspath(Attributes attributes, DataOutputStream out) throws IOException {
        String vername = Attributes.Name.MANIFEST_VERSION.toString();
        String version = this.toUtf8(attributes.getValue(vername));
        if (version == null) {
            vername = Attributes.Name.SIGNATURE_VERSION.toString();
            version = this.toUtf8(attributes.getValue(vername));
        }
        if (version != null) {
            out.writeBytes(vername + ": " + version + "\r\n");
        }
        for (Map.Entry<Object, Object> e : attributes.entrySet()) {
            String name = ((Attributes.Name)e.getKey()).toString();
            if (version == null || name.equalsIgnoreCase(vername)) continue;
            if (name.equalsIgnoreCase(Attributes.Name.CLASS_PATH.toString())) {
                this.writeSplit(out, name, this.toUtf8((String)e.getValue()));
                continue;
            }
            StringBuffer buffer = new StringBuffer(name);
            buffer.append(": ");
            buffer.append(this.toUtf8((String)e.getValue()));
            buffer.append("\r\n");
            ArchiveManifestImpl.localMake72Safe(buffer);
            out.writeBytes(buffer.toString());
        }
        out.writeBytes("\r\n");
    }

    protected void writeSplit(DataOutputStream out, String name, String value) throws IOException {
        StringTokenizer tok = new StringTokenizer(value);
        int inc = 0;
        while (tok.hasMoreTokens()) {
            StringBuffer buffer = null;
            if (inc == 0) {
                buffer = new StringBuffer(name);
                buffer.append(": ");
            } else {
                buffer = new StringBuffer();
                buffer.append(' ');
            }
            buffer.append(tok.nextToken());
            if (tok.countTokens() > 0) {
                buffer.append(" \r\n");
            } else {
                buffer.append("\r\n");
            }
            ArchiveManifestImpl.localMake72Safe(buffer);
            out.writeBytes(buffer.toString());
            ++inc;
        }
    }

    protected static void localMake72Safe(StringBuffer line) {
        int length = line.length();
        if (length > 72) {
            int index = 70;
            while (index - 1 < length) {
                line.insert(index, "\r\n ");
                index += 72;
                length += 3;
            }
        }
    }

    public String getImplementationVersion() {
        return this.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    public void setImplemenationVersion(String version) {
        Attributes attributes = this.getMainAttributes();
        attributes.putValue(Attributes.Name.IMPLEMENTATION_VERSION.toString(), version);
    }

    private String toUtf8(String str) throws IOException {
        if (str == null) {
            return null;
        }
        byte[] utf8 = str.getBytes("UTF-8");
        return new String(utf8, 0, 0, utf8.length);
    }
}

