/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.XmlValidationResult;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.internal.xml.CollectingErrorHandler;
import org.eclipse.jst.j2ee.internal.xml.XmlDocumentReader;
import org.xml.sax.InputSource;

public class ValidateXmlCommand
extends AbstractCommand {
    protected List results;
    protected ModuleFile archive;
    public boolean validateNested = true;

    protected ValidateXmlCommand() {
    }

    public ValidateXmlCommand(ModuleFile m) {
        this.archive = m;
    }

    protected ValidateXmlCommand(String label) {
        super(label);
    }

    protected ValidateXmlCommand(String label, String description) {
        super(label, description);
    }

    public void execute() {
        this.results = new ArrayList();
        this.validatateXml();
        if (this.isValidateNested()) {
            List archives = this.archive.getArchiveFiles();
            for (int i = 0; i < archives.size(); ++i) {
                Archive a = (Archive)archives.get(i);
                if (!a.isModuleFile()) continue;
                ModuleFile m = (ModuleFile)a;
                ValidateXmlCommand cmd = new ValidateXmlCommand(m);
                cmd.execute();
                this.results.addAll(cmd.getResult());
            }
        }
    }

    public Collection getResult() {
        return this.results;
    }

    public boolean isValidateNested() {
        return this.validateNested;
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
    }

    public void setValidateNested(boolean newValidateNested) {
        this.validateNested = newValidateNested;
    }

    protected void validatateXml() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Resource res = this.archive.getStandardDeploymentDescriptor().eResource();
        XmlValidationResult result = new XmlValidationResult();
        result.setArchive(this.archive);
        try {
            res.save(bos, new HashMap());
        }
        catch (Exception ex) {
            throw new ArchiveRuntimeException(ex);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(bos.toByteArray());
        InputSource source = new InputSource(inStream);
        CollectingErrorHandler handler = new CollectingErrorHandler();
        XmlDocumentReader parseAdapter = new XmlDocumentReader(source, null, handler);
        try {
            parseAdapter.parseDocument();
        }
        catch (RuntimeException re) {
            if (handler.getCaughtExceptions() != null) {
                result.setArchive(this.archive);
                result.setCaughtExceptions(handler.getCaughtExceptions());
                this.results.add(result);
            }
            throw re;
        }
        result.setArchive(this.archive);
        result.setCaughtExceptions(handler.getCaughtExceptions());
        this.results.add(result);
    }
}

