/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.client.internal.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.common.internal.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.model.translator.client.ApplicationClientTranslator;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class ApplicationClientResourceImpl
extends XMLResourceImpl
implements ApplicationClientResource {
    public static final String CLASS_NAME = ApplicationClientResourceImpl.class.getName();

    public ApplicationClientResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public ApplicationClientResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    public ApplicationClient getApplicationClient() {
        return (ApplicationClient)this.getRootObject();
    }

    public Translator getRootTranslator() {
        return ApplicationClientTranslator.INSTANCE;
    }

    public int getType() {
        return 1;
    }

    public String getDoctype() {
        int j2eeVersionId = this.getJ2EEVersionID();
        if (j2eeVersionId == 12) {
            return "application-client";
        }
        if (j2eeVersionId == 13) {
            return "application-client";
        }
        return null;
    }

    public int getJ2EEVersionID() {
        return this.getModuleVersionID();
    }

    protected int getDefaultVersionID() {
        return this.getDefaultModuleVersionID();
    }

    protected int getDefaultModuleVersionID() {
        return 50;
    }

    public String getJ2EE_1_2_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN";
    }

    public String getJ2EE_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/application-client_1_2.dtd";
    }

    public String getJ2EE_Alt_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/application-client_1.2.dtd";
    }

    public String getJ2EE_1_3_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN";
    }

    public String getJ2EE_1_3_SystemID() {
        return "http://java.sun.com/dtd/application-client_1_3.dtd";
    }

    public String getJ2EE_Alt_1_3_SystemID() {
        return "http://java.sun.com/dtd/application-client_1.3.dtd";
    }

    public void setModuleVersionID(int moduleVersionId) {
        this.primSetVersionID(moduleVersionId);
        if (moduleVersionId == 50) {
            this.primSetDoctypeValues(null, null);
        } else if (moduleVersionId == 14) {
            this.primSetDoctypeValues(null, null);
        } else if (moduleVersionId == 13) {
            this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
        } else if (moduleVersionId == 12) {
            this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
        } else {
            this.primSetDoctypeValues(null, null);
            this.unrecognizedModuleVersionID(CLASS_NAME, "setModuleVersionID", moduleVersionId);
        }
        this.syncVersionOfRootObject();
    }

    public void setJ2EEVersionID(int j2eeVersionId) {
        this.primSetVersionID(j2eeVersionId);
        if (j2eeVersionId == 50) {
            this.primSetDoctypeValues(null, null);
        } else if (j2eeVersionId == 14) {
            this.primSetDoctypeValues(null, null);
        } else if (j2eeVersionId == 13) {
            this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
        } else if (j2eeVersionId == 12) {
            this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
        } else {
            this.primSetDoctypeValues(null, null);
            this.unrecognizedJ2EEVersionID(CLASS_NAME, "setJ2EEVersionID", j2eeVersionId);
        }
        this.syncVersionOfRootObject();
    }

    protected void syncVersionOfRootObject() {
        ApplicationClient clt = this.getApplicationClient();
        if (clt == null) {
            return;
        }
        String version = clt.getVersion();
        String newVersion = this.getModuleVersionString();
        if (!newVersion.equals(version)) {
            clt.setVersion(newVersion);
        }
    }

    public int lookupModuleVersionId(String schemaName) {
        if (schemaName == null) {
            return -1;
        }
        if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd")) {
            return 14;
        }
        if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application-client_5.xsd")) {
            return 50;
        }
        return -1;
    }

    public int lookupModuleVersionId(String publicId, String systemId) {
        if (publicId == null || systemId == null) {
            return -1;
        }
        if (publicId.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN") && (systemId.equals("http://java.sun.com/j2ee/dtds/application-client_1_2.dtd") || systemId.equals("http://java.sun.com/j2ee/dtds/application-client_1.2.dtd"))) {
            return 12;
        }
        if (publicId.equals("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN") && (systemId.equals("http://java.sun.com/dtd/application-client_1_3.dtd") || systemId.equals("http://java.sun.com/dtd/application-client_1.3.dtd"))) {
            return 13;
        }
        return -1;
    }

    public int parseModuleVersionId(String versionString) {
        if (versionString == null) {
            return -1;
        }
        if (versionString.equals("1.2")) {
            return 12;
        }
        if (versionString.equals("1.3")) {
            return 13;
        }
        if (versionString.equals("1.4")) {
            return 14;
        }
        if (versionString.equals("5")) {
            return 50;
        }
        return -1;
    }
}

