/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public abstract class J2EEUtilityJarImportAssistantOperation
extends AbstractOperation {
    private File utilityJar;
    private boolean overwriteIfNecessary = false;
    private String associatedEARProjectName;

    public J2EEUtilityJarImportAssistantOperation(String label, File utilityJar) {
        super(label);
        this.utilityJar = utilityJar;
    }

    public void setAssociatedEARProjectName(String associatedEARProjectName) {
        this.associatedEARProjectName = associatedEARProjectName;
    }

    public void setOverwriteIfNecessary(boolean overwriteProject) {
        this.overwriteIfNecessary = overwriteProject;
    }

    protected final void createLinkedPathVariable(String linkedPathVariable, File archiveFile) throws CoreException {
        IPathVariableManager manager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        Path linkedPath = new Path(archiveFile.getAbsolutePath());
        manager.setValue(linkedPathVariable, (IPath)linkedPath);
    }

    protected final String getUtilityJarProjectName(File utilityJar) {
        String name = null;
        if (utilityJar != null) {
            int len = utilityJar.getName().lastIndexOf(46);
            name = utilityJar.getName().substring(0, len);
        }
        return name;
    }

    protected final IStatus linkArchiveToEAR(IProject earProject, String uriMapping, IProject utilityProject, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, ExecutionException {
        IDataModel addArchiveProjectToEARDataModel = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        IVirtualComponent earcomponent = ComponentCore.createComponent((IProject)earProject);
        IVirtualComponent utilcomponent = ComponentCore.createComponent((IProject)utilityProject);
        addArchiveProjectToEARDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", earcomponent);
        addArchiveProjectToEARDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", Collections.singletonList(utilcomponent));
        HashMap<IVirtualComponent, String> uriMap = new HashMap<IVirtualComponent, String>();
        uriMap.put(utilcomponent, uriMapping);
        addArchiveProjectToEARDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", uriMap);
        return addArchiveProjectToEARDataModel.getDefaultOperation().execute(monitor, null);
    }

    protected final IStatus createVirtualArchiveComponent(IProject targetProject, String uriMapping, IFile utilityJarIFile, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, ExecutionException {
        IDataModel addArchiveProjectToEARDataModel = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        IVirtualComponent earcomponent = ComponentCore.createComponent((IProject)targetProject);
        IVirtualComponent utilcomponent = ComponentCore.createArchiveComponent((IProject)targetProject, (String)("lib/" + utilityJarIFile.getProjectRelativePath().toString()));
        addArchiveProjectToEARDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", earcomponent);
        addArchiveProjectToEARDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", Collections.singletonList(utilcomponent));
        HashMap<IVirtualComponent, String> uriMap = new HashMap<IVirtualComponent, String>();
        uriMap.put(utilcomponent, uriMapping);
        addArchiveProjectToEARDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", uriMap);
        return addArchiveProjectToEARDataModel.getDefaultOperation().execute(monitor, null);
    }

    protected final IStatus removeRootMapping(IVirtualComponent sourceComponent, String uriMapping, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, ExecutionException {
        try {
            sourceComponent.getRootFolder().removeLink((IPath)new Path(uriMapping), 0, monitor);
        }
        catch (CoreException e) {
            return J2EEPlugin.createErrorStatus(0, e.getMessage(), e);
        }
        return Status.OK_STATUS;
    }

    protected File getUtilityJar() {
        return this.utilityJar;
    }

    protected final IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected final String getAssociatedEARProjectName() {
        return this.associatedEARProjectName;
    }

    protected final boolean isOverwriteIfNecessary() {
        return this.overwriteIfNecessary;
    }

    protected final void addLibraryToClasspath(IProject associatedEARProject, IFile copiedJarFile, IProgressMonitor monitor) throws CoreException, JavaModelException {
        if (associatedEARProject.hasNature("org.eclipse.jdt.core.javanature")) {
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)copiedJarFile.getFullPath().makeAbsolute(), null, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
            IJavaProject earJavaProject = JavaCore.create((IProject)associatedEARProject);
            IClasspathEntry[] rawClasspath = earJavaProject.getRawClasspath();
            IClasspathEntry[] newClasspath = new IClasspathEntry[rawClasspath.length + 1];
            System.arraycopy(rawClasspath, 0, newClasspath, 0, rawClasspath.length);
            newClasspath[rawClasspath.length] = entry;
            earJavaProject.setRawClasspath(newClasspath, monitor);
        }
    }

    protected final IStatus createLinkedArchive(IProject project, String linkedFileName, File archiveFile, String linkedPathVariable, IProgressMonitor monitor) throws CoreException {
        IFile linkedJarFile = null;
        IPath pathToArchive = this.getLinkedPath(archiveFile, linkedPathVariable);
        linkedJarFile = project.getFile(linkedFileName);
        if (linkedJarFile.exists()) {
            if (this.isOverwriteIfNecessary()) {
                linkedJarFile.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                return J2EEPlugin.createErrorStatus(0, NLS.bind((String)EARCreationResourceHandler.CreateProjectWithLinkedJarOperation_File_already_exists_0_, (Object)linkedJarFile.getFullPath()), null);
            }
        }
        linkedJarFile.createLink(pathToArchive, 16, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.addLibraryToClasspath(project, linkedJarFile, monitor);
        return Status.OK_STATUS;
    }

    protected final IPath getLinkedPath(File archiveFile, String linkedPathVariable) throws CoreException {
        if (linkedPathVariable == null || linkedPathVariable.length() == 0) {
            return new Path(archiveFile.getAbsolutePath());
        }
        this.createLinkedPathVariable(linkedPathVariable, archiveFile.getParentFile());
        return new Path(linkedPathVariable).append(archiveFile.getName());
    }

    protected final String findUniqueLocation(String baseLocation, String proposedProjectName) {
        return baseLocation != null ? String.valueOf(baseLocation) + File.separator + proposedProjectName : null;
    }
}

