/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentExportDataModelProperties;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public abstract class J2EEArtifactExportDataModelProvider
extends AbstractDataModelProvider
implements IJ2EEComponentExportDataModelProperties {
    public HashMap componentMap;

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IJ2EEComponentExportDataModelProperties.PROJECT_NAME");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.RUN_BUILD");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.COMPONENT");
        return propertyNames;
    }

    protected abstract String getProjectType();

    protected abstract String getWrongComponentTypeString(String var1);

    protected abstract String getModuleExtension();

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION")) {
            return "";
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.RUN_BUILD")) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean set = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.PROJECT_NAME")) {
            IVirtualComponent component2;
            if (this.getComponentMap().isEmpty()) {
                this.intializeComponentMap();
            }
            if ((component2 = (IVirtualComponent)this.getComponentMap().get(propertyValue)) != null && component2.getName().equals(propertyValue)) {
                this.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", component2);
            } else {
                this.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", null);
            }
        }
        return set;
    }

    public HashMap getComponentMap() {
        if (this.componentMap == null) {
            this.componentMap = new HashMap();
        }
        return this.componentMap;
    }

    public void intializeComponentMap() {
        IVirtualComponent[] comps = ComponentUtilities.getAllWorkbenchComponents();
        int i = 0;
        while (i < comps.length) {
            this.getComponentMap().put(comps[i].getName(), comps[i]);
            ++i;
        }
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.PROJECT_NAME")) {
            ArrayList<String> componentNames = new ArrayList<String>();
            IVirtualComponent[] wbComps = ComponentUtilities.getAllWorkbenchComponents();
            ArrayList<IVirtualComponent> relevantComponents = new ArrayList<IVirtualComponent>();
            int i = 0;
            while (i < wbComps.length) {
                if (J2EEProjectUtilities.getJ2EEProjectType(wbComps[i].getProject()).equals(this.getProjectType())) {
                    relevantComponents.add(wbComps[i]);
                    this.getComponentMap().put(wbComps[i].getName(), wbComps[i]);
                }
                ++i;
            }
            if (relevantComponents == null || relevantComponents.size() == 0) {
                return null;
            }
            int j = 0;
            while (j < relevantComponents.size()) {
                componentNames.add(((IVirtualComponent)relevantComponents.get(j)).getName());
                ++j;
            }
            Object[] names = componentNames.toArray(new String[componentNames.size()]);
            return DataModelPropertyDescriptor.createDescriptors(names);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public IStatus validate(String propertyName) {
        String location;
        if ("IJ2EEComponentExportDataModelProperties.PROJECT_NAME".equals(propertyName)) {
            String projectName = (String)this.model.getProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME");
            if (projectName == null || projectName.equals("")) {
                return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("38"));
            }
            IVirtualComponent component2 = (IVirtualComponent)this.componentMap.get(projectName);
            if (component2 == null) {
                return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("38"));
            }
            if (!J2EEProjectUtilities.getJ2EEProjectType(component2.getProject()).equals(this.getProjectType())) {
                return WTPCommonPlugin.createErrorStatus(this.getWrongComponentTypeString(projectName));
            }
        }
        if ("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION".equals(propertyName)) {
            IStatus tempStatus;
            String archiveLocation = (String)this.model.getProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION");
            if (!this.model.isPropertySet("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION") || archiveLocation.equals("")) {
                return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("10"));
            }
            if (this.model.isPropertySet("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION") && !this.validateModuleType(archiveLocation)) {
                return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("9", new Object[]{this.getModuleExtension()}));
            }
            if (this.model.isPropertySet("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION") && (tempStatus = this.validateLocation(archiveLocation)) != OK_STATUS) {
                return tempStatus;
            }
        }
        if (("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION".equals(propertyName) || "IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING".equals(propertyName)) && this.checkForExistingFileResource(location = (String)this.getProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION"))) {
            return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("12", new Object[]{location}));
        }
        return OK_STATUS;
    }

    private IStatus validateLocation(String archiveLocation) {
        Path path = null;
        try {
            path = new Path(archiveLocation);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("10"));
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(path.lastSegment(), 1);
        if (!status.isOK()) {
            return status;
        }
        String device = path.getDevice();
        if (device == null) {
            return OK_STATUS;
        }
        if (path == null || device.length() == 1 && device.charAt(0) == ':') {
            return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("10"));
        }
        if (!path.toFile().canWrite()) {
            if (path.toFile().exists()) {
                return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("11"));
            }
            boolean OK = false;
            path = path.removeLastSegments(1);
            int i = 1;
            while (!OK && i < 20 && path.segmentCount() > 0) {
                if (path.toFile().exists()) {
                    OK = true;
                }
                if (!(status = workspace.validateName(path.lastSegment(), 2)).isOK()) {
                    return WTPCommonPlugin.createErrorStatus(WTPCommonPlugin.getResourceString("10"));
                }
                path = path.removeLastSegments(1);
                ++i;
            }
        }
        return OK_STATUS;
    }

    private boolean checkForExistingFileResource(String fileName) {
        File externalFile;
        return !this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING") && (externalFile = new File(fileName)) != null && externalFile.exists();
    }

    private boolean validateModuleType(String archive) {
        return archive.length() >= 4 && archive.substring(archive.length() - 4, archive.length()).equalsIgnoreCase(this.getModuleExtension());
    }
}

