/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.adapters.jdk;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jem.internal.java.adapters.IJavaMethodAdapter;
import org.eclipse.jem.internal.java.adapters.jdk.JDKAdaptor;
import org.eclipse.jem.internal.java.adapters.jdk.JavaClassJDKAdaptor;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jem.java.internal.impl.MethodImpl;

public class JavaMethodJDKAdaptor
extends JDKAdaptor
implements IJavaMethodAdapter {
    protected AccessibleObject sourceAccessible = null;
    protected Class parentType = null;
    protected static Class[] emptyClassArray = new Class[0];
    protected static String[] emptyStringArray = new String[0];

    public JavaMethodJDKAdaptor(Notifier target, JavaJDKAdapterFactory anAdapterFactory) {
        super(target, anAdapterFactory);
    }

    protected void addExceptions() {
        Class<?>[] exceptions = this.getSourceAccessible() instanceof java.lang.reflect.Method ? ((java.lang.reflect.Method)this.getSourceAccessible()).getExceptionTypes() : ((Constructor)this.getSourceAccessible()).getExceptionTypes();
        EList exList = this.getMethodTarget().getJavaExceptionsGen();
        int i = 0;
        while (i < exceptions.length) {
            exList.add(this.createJavaClassRef(exceptions[i].getName()));
            ++i;
        }
    }

    protected MethodImpl getMethodTarget() {
        return (MethodImpl)this.getTarget();
    }

    protected void addParameters() {
        Class<?>[] parmTypes = this.getSourceAccessible() instanceof java.lang.reflect.Method ? ((java.lang.reflect.Method)this.getSourceAccessible()).getParameterTypes() : ((Constructor)this.getSourceAccessible()).getParameterTypes();
        MethodImpl javaMethodTarget = this.getMethodTarget();
        EList pList = javaMethodTarget.getParametersGen();
        int i = 0;
        while (i < parmTypes.length) {
            pList.add(this.createJavaParameter(javaMethodTarget, "arg" + i, JavaMethodJDKAdaptor.getTypeName(parmTypes[i])));
            ++i;
        }
    }

    protected JavaClass getContainingJavaClass() {
        return ((Method)this.getTarget()).getContainingJavaClass();
    }

    protected Class getParentType() {
        Method targetMethod;
        JavaClass parentJavaClass;
        JavaClassJDKAdaptor pa;
        if (this.parentType == null && (pa = (JavaClassJDKAdaptor)EcoreUtil.getAdapter((parentJavaClass = (targetMethod = (Method)this.getTarget()).getContainingJavaClass()).eAdapters(), "JavaReflection")) != null) {
            this.parentType = pa.getSourceType();
        }
        return this.parentType;
    }

    protected Class[] getParmTypes() {
        Method javaMethodTarget = (Method)this.getTarget();
        String id = ((XMIResource)javaMethodTarget.eResource()).getID(javaMethodTarget);
        String[] typeNames = JavaMethodJDKAdaptor.getTypeNamesFromMethodID(id);
        if (typeNames == null) {
            return emptyClassArray;
        }
        int n = typeNames.length;
        if (n == 0) {
            return emptyClassArray;
        }
        Class[] types = new Class[n];
        int i = 0;
        while (i < n) {
            types[i] = this.getType(typeNames[i]);
            ++i;
        }
        return types;
    }

    public Object getReflectionSource() {
        return this.getSourceAccessible();
    }

    public boolean hasCachedReflectionSource() {
        return this.sourceAccessible != null;
    }

    protected AccessibleObject getSourceAccessible() {
        Class parent;
        if (this.sourceAccessible == null && (parent = this.getParentType()) != null) {
            Class[] parmTypes = this.getParmTypes();
            try {
                this.sourceAccessible = parent.getDeclaredMethod(((Method)this.getTarget()).getName(), parmTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (this.sourceAccessible == null) {
                try {
                    this.sourceAccessible = parent.getDeclaredConstructor(parmTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        return this.sourceAccessible;
    }

    public Object getValueIn(EObject object, EObject attribute) {
        return super.getValueIn(object, attribute);
    }

    public boolean reflectValues() {
        if (this.getSourceAccessible() != null) {
            ((Method)this.getTarget()).setIsGenerated(false);
            this.setModifiers();
            this.setNaming();
            this.setReturnType();
            this.addParameters();
            this.addExceptions();
            return true;
        }
        return false;
    }

    public boolean reflectGeneratedIfNecessary() {
        return this.reflectValuesIfNecessary();
    }

    public boolean reflectParamNamesIfNecessary() {
        return this.reflectValuesIfNecessary();
    }

    protected void setModifiers() {
        Method methodTarget = (Method)this.getTarget();
        int modifiers = this.getSourceAccessible() instanceof java.lang.reflect.Method ? ((java.lang.reflect.Method)this.getSourceAccessible()).getModifiers() : ((Constructor)this.getSourceAccessible()).getModifiers();
        methodTarget.setAbstract(Modifier.isAbstract(modifiers));
        methodTarget.setFinal(Modifier.isFinal(modifiers));
        methodTarget.setNative(Modifier.isNative(modifiers));
        methodTarget.setStatic(Modifier.isStatic(modifiers));
        methodTarget.setSynchronized(Modifier.isSynchronized(modifiers));
        methodTarget.setConstructor(this.getSourceAccessible() instanceof Constructor);
        JavaClass javaClass = this.getContainingJavaClass();
        if (javaClass.getKind() == TypeKind.INTERFACE_LITERAL || Modifier.isPublic(modifiers)) {
            methodTarget.setJavaVisibility(JavaVisibilityKind.PUBLIC_LITERAL);
        } else if (Modifier.isPrivate(modifiers)) {
            methodTarget.setJavaVisibility(JavaVisibilityKind.PRIVATE_LITERAL);
        } else if (Modifier.isProtected(modifiers)) {
            methodTarget.setJavaVisibility(JavaVisibilityKind.PROTECTED_LITERAL);
        } else {
            methodTarget.setJavaVisibility(JavaVisibilityKind.PACKAGE_LITERAL);
        }
    }

    protected void setNaming() {
    }

    protected void setReturnType() {
        if (this.getSourceAccessible() instanceof java.lang.reflect.Method) {
            Class<?> type = ((java.lang.reflect.Method)this.getSourceAccessible()).getReturnType();
            Method javaMethodTarget = (Method)this.getTarget();
            javaMethodTarget.setEType(this.createJavaClassRef(JavaMethodJDKAdaptor.getTypeName(type)));
        }
    }
}

