/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.adapters.jdk;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;

public abstract class JDKAdaptor
extends JavaReflectionAdaptor {
    public JavaJDKAdapterFactory adapterFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public JDKAdaptor(Notifier target, JavaJDKAdapterFactory anAdapterFactory) {
        super(target);
        this.setAdapterFactory(anAdapterFactory);
    }

    public static String computeMethodID(Constructor jdkConstructor) {
        StringBuffer out = new StringBuffer();
        String className = JDKAdaptor.getSimpleName(jdkConstructor.getDeclaringClass().getName());
        out.append(className);
        out.append('.');
        out.append(JDKAdaptor.computeMethodName(jdkConstructor));
        out.append('(');
        Class<?>[] parmTypes = jdkConstructor.getParameterTypes();
        int i = 0;
        while (i < parmTypes.length) {
            out.append(parmTypes[i].getName());
            if (i < parmTypes.length - 1) {
                out.append(',');
            }
            ++i;
        }
        out.append("_V");
        return out.toString();
    }

    public static String computeMethodID(java.lang.reflect.Method jdkMethod) {
        StringBuffer out = new StringBuffer();
        String className = JDKAdaptor.getSimpleName(jdkMethod.getDeclaringClass().getName());
        out.append(className);
        out.append('.');
        out.append(JDKAdaptor.computeMethodName(jdkMethod));
        out.append('(');
        Class<?>[] parmTypes = jdkMethod.getParameterTypes();
        int i = 0;
        while (i < parmTypes.length) {
            out.append(parmTypes[i].getName());
            if (i < parmTypes.length - 1) {
                out.append(',');
            }
            ++i;
        }
        if (jdkMethod.getDeclaringClass().getName().equals(jdkMethod.getName())) {
            out.append("_V");
        }
        return out.toString();
    }

    public static String computeMethodName(Constructor jdkConstructor) {
        return JDKAdaptor.getSimpleName(jdkConstructor.getName());
    }

    public static String computeMethodName(java.lang.reflect.Method jdkMethod) {
        return jdkMethod.getName();
    }

    public Field createJavaField(java.lang.reflect.Field reflectedField, XMIResource resource) {
        Field newField = JDKAdaptor.getJavaFactory().createField();
        newField.setName(reflectedField.getName());
        String className = JDKAdaptor.getSimpleName(reflectedField.getDeclaringClass().getName());
        resource.setID(newField, String.valueOf(className) + '.' + reflectedField.getName());
        return newField;
    }

    public Method createJavaMethod(Constructor jdkConstructor, XMIResource resource) {
        Method newMethod = JDKAdaptor.getJavaFactory().createMethod();
        newMethod.setName(JDKAdaptor.computeMethodName(jdkConstructor));
        resource.setID(newMethod, JDKAdaptor.computeMethodID(jdkConstructor));
        return newMethod;
    }

    public Method createJavaMethod(java.lang.reflect.Method jdkMethod, XMIResource resource) {
        Method newMethod = JDKAdaptor.getJavaFactory().createMethod();
        newMethod.setName(JDKAdaptor.computeMethodName(jdkMethod));
        resource.setID(newMethod, JDKAdaptor.computeMethodID(jdkMethod));
        return newMethod;
    }

    public JavaJDKAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public ClassLoader getAlternateClassLoader() {
        return this.getAdapterFactory().getContextClassLoader();
    }

    public static Class getPrimitiveType(String type) {
        Class<Object> c = null;
        if (type.equals(Byte.TYPE.getName())) {
            c = Byte.TYPE;
        } else if (type.equals(Short.TYPE.getName())) {
            c = Short.TYPE;
        } else if (type.equals(Integer.TYPE.getName())) {
            c = Integer.TYPE;
        } else if (type.equals(Long.TYPE.getName())) {
            c = Long.TYPE;
        } else if (type.equals(Float.TYPE.getName())) {
            c = Float.TYPE;
        } else if (type.equals(Double.TYPE.getName())) {
            c = Double.TYPE;
        } else if (type.equals(Boolean.TYPE.getName())) {
            c = Boolean.TYPE;
        } else if (type.equals(Character.TYPE.getName())) {
            c = Character.TYPE;
        } else if (type.equals(Void.TYPE.getName())) {
            c = Void.TYPE;
        }
        return c;
    }

    public static String getSimpleName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return name;
        }
        return name.substring(lastDot + 1);
    }

    public Class getType(JavaHelpers modelClass) {
        Class<Object> result = null;
        if (modelClass.isArray()) {
            ArrayType arrayType = (ArrayType)modelClass;
            Class componentClass = this.getType(arrayType.getFinalComponentType());
            result = Array.newInstance(componentClass, new int[arrayType.getArrayDimensions()]).getClass();
        } else {
            result = modelClass.isPrimitive() ? this.getType(modelClass.getQualifiedName()) : this.getType(((JavaClass)modelClass).getQualifiedNameForReflection());
        }
        return result;
    }

    public Class getType(String qualifiedName) {
        Class primType = JDKAdaptor.getPrimitiveType(qualifiedName);
        if (primType == null) {
            ClassLoader alternateClassLoader = this.getAlternateClassLoader();
            if (alternateClassLoader != null) {
                try {
                    return alternateClassLoader.loadClass(qualifiedName);
                }
                catch (ClassNotFoundException cnf2) {
                    try {
                        return Class.forName(qualifiedName, false, alternateClassLoader);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                try {
                    return contextClassLoader.loadClass(qualifiedName);
                }
                catch (ClassNotFoundException cnf2) {
                    try {
                        return Class.forName(qualifiedName, false, contextClassLoader);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            }
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader != null) {
                try {
                    return systemClassLoader.loadClass(qualifiedName);
                }
                catch (ClassNotFoundException cnf2) {
                    try {
                        return Class.forName(qualifiedName, false, systemClassLoader);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            }
            try {
                return Class.forName(qualifiedName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return primType;
    }

    static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                int i = 0;
                while (i < dimensions) {
                    sb.append("[]");
                    ++i;
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static Class primitiveForName(String type) {
        Class<Object> c = null;
        if (type.equals(Byte.TYPE.getName())) {
            c = Byte.TYPE;
        } else if (type.equals(Short.TYPE.getName())) {
            c = Short.TYPE;
        } else if (type.equals(Integer.TYPE.getName())) {
            c = Integer.TYPE;
        } else if (type.equals(Long.TYPE.getName())) {
            c = Long.TYPE;
        } else if (type.equals(Float.TYPE.getName())) {
            c = Float.TYPE;
        } else if (type.equals(Double.TYPE.getName())) {
            c = Double.TYPE;
        } else if (type.equals(Boolean.TYPE.getName())) {
            c = Boolean.TYPE;
        } else if (type.equals(Character.TYPE.getName())) {
            c = Character.TYPE;
        } else if (type.equals(Void.TYPE.getName())) {
            c = Void.TYPE;
        }
        return c;
    }

    public void setAdapterFactory(JavaJDKAdapterFactory newAdapterFactory) {
        this.adapterFactory = newAdapterFactory;
    }
}

