/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ModelDebugger {
    public boolean debug = false;
    public boolean debugEventFlow = false;
    public boolean debugEventValue = false;
    public boolean debugEventsToFile = false;
    public boolean debugPerfUtil = false;
    public boolean debugUseOptimizedScanner = false;
    public boolean debugCustomMaps = false;
    public boolean debugUseVirtualImpl = false;
    public boolean debugUseCBEtoMemoryOutputter = true;
    public int debugUseCBEtoCSVOutputter = 1;
    public boolean debugLoadCSVFiles = true;
    public boolean debugDeleteCSVFiles = true;
    public boolean useSerializedByteCodeCache = true;
    protected String plugin_name;
    protected String value;
    public static ModelDebugger INSTANCE = new ModelDebugger("org.eclipse.tptp.platform.models");
    protected Map binaryLogs = new HashMap();
    static /* synthetic */ Class class$0;

    public ModelDebugger(String plugin_name) {
        this.plugin_name = plugin_name;
        this.init();
    }

    protected void init() {
        try {
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug");
            if (this.value != null) {
                this.debug = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.debug") != null) {
                this.debug = Boolean.valueOf(System.getProperty("ModelDebugger.debug"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/eventsFlow");
            if (this.value != null) {
                this.debugEventFlow = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.debugEventFlow") != null) {
                this.debugEventFlow = Boolean.valueOf(System.getProperty("ModelDebugger.debugEventFlow"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/eventsValue");
            if (this.value != null) {
                this.debugEventValue = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.debugEventValue") != null) {
                this.debugEventValue = Boolean.valueOf(System.getProperty("ModelDebugger.debugEventValue"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/eventsToFile");
            if (this.value != null) {
                this.debugEventsToFile = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.debugEventsToFile") != null) {
                this.debugEventsToFile = Boolean.valueOf(System.getProperty("ModelDebugger.debugEventsToFile"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/useOptimizedScanner");
            if (this.value != null) {
                this.debugUseOptimizedScanner = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.debugUseOptimizedScanner") != null) {
                this.debugUseOptimizedScanner = Boolean.valueOf(System.getProperty("ModelDebugger.debugUseOptimizedScanner"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/PerfUtil");
            if (this.value != null) {
                this.debugPerfUtil = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.debugPerfUtil") != null) {
                this.debugPerfUtil = Boolean.valueOf(System.getProperty("ModelDebugger.debugPerfUtil"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/customMaps");
            if (this.value != null) {
                this.debugCustomMaps = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.debugCustomMaps") != null) {
                this.debugCustomMaps = Boolean.valueOf(System.getProperty("ModelDebugger.debugCustomMaps"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/useVirtualImpl");
            if (this.value != null) {
                this.debugUseVirtualImpl = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.debugUseVirtualImpl") != null) {
                this.debugUseVirtualImpl = Boolean.valueOf(System.getProperty("ModelDebugger.debugUseVirtualImpl"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/useCBEtoMemoryOutputter");
            if (this.value != null) {
                this.debugUseCBEtoMemoryOutputter = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.debugUseCBEtoMemoryOutputter") != null) {
                this.debugUseCBEtoMemoryOutputter = Boolean.valueOf(System.getProperty("ModelDebugger.debugUseCBEtoMemoryOutputter"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/useCBEtoCSVOutputter");
            if (this.value != null) {
                this.debugUseCBEtoCSVOutputter = Integer.parseInt(this.value);
            } else if (System.getProperty("ModelDebugger.debugUseCBEtoCSVOutputter") != null) {
                this.debugUseCBEtoCSVOutputter = Integer.parseInt(System.getProperty("ModelDebugger.debugUseCBEtoCSVOutputter"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/loadCSVFiles");
            if (this.value != null) {
                this.debugLoadCSVFiles = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.debugLoadCSVFiles") != null) {
                this.debugLoadCSVFiles = Boolean.valueOf(System.getProperty("ModelDebugger.debugLoadCSVFiles"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/debug/deleteCSVFiles");
            if (this.value != null) {
                this.debugDeleteCSVFiles = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.debugDeleteCSVFiles") != null) {
                this.debugDeleteCSVFiles = Boolean.valueOf(System.getProperty("ModelDebugger.debugDeleteCSVFiles"));
            }
            this.value = this.getPlatformDebugOption(String.valueOf(this.plugin_name) + "/useSerializedByteCodeCache");
            if (this.value != null) {
                this.useSerializedByteCodeCache = this.value.equalsIgnoreCase("true");
            } else if (System.getProperty("ModelDebugger.useSerializedByteCodeCache") != null) {
                this.useSerializedByteCodeCache = Boolean.valueOf(System.getProperty("ModelDebugger.useSerializedByteCodeCache"));
            }
        }
        catch (Throwable throwable) {}
    }

    public synchronized int writeBinaryLog(String id, byte[] buffer) {
        return this.writeBinaryLog(id, buffer, 0, buffer.length);
    }

    public synchronized int writeBinaryLog(String id, byte buffer) {
        FileOutputStream f = this.getBinaryLog(id);
        if (f != null) {
            try {
                f.write(buffer);
                f.flush();
                return 1;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public synchronized int writeBinaryLog(String id, byte[] buffer, int offset, int length) {
        FileOutputStream f;
        int real_length = Math.min(length, buffer.length - offset);
        if (real_length > 0 && (f = this.getBinaryLog(id)) != null) {
            try {
                f.write(buffer, offset, real_length);
                f.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return real_length;
    }

    public FileOutputStream getBinaryLog(String id) {
        FileOutputStream f = (FileOutputStream)this.binaryLogs.get(id);
        if (f == null) {
            try {
                f = new FileOutputStream("/" + id + "-" + new Date().getTime());
                this.binaryLogs.put(id, f);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    public static boolean isZipFile(InputStream readStream) throws IOException {
        byte[] magic = new byte[2];
        return readStream.read(magic) > 1 && magic[0] == 80 && magic[1] == 75;
    }

    public static boolean isZipFile(String fileName) throws IOException {
        FileInputStream readStream = new FileInputStream(fileName);
        boolean ret = ModelDebugger.isZipFile(readStream);
        readStream.close();
        readStream = null;
        return ret;
    }

    public String getPlatformDebugOption(String option) {
        if (option == null) {
            return null;
        }
        try {
            Class<?> platform = Class.forName("org.eclipse.core.runtime.Platform");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method getDebugOption = platform.getMethod("getDebugOption", classArray);
            String value = (String)getDebugOption.invoke(null, (Object[])new String[]{option});
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

