/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.util.EventListener;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class EventHandler
extends DefaultHandler {
    private StringBuffer anyElementXMLFragment = new StringBuffer();
    private StringBuffer charactersBuffer = new StringBuffer();
    private StringBuffer nameSpaceAttribute = null;
    private EventListener eventListener = null;
    private int column = 0;
    private int line = 0;
    private List stack = new ArrayList();
    private int anyElementNestingDepth = 0;
    private static final HashMap ELEMENT_MAP = new HashMap();
    private static final HashMap FEATURE_MAP = new HashMap();
    private static final String SITUATION_TYPE_CLASS = EventPackage.eINSTANCE.getSituationType().getName();
    private static final String COMMON_BASE_EVENT_CLASS = EventPackage.eINSTANCE.getCommonBaseEvent().getName();
    private static final String OTHER_SITUATION_CLASS = EventPackage.eINSTANCE.getOtherSituation().getName();
    private static final String ASSOCIATION_ENGINE_CLASS = EventPackage.eINSTANCE.getAssociationEngine().getName();
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Iterator iterator = EventPackage.eINSTANCE.eContents().iterator();
        while (iterator.hasNext()) {
            EClass eClass = (EClass)iterator.next();
            ELEMENT_MAP.put(eClass.getName(), eClass);
            EList features = null;
            Object object = LOCK;
            synchronized (object) {
                features = eClass.getEAllStructuralFeatures();
            }
            int counter = 0;
            while (counter < features.size()) {
                EStructuralFeature structuralFeature = (EStructuralFeature)features.get(counter);
                if (!structuralFeature.getName().equals("any")) {
                    HashMap<String, EStructuralFeature> featureSubMap = (HashMap<String, EStructuralFeature>)FEATURE_MAP.get(eClass.getName());
                    if (featureSubMap == null) {
                        featureSubMap = new HashMap<String, EStructuralFeature>();
                        FEATURE_MAP.put(eClass.getName(), featureSubMap);
                    }
                    featureSubMap.put(structuralFeature.getName(), structuralFeature);
                }
                ++counter;
            }
        }
    }

    public void init() {
        this.reset();
        this.eventListener = null;
    }

    private void reset() {
        int stringBufferLength;
        this.column = 0;
        this.line = 0;
        this.anyElementNestingDepth = 0;
        this.nameSpaceAttribute = null;
        if (this.stack.size() > 0) {
            this.stack.clear();
        }
        if ((stringBufferLength = this.anyElementXMLFragment.length()) > 0) {
            this.anyElementXMLFragment.setLength(0);
        }
        if ((stringBufferLength = this.charactersBuffer.length()) > 0) {
            this.charactersBuffer.setLength(0);
        }
    }

    public void addEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.column = locator.getColumnNumber();
        this.line = locator.getLineNumber();
    }

    public void characters(char[] characters, int start, int length) throws SAXException {
        super.characters(characters, start, length);
        this.charactersBuffer.append(new String(characters, start, length));
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        if (!prefix.equals("xmlns") && !prefix.equals("xml")) {
            this.nameSpaceAttribute = new StringBuffer("xmlns");
            if (prefix != null && prefix.trim().length() > 0) {
                this.nameSpaceAttribute.append(':');
                this.nameSpaceAttribute.append(prefix);
            }
            this.nameSpaceAttribute.append("=\"");
            this.nameSpaceAttribute.append(uri);
            this.nameSpaceAttribute.append('\"');
        }
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        block25: {
            block27: {
                block26: {
                    super.startElement(uri, localName, qualifiedName, attributes);
                    elementName = this.getLocalElementName(localName, qualifiedName);
                    if ((elementName.equals("CommonBaseEvents") || elementName.equals("TemplateEvent")) && this.anyElementNestingDepth <= 0) break block25;
                    emfObj = null;
                    emfObjClass = null;
                    if (!this.stack.isEmpty()) break block26;
                    if (!elementName.equals(EventHandler.COMMON_BASE_EVENT_CLASS) && !elementName.equals(EventHandler.ASSOCIATION_ENGINE_CLASS)) {
                        throw new SAXException(LoggingCoreResourceBundle.getString("LOG_EVENT_SAX_PARSER_INCORRECT_XML_ELEMENT_EXC_", String.valueOf(EventHandler.COMMON_BASE_EVENT_CLASS) + " or " + EventHandler.ASSOCIATION_ENGINE_CLASS, elementName, String.valueOf(this.line), String.valueOf(this.column)));
                    }
                    emfObjClass = (EClass)EventHandler.ELEMENT_MAP.get(elementName);
                    emfObj = EventFactory.eINSTANCE.create(emfObjClass);
                    if (elementName.equals(EventHandler.COMMON_BASE_EVENT_CLASS)) {
                        emfObj.eSet(EventPackage.eINSTANCE.getCommonBaseEvent_Version(), null);
                    }
                    this.stack.add(emfObj);
                    break block27;
                }
                container = (EObject)this.stack.get(this.stack.size() - 1);
                containerName = container.eClass().getName();
                featureSubMap = (HashMap)EventHandler.FEATURE_MAP.get(containerName);
                objStructuralFeature = (EStructuralFeature)featureSubMap.get(elementName);
                if (objStructuralFeature != null && this.anyElementNestingDepth <= 0) ** GOTO lbl54
                if (containerName.equals(EventHandler.COMMON_BASE_EVENT_CLASS) || containerName.equals(EventHandler.OTHER_SITUATION_CLASS)) {
                    if (this.anyElementNestingDepth > 0 && (anyElementCharacters = this.charactersBuffer.toString()).trim().length() > 0) {
                        this.anyElementXMLFragment.append(XmlUtility.normalize(anyElementCharacters));
                    }
                    ++this.anyElementNestingDepth;
                    this.anyElementXMLFragment.append('<');
                    this.anyElementXMLFragment.append(this.getQualifiedElementName(uri, localName, qualifiedName));
                    if (this.nameSpaceAttribute != null) {
                        this.anyElementXMLFragment.append(' ');
                        this.anyElementXMLFragment.append(this.nameSpaceAttribute.toString());
                    }
                    counter = 0;
                    while (counter < attributes.getLength()) {
                        this.anyElementXMLFragment.append(' ');
                        this.anyElementXMLFragment.append(this.getQualifiedElementName(attributes.getURI(counter), attributes.getLocalName(counter), attributes.getQName(counter)));
                        this.anyElementXMLFragment.append("=\"");
                        this.anyElementXMLFragment.append(XmlUtility.normalize(attributes.getValue(counter)));
                        this.anyElementXMLFragment.append("\"");
                        ++counter;
                    }
                    this.anyElementXMLFragment.append('>');
                } else {
                    throw new SAXException(LoggingCoreResourceBundle.getString("LOG_EVENT_SAX_PARSER_UNEXPECTED_XML_ELEMENT_EXC_", elementName, String.valueOf(this.line), String.valueOf(this.column)));
lbl54:
                    // 1 sources

                    className = objStructuralFeature.getEType().getName();
                    if (className.equals(EventHandler.SITUATION_TYPE_CLASS) && ((className = ((Situation)container).getCategoryName()) == null || className.trim().length() == 0)) {
                        throw new SAXException(LoggingCoreResourceBundle.getString("LOG_EVENT_SAX_PARSER_INVALID_XML_ATTRIBUTE_EXC_", "categoryName", "<empty>", "0", "0"));
                    }
                    if (className.equals("EString")) {
                        if (objStructuralFeature.isMany()) {
                            this.stack.add((List)container.eGet(objStructuralFeature));
                        } else {
                            this.stack.add(objStructuralFeature);
                        }
                    } else {
                        emfObjClass = (EClass)EventHandler.ELEMENT_MAP.get(className);
                        emfObj = EventFactory.eINSTANCE.create(emfObjClass);
                        if (objStructuralFeature.isMany()) {
                            ((List)container.eGet(objStructuralFeature)).add(emfObj);
                        } else {
                            container.eSet(objStructuralFeature, emfObj);
                        }
                        this.stack.add(emfObj);
                    }
                }
            }
            if (emfObj != null && emfObjClass != null) {
                featureSubMap = (HashMap)EventHandler.FEATURE_MAP.get(emfObjClass.getName());
                feature = null;
                attributeTypeName = null;
                counter = 0;
                while (counter < attributes.getLength()) {
                    feature = (EAttribute)featureSubMap.get(this.getLocalElementName(attributes.getLocalName(counter), attributes.getQName(counter)));
                    if (feature != null) {
                        attributeTypeName = feature.getEAttributeType().getName();
                        if (attributeTypeName.equals("ELong")) {
                            try {
                                emfObj.eSet(feature, Long.valueOf(attributes.getValue(counter)));
                            }
                            catch (NumberFormatException n) {
                                if (attributes.getValue(counter).trim().length() <= 0) ** GOTO lbl99
                                throw new SAXException(LoggingCoreResourceBundle.getString("LOG_EVENT_SAX_PARSER_INVALID_XML_ATTRIBUTE_EXC_", this.getQualifiedElementName(attributes.getURI(counter), attributes.getLocalName(counter), attributes.getQName(counter)), attributes.getValue(counter), String.valueOf(this.line), String.valueOf(this.column)));
                            }
                        } else if (attributeTypeName.equals("EShort")) {
                            try {
                                emfObj.eSet(feature, Short.valueOf(attributes.getValue(counter)));
                            }
                            catch (NumberFormatException n) {
                                if (attributes.getValue(counter).trim().length() <= 0) ** GOTO lbl99
                                throw new SAXException(LoggingCoreResourceBundle.getString("LOG_EVENT_SAX_PARSER_INVALID_XML_ATTRIBUTE_EXC_", this.getQualifiedElementName(attributes.getURI(counter), attributes.getLocalName(counter), attributes.getQName(counter)), attributes.getValue(counter), String.valueOf(this.line), String.valueOf(this.column)));
                            }
                        } else {
                            emfObj.eSet(feature, attributes.getValue(counter));
                        }
                    }
lbl99:
                    // 7 sources

                    ++counter;
                }
            }
            this.charactersBuffer.setLength(0);
            this.nameSpaceAttribute = null;
        }
    }

    public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        super.endElement(uri, localName, qualifiedName);
        String elementName = this.getLocalElementName(localName, qualifiedName);
        if (!elementName.equals("CommonBaseEvents") && !elementName.equals("TemplateEvent") || this.anyElementNestingDepth > 0) {
            if (this.stack.isEmpty()) {
                throw new SAXException(LoggingCoreResourceBundle.getString("LOG_EVENT_SAX_PARSER_UNEXPECTED_XML_ELEMENT_EXC_", elementName, String.valueOf(this.line), String.valueOf(this.column)));
            }
            if (this.anyElementNestingDepth > 0) {
                String anyElementCharacters = this.charactersBuffer.toString();
                if (anyElementCharacters.trim().length() > 0) {
                    this.anyElementXMLFragment.append(XmlUtility.normalize(anyElementCharacters));
                }
                this.anyElementXMLFragment.append("</");
                this.anyElementXMLFragment.append(this.getQualifiedElementName(uri, localName, qualifiedName));
                this.anyElementXMLFragment.append('>');
                if (--this.anyElementNestingDepth == 0) {
                    Object object = this.stack.get(this.stack.size() - 1);
                    if (object instanceof CommonBaseEvent) {
                        ((CommonBaseEvent)object).addAny(this.anyElementXMLFragment.toString());
                    } else if (object instanceof OtherSituation) {
                        OtherSituation otherSituation = (OtherSituation)object;
                        String currentAnyElement = otherSituation.getAny();
                        if (currentAnyElement != null && currentAnyElement.trim().length() > 0) {
                            otherSituation.setAny(currentAnyElement.concat(this.anyElementXMLFragment.toString()));
                        } else {
                            otherSituation.setAny(this.anyElementXMLFragment.toString());
                        }
                    }
                    this.anyElementXMLFragment.setLength(0);
                }
            } else {
                Object object = this.stack.remove(this.stack.size() - 1);
                if (object instanceof CommonBaseEvent) {
                    String anyElementCharacters = this.charactersBuffer.toString();
                    if (anyElementCharacters.trim().length() > 0) {
                        ((CommonBaseEvent)object).addAny(anyElementCharacters.trim());
                    }
                    if (this.eventListener != null) {
                        this.eventListener.processCommonBaseEvent((CommonBaseEvent)object);
                    }
                    this.reset();
                } else if (object instanceof OtherSituation) {
                    String anyElementCharacters = this.charactersBuffer.toString();
                    if (anyElementCharacters.trim().length() > 0) {
                        OtherSituation otherSituation = (OtherSituation)object;
                        String currentAnyElement = otherSituation.getAny();
                        if (currentAnyElement != null && currentAnyElement.trim().length() > 0) {
                            otherSituation.setAny(currentAnyElement.concat(anyElementCharacters));
                        } else {
                            otherSituation.setAny(anyElementCharacters.trim());
                        }
                    }
                } else if (elementName.equals(ASSOCIATION_ENGINE_CLASS) && object instanceof AssociationEngine) {
                    if (this.eventListener != null) {
                        this.eventListener.processAssociationEngine((AssociationEngine)object);
                    }
                    this.reset();
                } else if (this.stack.size() > 1) {
                    if (object instanceof List) {
                        ((List)object).add(this.charactersBuffer.toString());
                    }
                    if (object instanceof EStructuralFeature) {
                        ((EObject)this.stack.get(this.stack.size() - 1)).eSet((EStructuralFeature)object, this.charactersBuffer.toString());
                    }
                }
            }
            this.charactersBuffer.setLength(0);
        }
    }

    public void warning(SAXParseException saxParseException) throws SAXException {
        throw saxParseException;
    }

    public void error(SAXParseException saxParseException) throws SAXException {
        throw saxParseException;
    }

    public void fatalError(SAXParseException saxParseException) throws SAXException {
        throw saxParseException;
    }

    private String getLocalElementName(String localName, String qualifiedName) {
        if (localName == null || localName.trim().length() == 0) {
            if (qualifiedName != null) {
                int lastColonIndex = qualifiedName.lastIndexOf(58);
                if (lastColonIndex != -1) {
                    return qualifiedName.substring(lastColonIndex + 1).trim();
                }
                return qualifiedName.trim();
            }
            return "";
        }
        return localName.trim();
    }

    private String getQualifiedElementName(String uri, String localName, String qualifiedName) {
        if (qualifiedName == null || qualifiedName.trim().length() == 0) {
            if (localName != null) {
                if (uri != null && uri.trim().length() > 0) {
                    return uri.concat(":").concat(localName);
                }
                return localName.trim();
            }
            return "";
        }
        return qualifiedName.trim();
    }
}

