/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.remote;

import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public class QueueManager {
    private String[] _queue;
    private int _queueSize;
    private int _lastMessageIndex = -1;
    private boolean _rolledOver = false;

    public QueueManager() {
        this(100);
    }

    public QueueManager(int queueSize) {
        this._queueSize = queueSize;
    }

    public synchronized void flushCurrentQueue(RemoteComponentSkeleton aAgent) {
        if (this._queue == null) {
            return;
        }
        try {
            int i;
            if (this._rolledOver) {
                i = this._lastMessageIndex + 1;
                while (i < this._queue.length) {
                    if (this._queue[i] != null) {
                        aAgent.logMessageUTF8(this._queue[i]);
                    }
                    this._queue[i] = null;
                    ++i;
                }
            }
            i = 0;
            while (i <= this._lastMessageIndex) {
                aAgent.logMessageUTF8(this._queue[i]);
                this._queue[i] = null;
                ++i;
            }
            this._rolledOver = false;
            this._lastMessageIndex = -1;
        }
        catch (Exception exception) {}
    }

    public synchronized void insertInQueue(String logRecord) {
        if (this._queue == null) {
            this._queue = new String[this._queueSize];
        }
        this._queue[++this._lastMessageIndex] = logRecord;
        if (this._lastMessageIndex == this._queue.length - 1) {
            this._lastMessageIndex = -1;
            this._rolledOver = true;
        }
    }

    public boolean isFlushNeeded() {
        return this._lastMessageIndex != -1 || this._rolledOver;
    }
}

