/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import junit.framework.Assert;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannelFactory;
import org.eclipse.hyades.internal.execution.core.file.socket.SocketChannelFactory;
import org.eclipse.hyades.internal.execution.local.control.ConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;

public class SecureConnectionImpl
extends ConnectionImpl
implements ISocketChannelFactory {
    public void connect(Node node, int port) throws IOException, LoginFailedException, SecureConnectionRequiredException, UntrustedAgentControllerException {
        this._port = port;
        int offset = 0;
        InetAddress[] addrs = node.getAllInetAddresses();
        int protocolOffset = 0;
        String[] sslProtocols = node.getSecurityParameters().getEnabledProtocols();
        if (sslProtocols == null) {
            sslProtocols = new String[]{"SSL"};
        }
        do {
            try {
                SSLContext sslContext = SSLContext.getInstance(sslProtocols[protocolOffset]);
                sslContext.init(node.getSecurityParameters().getKeystoreManager().getKeyManagers(), node.getSecurityParameters().getKeystoreManager().getTrustManagers(), null);
                if (sslContext == null) {
                    this._socket = SSLSocketFactory.getDefault().createSocket(addrs[offset], port);
                    ((SSLSocket)this._socket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        public void handshakeCompleted(HandshakeCompletedEvent e) {
                        }
                    });
                    ((SSLSocket)this._socket).startHandshake();
                } else {
                    this._socket = sslContext.getSocketFactory().createSocket(addrs[offset], port);
                    ((SSLSocket)this._socket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        public void handshakeCompleted(HandshakeCompletedEvent e) {
                        }
                    });
                }
                String[] cyphers = node.getSecurityParameters().getEnabledCipherSuites();
                if (cyphers != null) {
                    ((SSLSocket)this._socket).setEnabledCipherSuites(node.getSecurityParameters().getEnabledCipherSuites());
                } else {
                    ((SSLSocket)this._socket).setEnabledCipherSuites(((SSLSocket)this._socket).getSupportedCipherSuites());
                }
                ((SSLSocket)this._socket).setUseClientMode(true);
                SSLSession session = ((SSLSocket)this._socket).getSession();
                if (session == null) {
                    throw new UntrustedAgentControllerException();
                }
                if (session.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
                    throw new UntrustedAgentControllerException();
                }
                break;
            }
            catch (ConnectException e) {
                if (++offset == addrs.length) {
                    throw e;
                }
                protocolOffset = 0;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (++protocolOffset != sslProtocols.length) continue;
                throw new ConnectException("Could not get an SSLContext. All protocol specifications were tried");
            }
            catch (KeyManagementException keyManagementException) {}
        } while (offset < addrs.length);
        this._node = node;
        this.init();
    }

    private ISocketChannel create() throws IOException {
        Assert.assertNotNull((Object)this._socket);
        return this.create(this._socket);
    }

    public ISocketChannel create(InetSocketAddress address) throws IOException {
        Assert.assertNotNull((Object)address);
        Assert.assertNotNull((Object)this._node);
        SecureConnectionImpl connection = new SecureConnectionImpl(){

            public void init() {
                try {
                    this._socket.setSoTimeout(60000);
                    this._socket.setTcpNoDelay(true);
                    this._socket.setReuseAddress(true);
                }
                catch (SocketException socketException) {}
            }
        };
        try {
            connection.connect(this._node, address.getPort());
            return super.create();
        }
        catch (SecureConnectionRequiredException secureConnectionRequiredException) {
        }
        catch (UntrustedAgentControllerException untrustedAgentControllerException) {
        }
        catch (IOException iOException) {
        }
        catch (LoginFailedException loginFailedException) {}
        return null;
    }

    public ISocketChannel create(Socket socket) throws IOException {
        return SocketChannelFactory.getInstance().create(socket);
    }

    public ISocketChannel create(SocketChannel realChannel) {
        return SocketChannelFactory.getInstance().create(realChannel);
    }

    public ISocketChannel create(InetSocketAddress address, int timeout) throws IOException {
        return null;
    }
}

