/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Hashtable;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeImpl;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.User;

public class NodeFactory {
    private static String _hostname = "localhost";
    private static Hashtable _servers = new Hashtable();

    public static Node createNode(String hostname) throws UnknownHostException {
        try {
            return NodeFactory.createNode(hostname, null);
        }
        catch (DuplicateUserException duplicateUserException) {
            return NodeFactory.containsNode(hostname, null);
        }
    }

    public static Node createNode(String hostname, Principal principal) throws UnknownHostException, DuplicateUserException {
        Node result = NodeFactory.containsNode(hostname, principal);
        if (result == null) {
            InetAddress addr = InetAddress.getByName(hostname);
            return NodeFactory.addNode(hostname, addr, principal);
        }
        throw new DuplicateUserException();
    }

    public static Node createNode(InetAddress address) throws UnknownHostException {
        return NodeFactory.createNode(address, null);
    }

    public static Node createNode(InetAddress address, Principal principal) throws UnknownHostException {
        String hostname = address.getHostName();
        Node result = NodeFactory.containsNode(hostname, principal);
        if (result == null) {
            result = NodeFactory.addNode(hostname, address, principal);
        }
        return result;
    }

    public static Node getLocalHost() throws UnknownHostException {
        return NodeFactory.getLocalHost(null);
    }

    public static Node getLocalHost(Principal principal) throws UnknownHostException {
        Node localNode = (Node)_servers.get(_hostname);
        if (localNode == null) {
            throw new UnknownHostException();
        }
        return localNode;
    }

    public static void addNode(Node node) {
        String nodeName = node.getName();
        if (!_servers.containsKey(nodeName)) {
            _servers.put(nodeName, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node addNode(String name, InetAddress addr, Principal principal) {
        if (name.equals("localhost")) {
            try {
                name = InetAddress.getLocalHost().getHostName();
                InetAddress[] addrs = InetAddress.getAllByName(name);
                addr = addrs[0];
            }
            catch (UnknownHostException unknownHostException) {}
        }
        Hashtable hashtable = _servers;
        synchronized (hashtable) {
            if (_servers.containsKey(name)) {
                Node existingNode = (Node)_servers.get(name);
                if (principal instanceof User) {
                    existingNode.setUser((User)principal);
                } else if (principal instanceof Application) {
                    existingNode.setApplication((Application)principal);
                }
                return existingNode;
            }
            NodeImpl newNode = new NodeImpl(name, addr);
            if (principal instanceof User) {
                newNode.setUser((User)principal);
            } else if (principal instanceof Application) {
                newNode.setApplication((Application)principal);
            }
            NodeFactory.addNode(newNode);
            return newNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node containsNode(String name, Principal principal) {
        Node node = null;
        Hashtable hashtable = _servers;
        synchronized (hashtable) {
            if (name.equals("localhost")) {
                try {
                    name = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {}
            }
            if (_servers.containsKey(name)) {
                node = (Node)_servers.get(name);
                if (principal != null) {
                    if (principal instanceof User && node.getUser() != null) {
                        if (!principal.getName().equals(node.getUser().getName())) {
                            node = null;
                        }
                    } else if (principal instanceof Application && node.getApplication() != null && !principal.getName().equals(node.getApplication().getName())) {
                        node = null;
                    }
                }
            }
        }
        return node;
    }

    public static Node getNode(InetAddress addr) {
        return NodeFactory.getNode(addr, null);
    }

    public static Node getNode(InetAddress addr, Principal principal) {
        return NodeFactory.containsNode(addr.getHostName(), principal);
    }

    public static Node getNode(String name, Principal principal) throws UnknownHostException {
        return NodeFactory.getNode(InetAddress.getByName(name), principal);
    }
}

