/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.ServerSecurityInfoCommand;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.ContextMapper;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.security.AuthenticationListener;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;

public class ConnectionImpl
implements Connection {
    protected Socket _socket;
    protected Node _node;
    protected int _port;
    private static long _context = 1L;
    private ContextMapper _contextMapper = null;
    private CommandHandler _cmdHandler = null;
    private boolean _isComplete = false;
    private final Vector _listeners = new Vector();
    private final Object _connectionLock = new Object();
    private static final Object contextLock = new Object();
    private boolean _isInitialized = false;
    private SecureConnectionRequiredException _connectionException = null;
    private int _connectionTimeout = 10000;

    public void connect(Node node, int port) throws IOException, LoginFailedException, SecureConnectionRequiredException, UntrustedAgentControllerException {
        this._port = port;
        int offset = 0;
        InetAddress[] addrs = node.getAllInetAddresses();
        while (true) {
            try {
                this._socket = new Socket(addrs[offset], port);
            }
            catch (IOException e) {
                if (++offset != addrs.length) continue;
                throw e;
                if (offset < addrs.length) continue;
            }
            break;
        }
        this._node = node;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws IOException, SecureConnectionRequiredException {
        try {
            this._socket.setSoTimeout(1000);
            this._socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {}
        this._connectionException = null;
        this._contextMapper = new ContextMapper();
        this._cmdHandler = new CommandHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void incommingCommand(Node node, CommandElement command) {
                long contextId = command.getContext();
                switch ((int)command.getTag()) {
                    case 4: {
                        ConnectionImpl.this._connectionException = new SecureConnectionRequiredException((ServerSecurityInfoCommand)command);
                        Object object = ConnectionImpl.this._connectionLock;
                        synchronized (object) {
                            ConnectionImpl.this._connectionLock.notifyAll();
                        }
                        ConnectionImpl.this.disconnect();
                        break;
                    }
                    default: {
                        Object object = ConnectionImpl.this._connectionLock;
                        synchronized (object) {
                            ConnectionImpl.this._connectionLock.notifyAll();
                        }
                        CommandHandler ch = ConnectionImpl.this._contextMapper.getHandler(contextId);
                        if (ch != null) {
                            ch.incommingCommand(ConnectionImpl.this._node, command);
                            break;
                        }
                        ConnectionImpl.this._node.incommingCommand(ConnectionImpl.this._node, command);
                    }
                }
            }
        };
        SocketReaderThread reader = new SocketReaderThread();
        if (this._node.getUser() == null) {
            reader.setName(String.valueOf(this._node.getName()) + "_connection");
        } else {
            reader.setName(String.valueOf(this._node.getName()) + "_" + this._node.getUser().getName() + "_connection");
        }
        reader.setDaemon(true);
        reader.start();
        this._isInitialized = true;
        Object object = this._connectionLock;
        synchronized (object) {
            try {
                this._connectionLock.wait(this._connectionTimeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this._connectionException != null) {
                throw this._connectionException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(ControlMessage msg, CommandHandler handler) throws IOException {
        int count = msg.getSize();
        byte[] buffer = new byte[count];
        int commandCount = msg.getCommandCount();
        Object object = contextLock;
        synchronized (object) {
            int i = 0;
            while (i < commandCount) {
                msg.getCommand(i).setContext(_context++);
                ++i;
            }
        }
        int i = 0;
        while (i < commandCount) {
            this._contextMapper.addContext(msg.getCommand(i).getContext(), handler);
            ++i;
        }
        msg.writeToBuffer(buffer, 0);
        OutputStream stream = this._socket.getOutputStream();
        stream.write(buffer);
        stream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this._connectionLock;
        synchronized (object) {
            if (!this._isComplete) {
                this._isComplete = true;
                this._connectionLock.notifyAll();
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {}
                Vector vector = this._listeners;
                synchronized (vector) {
                    Enumeration e = this._listeners.elements();
                    while (e.hasMoreElements()) {
                        ConnectionListener listener = (ConnectionListener)e.nextElement();
                        listener.connectionClosed(this);
                    }
                }
            }
        }
    }

    public Node getNode() {
        return this._node;
    }

    public boolean isActive() {
        if (this._isInitialized) {
            return !this._isComplete;
        }
        return false;
    }

    public int getPort() {
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(ConnectionListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (this._listeners.contains(listener)) {
                this._listeners.remove(listener);
            }
        }
    }

    public void addAuthenticationListener(AuthenticationListener listener) {
    }

    public void removeAuthenticationListener(AuthenticationListener listener) {
    }

    protected int processControlMessage(byte[] buffer, int offset, int length) {
        if (this._cmdHandler != null) {
            ControlMessage msg = new ControlMessage();
            int current = -1;
            try {
                current = msg.readFromBuffer(buffer, offset, length);
                if (current > offset + length) {
                    return -1;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            catch (Exception exception) {
                return -1;
            }
            if ((long)current == msg.getLength() + (long)offset) {
                int count = msg.getCommandCount();
                int i = 0;
                while (i < count) {
                    this._cmdHandler.incommingCommand(this._node, msg.getCommand(i));
                    ++i;
                }
            }
            return current;
        }
        return -1;
    }

    static /* synthetic */ boolean access$0(ConnectionImpl connectionImpl) {
        return connectionImpl._isComplete;
    }

    static /* synthetic */ boolean access$1(ConnectionImpl connectionImpl) {
        return connectionImpl._isInitialized;
    }

    class SocketReaderThread
    extends Thread
    implements Constants {
        SocketReaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            buffer = new byte[8096];
            masterOffset = 0;
            msgOffset = 0;
            timeoutCount = 0;
            while (!ConnectionImpl.access$0(ConnectionImpl.this)) {
                incompleteMsg = false;
                try {
                    inStream = ConnectionImpl.this._socket.getInputStream();
                    len = buffer.length - masterOffset;
                    bytesRead = len == 0 ? 0 : inStream.read(buffer, masterOffset, len);
                    if (bytesRead == -1) break;
                    incommingMessage = new Message();
                    while (msgOffset < bytesRead + masterOffset) {
                        block21: {
                            newOffset = 0;
                            try {
                                newOffset = incommingMessage.readFromBuffer(buffer, msgOffset);
                                if (newOffset >= masterOffset + bytesRead) {
                                    if (msgOffset > 0) {
                                        masterOffset = masterOffset + bytesRead - msgOffset;
                                        i = 0;
                                        while (i < masterOffset) {
                                            buffer[i] = buffer[msgOffset + i];
                                            ++i;
                                        }
                                        msgOffset = 0;
                                    }
                                    incompleteMsg = true;
                                    break;
                                }
                            }
                            catch (IndexOutOfBoundsException v0) {
                                if (msgOffset <= 0) break block21;
                                masterOffset = masterOffset + bytesRead - msgOffset;
                                i = 0;
                                ** while (i < masterOffset)
                            }
lbl-1000:
                            // 1 sources

                            {
                                buffer[i] = buffer[msgOffset + i];
                                ++i;
                                continue;
                            }
lbl37:
                            // 1 sources

                            msgOffset = 0;
                        }
                        incompleteMsg = true;
                        break;
                        catch (Exception e) {
                            System.out.println(e.toString());
                            break;
                        }
                        if (incommingMessage.getType() == 0L) continue;
                        newOffset = ConnectionImpl.this.processControlMessage(buffer, msgOffset, bytesRead + masterOffset - msgOffset);
                        if (newOffset == -1) {
                            incompleteMsg = true;
                            if (msgOffset > 0) {
                                masterOffset = masterOffset + bytesRead - msgOffset;
                                i = 0;
                                while (i < masterOffset) {
                                    buffer[i] = buffer[msgOffset + i];
                                    ++i;
                                }
                                msgOffset = 0;
                                break;
                            }
                            if (bytesRead == 0 && masterOffset == buffer.length) {
                                tmpbuffer = new byte[buffer.length * 2];
                                System.arraycopy(buffer, 0, tmpbuffer, 0, buffer.length);
                                buffer = tmpbuffer;
                            }
                            masterOffset += bytesRead;
                            break;
                        }
                        msgOffset = newOffset;
                    }
                    if (incompleteMsg) continue;
                    masterOffset = 0;
                    msgOffset = 0;
                }
                catch (InterruptedIOException v1) {
                    if (timeoutCount > 6 && !ConnectionImpl.access$1(ConnectionImpl.this)) {
                        var6_6 = ConnectionImpl.access$2(ConnectionImpl.this);
                        synchronized (var6_6) {
                            ConnectionImpl.access$2(ConnectionImpl.this).notifyAll();
                        }
                    }
                    ++timeoutCount;
                }
                catch (SocketException v3) {
                    break;
                }
                catch (IOException v4) {
                    break;
                }
            }
            ConnectionImpl.this.disconnect();
        }
    }
}

