/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.net.InetAddress;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.SimpleAgentInfoCommand;

public class StartMonitoringRemoteAgentCommand
extends SimpleAgentInfoCommand {
    protected long _port = 0L;
    protected long _ip = 0L;

    public StartMonitoringRemoteAgentCommand() {
        this._tag = 22L;
    }

    public long getIP() {
        return this._ip;
    }

    public long getPort() {
        return this._port;
    }

    public int getSize() {
        return super.getSize() + 8;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = super.readFromBuffer(buffer, offset);
        this._ip = Message.readRALongFromBuffer(buffer, current);
        this._port = Message.readRALongFromBuffer(buffer, current += 4);
        return current += 4;
    }

    public void setInetAddress(InetAddress param) {
        byte[] addr_bytes = param.getAddress();
        this._ip = 0L;
        this._ip += (long)(addr_bytes[3] << 24 & 0xFF000000);
        this._ip += (long)(addr_bytes[2] << 16 & 0xFF0000);
        this._ip += (long)(addr_bytes[1] << 8 & 0xFF00);
        this._ip += (long)(addr_bytes[0] & 0xFF);
    }

    public void setPort(short port) {
        this._port = port;
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = super.writeToBuffer(buffer, offset);
        current = Message.writeRALongToBuffer(buffer, current, this._ip);
        current = Message.writeRALongToBuffer(buffer, current, this._port);
        return current;
    }
}

