/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.net.InetAddress;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;

public class MultiplexedDataServer
implements AgentListener,
Constants {
    private Agent _agent;
    private DataProcessor _processor;
    private long magicNumber = -17973026L;
    private long terminationCode = -559038242L;
    private InetAddress inetaddr = null;
    public static final byte BINARY_DATA = 0;
    public static final byte UTF8_STRING_DATA = 1;
    public static final byte UNICODE_STRING_DATA = 2;

    public void startServer(DataProcessor processor) throws Exception {
        this._processor = processor;
    }

    public boolean isProcessing() {
        return true;
    }

    public void stopServer() {
    }

    public void resumeServer() {
    }

    public void resumeServer(DataProcessor processor) {
    }

    public void shutdownServer() {
        this._processor = null;
    }

    public void incommingData(byte[] b, InetAddress peer) {
        this._processor.incommingData(b, b.length, peer);
    }

    public void incommingData(char[] c, InetAddress peer) {
        this._processor.incommingData(c, c.length, peer);
    }

    public void agentActive(Agent agent) {
        try {
            this.inetaddr = agent.getProcess().getNode().getInetAddress();
        }
        catch (InactiveProcessException inactiveProcessException) {}
    }

    public void agentInactive(Agent agent) {
        this._agent = agent;
    }

    public void error(Agent agent, String errorId, String errorMessage) {
    }

    public void handleCommand(Agent agent, CommandElement command) {
        switch ((int)command.getTag()) {
            case 29: {
                BinaryCustomCommand binaryCustomCommand = (BinaryCustomCommand)command;
                byte[] binaryData = binaryCustomCommand.getDataBinary();
                int binaryDataLength = binaryData.length;
                if (binaryDataLength < 4) break;
                long code = Message.readRALongFromBuffer(binaryData, 0);
                if (code == this.magicNumber) {
                    byte[] b = new byte[binaryDataLength - 4];
                    System.arraycopy(binaryData, 4, b, 0, binaryDataLength - 4);
                    this.processData(b, this.inetaddr);
                    break;
                }
                if (code != this.terminationCode) break;
                if (this._processor instanceof DataServerListener) {
                    ((DataServerListener)this._processor).dataServerExited();
                }
                if (this._agent == null || this._agent.getProcess() == null || !(this._agent.getProcess() instanceof ProcessImpl)) break;
                ((ProcessImpl)this._agent.getProcess()).removeAgent(this._agent);
            }
        }
    }

    private void processData(byte[] data, InetAddress addr) {
        if (data.length > 10) {
            if (this.isValidHeader(data)) {
                int length = (int)this.getMessageLength(data);
                byte type = this.getMessageType(data);
                if (length + 10 <= data.length) {
                    if (type == 0 || type == 1) {
                        byte[] forwardBuffer = new byte[length];
                        System.arraycopy(data, 10, forwardBuffer, 0, length);
                        this._processor.incommingData(forwardBuffer, length, addr);
                    } else if (type == 2) {
                        int strlen = length / 2;
                        char[] forwardBuffer = new char[strlen];
                        int i = 0;
                        while (i < strlen) {
                            forwardBuffer[i] = (char)((char)data[10 + 2 * i] | (char)(data[10 + 2 * i + 1] << 8));
                            ++i;
                        }
                        this._processor.incommingData(forwardBuffer, strlen, addr);
                    } else {
                        System.err.println("ERROR: Corrupted data in multiplexed data");
                    }
                } else {
                    System.err.println("ERROR: multiplexed message does not have enough bytes as specified in the message length attribute");
                }
            } else {
                System.err.println("ERROR: multiplexed message does not have a valid header");
            }
        } else {
            System.err.println("ERROR: multiplexed message does not have enough header bytes");
        }
    }

    private long getMessageLength(byte[] b) {
        return Message.readRALongFromBuffer(b, 5);
    }

    private byte getMessageType(byte[] b) {
        return b[9];
    }

    private boolean isValidHeader(byte[] b) {
        boolean valid = false;
        if (b[0] == -126 && b[1] == 101 && b[2] == 103 && b[3] == -128) {
            valid = true;
        }
        return valid;
    }
}

