/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import org.eclipse.hyades.internal.execution.local.common.ActiveAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentActiveCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentAttachedCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentConfigurationCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentDetachedCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentInactiveCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentQueryStateCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentRequestMonitorCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentRequestMonitorPortCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentScopingInformationCommand;
import org.eclipse.hyades.internal.execution.local.common.AttachToAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.AuthenticateCommand;
import org.eclipse.hyades.internal.execution.local.common.AuthenticationFailedCommand;
import org.eclipse.hyades.internal.execution.local.common.AuthenticationSuccessfulCommand;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.DetachFromAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.ErrorCommand;
import org.eclipse.hyades.internal.execution.local.common.GetPropertyListCommand;
import org.eclipse.hyades.internal.execution.local.common.KillProcessCommand;
import org.eclipse.hyades.internal.execution.local.common.LaunchProcessCommand;
import org.eclipse.hyades.internal.execution.local.common.ManageFileCommand;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.MonitorPeerRequestCommand;
import org.eclipse.hyades.internal.execution.local.common.MonitorPeerRequestPortCommand;
import org.eclipse.hyades.internal.execution.local.common.PeerUnreachableCommand;
import org.eclipse.hyades.internal.execution.local.common.ProcessExitedCommand;
import org.eclipse.hyades.internal.execution.local.common.ProcessLaunchedCommand;
import org.eclipse.hyades.internal.execution.local.common.PropertyListCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.QueryProcessListCommand;
import org.eclipse.hyades.internal.execution.local.common.RAString;
import org.eclipse.hyades.internal.execution.local.common.RegisterAgentInterestCommand;
import org.eclipse.hyades.internal.execution.local.common.RegisteredProcessListCommand;
import org.eclipse.hyades.internal.execution.local.common.ResourceLocation;
import org.eclipse.hyades.internal.execution.local.common.ServerSecurityInfoCommand;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.common.StartMonitoringLocalAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.StartMonitoringRemoteAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.StopMonitorCommand;

public class ControlMessage
extends Message {
    CommandElement[] _entries = null;
    long _length;
    protected RAString _key = new RAString("");

    public ControlMessage() {
        this._type = 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendCommand(CommandElement command) {
        if (this._entries == null) {
            this._entries = new CommandElement[1];
            this._entries[0] = command;
            return;
        }
        CommandElement[] commandElementArray = this._entries;
        synchronized (this._entries) {
            CommandElement[] _oldElements = this._entries;
            this._entries = new CommandElement[_oldElements.length + 1];
            int i = 0;
            while (i < _oldElements.length) {
                this._entries[i] = _oldElements[i];
                ++i;
            }
            this._entries[_oldElements.length] = command;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public CommandElement getCommand(int offset) {
        return this._entries[offset];
    }

    public int getCommandCount() {
        return this._entries.length;
    }

    public RAString getKey() {
        return this._key;
    }

    public long getLength() {
        return this._length;
    }

    public int getSize() {
        int size = super.getSize();
        size += 4;
        size += this._key.getSize();
        size += 4;
        int i = 0;
        while (i < this._entries.length) {
            size += this._entries[i].getSize();
            ++i;
        }
        return size;
    }

    public int readFromBuffer(byte[] buffer, int offset, int length) {
        int current = super.readFromBuffer(buffer, offset);
        long msgLength = Message.readRALongFromBuffer(buffer, current);
        if (current + 4 > offset + length || msgLength > (long)length) {
            throw new ArrayIndexOutOfBoundsException("Not enough bytes in the buffer array");
        }
        return this.readFromBuffer(buffer, offset);
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = super.readFromBuffer(buffer, offset);
        this._length = Message.readRALongFromBuffer(buffer, current);
        if (this._length > (long)buffer.length) {
            throw new ArrayIndexOutOfBoundsException("Not enough bytes in the buffer array");
        }
        current += 4;
        current = ControlMessage.readRAStringFromBuffer(buffer, current, this._key);
        long count = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        this._entries = new CommandElement[(int)count];
        int i = 0;
        while ((long)i < count) {
            long tag = Message.readRALongFromBuffer(buffer, current);
            current += 4;
            CommandElement command = null;
            switch ((int)tag) {
                case 1: {
                    command = new AuthenticateCommand();
                    current = ((AuthenticateCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 2: {
                    command = new AuthenticationFailedCommand();
                    current = ((AuthenticationFailedCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 3: {
                    command = new AuthenticationSuccessfulCommand();
                    current = ((AuthenticationSuccessfulCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 4: {
                    command = new ServerSecurityInfoCommand();
                    current = ((ServerSecurityInfoCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 16: {
                    command = new LaunchProcessCommand();
                    current = ((LaunchProcessCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 17: {
                    command = new QueryProcessListCommand();
                    current = ((QueryProcessListCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 18: {
                    command = new QueryAgentListCommand();
                    current = ((QueryAgentListCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 19: {
                    command = new RegisterAgentInterestCommand();
                    current = ((RegisterAgentInterestCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 20: {
                    command = new AttachToAgentCommand();
                    current = ((AttachToAgentCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 21: {
                    command = new DetachFromAgentCommand();
                    current = ((DetachFromAgentCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 22: {
                    command = new StartMonitoringRemoteAgentCommand();
                    current = ((StartMonitoringRemoteAgentCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 23: {
                    command = new StartMonitoringLocalAgentCommand();
                    current = ((StartMonitoringLocalAgentCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 24: {
                    command = new StopMonitorCommand();
                    current = ((StopMonitorCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 25: {
                    command = new SetNVPairCommand();
                    current = ((SetNVPairCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 26: {
                    command = new CustomCommand();
                    current = ((CustomCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 27: {
                    command = new KillProcessCommand();
                    current = ((KillProcessCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 28: {
                    command = new QueryAgentDetailsCommand();
                    current = ((QueryAgentDetailsCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 29: {
                    command = new BinaryCustomCommand();
                    current = ((BinaryCustomCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 30: {
                    command = new GetPropertyListCommand();
                    current = ((GetPropertyListCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 31: {
                    command = new ManageFileCommand();
                    current = ((ManageFileCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 32: {
                    command = new ProcessLaunchedCommand();
                    current = ((ProcessLaunchedCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 33: {
                    command = new RegisteredProcessListCommand();
                    current = ((RegisteredProcessListCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 34: {
                    command = new ActiveAgentListCommand();
                    current = ((ActiveAgentListCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 35: {
                    command = new AgentActiveCommand();
                    current = ((AgentActiveCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 36: {
                    command = new AgentInactiveCommand();
                    current = ((AgentInactiveCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 37: {
                    command = new ErrorCommand();
                    current = ((ErrorCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 38: {
                    break;
                }
                case 39: {
                    break;
                }
                case 40: {
                    command = new AgentDetailsCommand();
                    current = ((AgentDetailsCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 41: {
                    command = new ProcessExitedCommand();
                    current = ((ProcessExitedCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 42: {
                    command = new PropertyListCommand();
                    current = ((PropertyListCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 43: {
                    command = new AgentQueryStateCommand();
                    current = ((AgentQueryStateCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 44: {
                    command = new AgentAttachedCommand();
                    current = ((AgentAttachedCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 45: {
                    command = new AgentDetachedCommand();
                    current = ((AgentDetachedCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 48: {
                    break;
                }
                case 49: {
                    command = new AgentScopingInformationCommand();
                    current = ((AgentScopingInformationCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 50: {
                    command = new AgentConfigurationCommand();
                    current = ((AgentConfigurationCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 80: {
                    break;
                }
                case 81: {
                    break;
                }
                case 97: {
                    command = new AgentRequestMonitorCommand();
                    current = ((AgentRequestMonitorCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 98: {
                    command = new MonitorPeerRequestCommand();
                    current = ((MonitorPeerRequestCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 99: {
                    command = new PeerUnreachableCommand();
                    current = ((PeerUnreachableCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 100: {
                    break;
                }
                case 101: {
                    command = new AgentRequestMonitorPortCommand();
                    current = ((AgentRequestMonitorPortCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 102: {
                    command = new MonitorPeerRequestPortCommand();
                    current = ((MonitorPeerRequestPortCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 112: {
                    command = new ResourceLocation();
                    current = ((ResourceLocation)command).readFromBuffer(buffer, current);
                    break;
                }
            }
            this._entries[i] = command;
            ++i;
        }
        return current;
    }

    public void setKey(RAString key) {
        this._key = key;
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = super.writeToBuffer(buffer, offset);
        this._length = this.getSize();
        current = Message.writeRALongToBuffer(buffer, current, this._length);
        current = ControlMessage.writeRAStringToBuffer(buffer, current, this._key);
        current = Message.writeRALongToBuffer(buffer, current, this._entries.length);
        int i = 0;
        while (i < this._entries.length) {
            current = this._entries[i].writeToBuffer(buffer, current);
            ++i;
        }
        return current;
    }
}

