/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.file;

import org.eclipse.hyades.internal.execution.file.FileServerExtended;
import org.eclipse.hyades.internal.execution.file.IFileServer;
import org.eclipse.hyades.internal.execution.file.IFileServerParameters;
import org.eclipse.hyades.internal.execution.file.defaults.FileServerParametersExtendedImpl;

public class FileServer
implements IFileServer {
    private static int serverPort = -1;
    private IFileServer fileServer = this.createFileServer();

    public static synchronized int getServerPort() {
        return serverPort;
    }

    static synchronized void setServerPort(int serverPort) {
        FileServer.serverPort = serverPort;
    }

    public FileServer() {
    }

    public FileServer(int port) {
        this();
        FileServerParametersExtendedImpl fileServerParameters = new FileServerParametersExtendedImpl(){};
        if (port < 0) {
            throw new IllegalArgumentException();
        }
        fileServerParameters.setPort(port);
        this.fileServer.init(fileServerParameters);
    }

    private IFileServer createFileServer() {
        return this.createFileServerExtended();
    }

    private IFileServer createFileServerExtended() {
        return new FileServerExtended();
    }

    public int getErrorType() {
        return this.fileServer.getErrorType();
    }

    public int getFileServerStatus() {
        return this.fileServer.getFileServerStatus();
    }

    public void init(IFileServerParameters parameters) {
        this.fileServer.init(parameters);
    }

    public void quit() {
        this.fileServer.quit();
    }

    public void run() {
        Thread runFileServer = new Thread(){

            public void run() {
                FileServer.this.fileServer.run();
            }
        };
        runFileServer.setName("File System Services Connection Server");
        runFileServer.setDaemon(true);
        runFileServer.start();
    }
}

