/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file.dynamic;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.FileSystemServices;
import org.eclipse.hyades.internal.execution.core.file.dynamic.AbstractFileTransferCommand;
import org.eclipse.hyades.internal.execution.core.file.dynamic.IPutFileCommand;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

class PutFileCommand
extends AbstractFileTransferCommand
implements IPutFileCommand {
    private static final Pattern REGULAR_EXPRESSION = Pattern.compile("\\.");
    static /* synthetic */ Class class$0;

    public PutFileCommand(String context, ISocketChannel channel) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.PutFileCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz);
        this.setState(new Server(channel));
    }

    PutFileCommand(String context, ISocketChannel channel, IFileManagerExtended.Cookie cookie, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.hyades.internal.execution.core.file.dynamic.PutFileCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz, cookie, localIdentifiers, remoteIdentifiers, options, monitor);
        this.setState(new Client(channel));
    }

    private class Client
    extends AbstractFileTransferCommand.Client {
        Client(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            super.execute();
            IFileManagerExtended.FileIdentifierList localIdentifiers = PutFileCommand.this.localIdentifiers;
            IFileManagerExtended.FileIdentifierList remoteIdentifiers = PutFileCommand.this.remoteIdentifiers;
            IFileManagerExtended.FileIdentifierList.filter(localIdentifiers, remoteIdentifiers, new IFileManagerExtended.FileIdentifierList.Filter(this){
                final /* synthetic */ Client this$1;
                {
                    this.this$1 = client;
                }

                public boolean filter(String localIdentifier, String remoteIdentifier) {
                    return !new File(localIdentifier).isFile();
                }
            });
            this.communicator.send(localIdentifiers.size());
            this.communicator.send(remoteIdentifiers.getArray());
            Iterator identifiers = localIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File localFile = new File(fileName);
                this.communicator.send(localFile);
            }
            String[] remoteIdentifierResolutions = this.communicator.receiveStrings();
            int i = 0;
            while (i < remoteIdentifierResolutions.length) {
                String remoteIdentifierResolution = remoteIdentifierResolutions[i];
                if (remoteIdentifierResolution != null) {
                    remoteIdentifiers.remove(i);
                    remoteIdentifiers.add(i, remoteIdentifierResolution);
                }
                ++i;
            }
        }
    }

    private class Server
    extends AbstractFileTransferCommand.Server {
        Server(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            IFileManagerExtended.FileIdentifierList remoteIdentifiers;
            super.execute();
            this.communicator.receiveInt();
            PutFileCommand.this.remoteIdentifiers = remoteIdentifiers = IFileManagerExtended.FileIdentifierList.create(this.communicator.receiveStrings());
            String[] remoteIdentifierResolutions = new String[remoteIdentifiers.size()];
            int index = 0;
            Iterator identifiers = remoteIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String remoteIdentifier = (String)identifiers.next();
                File remoteFile = new File(remoteIdentifier);
                if (remoteFile.isAbsolute()) {
                    boolean readyToTransfer = true;
                    File remoteDirectory = new File(remoteFile.getParent());
                    if (!remoteDirectory.exists()) {
                        readyToTransfer = remoteDirectory.mkdirs();
                    }
                    if (readyToTransfer) {
                        remoteFile.createNewFile();
                        this.communicator.receive(remoteFile);
                    }
                    FileSystemServices.println("Absolute file identifier " + remoteFile.getAbsolutePath() + " identified and file received by server", this);
                } else {
                    String[] segments = REGULAR_EXPRESSION.split(remoteIdentifier);
                    if (segments != null) {
                        File qualifiedDirectory;
                        String suffix = "";
                        String prefix = "";
                        int length = segments.length;
                        int i = 0;
                        while (i < length - 1) {
                            prefix = String.valueOf(prefix) + segments[i] + ".";
                            ++i;
                        }
                        if (prefix.length() == 0) {
                            prefix = remoteIdentifier;
                        } else {
                            suffix = segments[length - 1];
                        }
                        String temporaryDirectory = System.getProperty("java.io.tmpdir");
                        String qualifiedFilePrefix = String.valueOf(temporaryDirectory) + (temporaryDirectory.lastIndexOf(File.separatorChar) == temporaryDirectory.length() - 1 ? "" : "/") + prefix;
                        int firstSeparator = qualifiedFilePrefix.indexOf(File.separator);
                        int lastSeparator = Math.max(qualifiedFilePrefix.lastIndexOf(File.separator), qualifiedFilePrefix.lastIndexOf(47));
                        if (firstSeparator >= 0 && firstSeparator != lastSeparator) {
                            String qualifiedFilePrefixParent = qualifiedFilePrefix.substring(0, lastSeparator);
                            qualifiedDirectory = new File(qualifiedFilePrefixParent);
                            qualifiedDirectory.mkdirs();
                            prefix = qualifiedFilePrefix.substring(lastSeparator + 1);
                        } else {
                            qualifiedDirectory = new File(qualifiedFilePrefix);
                        }
                        remoteFile = new File(qualifiedDirectory, prefix.concat(suffix));
                        remoteIdentifierResolutions[index] = remoteFile.getAbsolutePath();
                    }
                    this.communicator.receive(remoteFile);
                    FileSystemServices.println("Relative file identifier resolved to " + remoteFile.getAbsolutePath() + " and file received by server", this);
                }
                ++index;
            }
            this.communicator.send(remoteIdentifierResolutions);
        }
    }
}

