/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file.communicator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.eclipse.hyades.internal.execution.core.file.communicator.IChannelCommunicator;

class ChannelCommunicator
implements IChannelCommunicator {
    private ReadableByteChannel readableChannel;
    private WritableByteChannel writableChannel;

    ChannelCommunicator(ReadableByteChannel readableChannel, WritableByteChannel writableChannel) {
        this.readableChannel = readableChannel;
        this.writableChannel = writableChannel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receive(File file) throws IOException {
        long receivedLength2;
        long length;
        block8: {
            length = 0L;
            try {
                length = this.receiveLong();
            }
            catch (IOException iOException) {
                throw new FileNotFoundException();
            }
            try {
                FileOutputStream outputStream = new FileOutputStream(file);
                FileChannel outputChannel = outputStream.getChannel();
                outputChannel.transferFrom(this.readableChannel, 0L, length);
                outputChannel.close();
                outputStream.close();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                long receivedLength2 = -1L;
                if (file.exists()) {
                    receivedLength2 = file.length();
                }
                this.send(receivedLength2);
                if (receivedLength2 != length) {
                    throw new IOException();
                }
                throw throwable;
            }
            {
                Object var6_7 = null;
                receivedLength2 = -1L;
                if (!file.exists()) break block8;
                receivedLength2 = file.length();
            }
        }
        this.send(receivedLength2);
        if (receivedLength2 != length) {
            throw new IOException();
        }
    }

    public byte[] receiveBytes(int length) throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(length);
            while (buffer.hasRemaining()) {
                this.readableChannel.read(buffer);
            }
            buffer.flip();
            byte[] receivedBytes = new byte[length];
            buffer.get(receivedBytes);
            return receivedBytes;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException();
        }
    }

    public int receiveInt() throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            while (buffer.hasRemaining()) {
                this.readableChannel.read(buffer);
            }
            buffer.flip();
            return buffer.getInt();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException();
        }
    }

    public long receiveLong() throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            while (buffer.hasRemaining()) {
                this.readableChannel.read(buffer);
            }
            buffer.flip();
            return buffer.getLong();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new IOException();
        }
    }

    public String receiveString() throws IOException {
        int length = this.receiveInt();
        if (length >= 0) {
            byte[] bytes = this.receiveBytes(length);
            return new String(bytes, "UTF-8");
        }
        return null;
    }

    public String[] receiveStrings() throws IOException {
        int length = this.receiveInt();
        String[] strings = new String[length];
        int i = 0;
        while (i < length) {
            strings[i] = this.receiveString();
            ++i;
        }
        return strings;
    }

    public void send(byte[] bytes) throws IOException {
        int length = bytes.length;
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.put(bytes);
        buffer.flip();
        this.writableChannel.write(buffer);
    }

    public void send(File file) throws IOException, FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        FileChannel inputChannel = inputStream.getChannel();
        long length = file.length();
        this.send(length);
        inputChannel.transferTo(0L, length, this.writableChannel);
        inputChannel.close();
        inputStream.close();
        long receivedLength = this.receiveLong();
        if (receivedLength != length) {
            throw new IOException();
        }
    }

    public void send(int data) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(data);
        buffer.flip();
        this.writableChannel.write(buffer);
    }

    public void send(long data) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(data);
        buffer.flip();
        this.writableChannel.write(buffer);
    }

    public void send(String data) throws IOException {
        this.send(data, false);
    }

    public void send(String data, boolean tagLength) throws IOException {
        if (data != null) {
            byte[] bytes = data.getBytes("UTF-8");
            int length = bytes.length;
            if (tagLength) {
                length *= -1;
            }
            this.send(length);
            this.send(bytes);
        } else {
            this.send(-1);
        }
    }

    public void send(String[] data) throws IOException {
        this.send(data.length);
        int i = 0;
        while (i < data.length) {
            this.send(data[i]);
            ++i;
        }
    }
}

