/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.IFileServerCommand;
import org.eclipse.hyades.internal.execution.core.file.socket.ISocketChannel;

public abstract class AbstractFileServerCommand
implements IFileServerCommand {
    private IFileManagerExtended.Cookie cookie;
    private Class identity;
    private IProgressMonitor monitor;
    private IFileManagerExtended.Option[] options;
    private IFileServerCommand state;

    AbstractFileServerCommand(Class identity, IFileManagerExtended.Cookie cookie, IFileManagerExtended.Option[] options, IProgressMonitor monitor) {
        if (this.cookie != null) {
            // empty if block
        }
        if (this.monitor != null) {
            // empty if block
        }
        this.identity = identity;
        this.cookie = cookie;
        this.options = options;
        this.monitor = monitor;
    }

    AbstractFileServerCommand(Class identity) {
        this(identity, IFileManagerExtended.Cookie.NONE, IFileManagerExtended.Option.NONE, (IProgressMonitor)new NullProgressMonitor());
    }

    public final void execute() throws IOException {
        if (this.state != null) {
            this.state.execute();
        } else {
            System.out.println("There is no behavior defined for the current state of this command: " + this);
        }
    }

    IFileManagerExtended.Option[] getOptions() {
        return this.options;
    }

    void setState(IFileServerCommand state) {
        this.state = state;
    }

    public void dispose() {
        this.state.dispose();
    }

    abstract class Client
    extends State {
        Client(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            this.send(AbstractFileServerCommand.this.identity.getName());
        }
    }

    abstract class Server
    extends State {
        Server(ISocketChannel client) {
            super(client);
        }

        public void execute() throws IOException {
        }
    }

    abstract class State
    implements IFileServerCommand {
        private final ISocketChannel channel;

        State(ISocketChannel channel) {
            this.channel = channel;
        }

        public void dispose() {
            try {
                if (this.channel != null && this.channel.isOpen()) {
                    this.channel.close();
                }
            }
            catch (IOException iOException) {}
        }

        ISocketChannel channel() {
            return this.channel;
        }

        boolean isOpen() {
            return this.channel != null ? this.channel.isOpen() : false;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void receive(File file) throws IOException {
            long receivedLength2;
            long length;
            block8: {
                length = 0L;
                try {
                    length = this.receiveLong();
                }
                catch (IOException iOException) {
                    throw new FileNotFoundException();
                }
                try {
                    FileOutputStream outputStream = new FileOutputStream(file);
                    FileChannel outputChannel = outputStream.getChannel();
                    outputChannel.transferFrom(this.channel, 0L, length);
                    outputChannel.close();
                    outputStream.close();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    long receivedLength2 = -1L;
                    if (file.exists()) {
                        receivedLength2 = file.length();
                    }
                    this.send(receivedLength2);
                    if (receivedLength2 != length) {
                        throw new IOException();
                    }
                    throw throwable;
                }
                {
                    Object var6_7 = null;
                    receivedLength2 = -1L;
                    if (!file.exists()) break block8;
                    receivedLength2 = file.length();
                }
            }
            this.send(receivedLength2);
            if (receivedLength2 != length) {
                throw new IOException();
            }
        }

        int receiveInt() throws IOException {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(4);
                this.channel.read(buffer);
                buffer.flip();
                return buffer.getInt();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                throw new IOException();
            }
        }

        long receiveLong() throws IOException {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                this.channel.read(buffer);
                buffer.flip();
                return buffer.getLong();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                throw new IOException();
            }
        }

        String receiveString() throws IOException {
            int length = this.receiveInt();
            byte[] bytes = this.receiveBytes(length);
            String string = new String(bytes, "UTF-8");
            return string;
        }

        byte[] receiveBytes(int length) throws IOException {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(length);
                this.channel.read(buffer);
                buffer.flip();
                return buffer.array();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                throw new IOException();
            }
        }

        String[] receiveStrings() throws IOException {
            int length = this.receiveInt();
            String[] strings = new String[length];
            int i = 0;
            while (i < length) {
                strings[i] = this.receiveString();
                ++i;
            }
            return strings;
        }

        void send(File file) throws IOException, FileNotFoundException {
            FileInputStream inputStream = new FileInputStream(file);
            FileChannel inputChannel = inputStream.getChannel();
            long length = file.length();
            this.send(length);
            inputChannel.transferTo(0L, length, this.channel);
            inputChannel.close();
            inputStream.close();
            long receivedLength = this.receiveLong();
            if (receivedLength != length) {
                throw new IOException();
            }
        }

        void send(int data) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(data);
            buffer.flip();
            this.channel.write(buffer);
        }

        void send(long data) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(data);
            buffer.flip();
            this.channel.write(buffer);
        }

        void send(String data) throws IOException {
            byte[] bytes = data.getBytes("UTF-8");
            this.send(bytes.length);
            this.send(bytes);
        }

        void send(byte[] bytes) throws IOException {
            int length = bytes.length;
            ByteBuffer buffer = ByteBuffer.allocate(length);
            buffer.put(bytes);
            buffer.flip();
            this.channel.write(buffer);
        }

        void send(String[] data) throws IOException {
            this.send(data.length);
            int i = 0;
            while (i < data.length) {
                this.send(data[i]);
                ++i;
            }
        }
    }
}

