/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.security;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

public class X509KeyManagerImpl
implements X509KeyManager {
    private KeyManager[] kmList = null;
    private X509KeyManager km = null;
    private String clientAlias = null;
    private String serverAlias = null;

    public X509KeyManagerImpl(KeyManagerFactory kmf) {
        this.kmList = kmf.getKeyManagers();
        if (this.kmList != null) {
            this.km = (X509KeyManager)this.kmList[0];
        }
    }

    public PrivateKey getPrivateKey(String s) {
        return this.km.getPrivateKey(s);
    }

    public X509Certificate[] getCertificateChain(String s) {
        return this.km.getCertificateChain(s);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.km.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.km.getServerAliases(keyType, issuers);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket sock) {
        if (this.serverAlias != null && !this.serverAlias.equals("")) {
            String[] list = this.km.getServerAliases(keyType, issuers);
            String aliases = "";
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    aliases = String.valueOf(aliases) + list[i] + " ";
                    if (this.serverAlias.equalsIgnoreCase(list[i])) {
                        return this.serverAlias;
                    }
                    ++i;
                }
            }
            return this.serverAlias;
        }
        return this.km.chooseServerAlias(keyType, issuers, sock);
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket sock) {
        if (this.clientAlias != null && !this.clientAlias.equals("")) {
            String[] list = this.km.getClientAliases(keyType[0], issuers);
            String aliases = "";
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    aliases = String.valueOf(aliases) + list[i] + " ";
                    if (this.clientAlias.equalsIgnoreCase(list[i])) {
                        return this.clientAlias;
                    }
                    ++i;
                }
            }
            return this.clientAlias;
        }
        return this.km.chooseClientAlias(keyType, issuers, null);
    }
}

