/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.security;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.eclipse.hyades.execution.security.IKeystoreManager;
import org.eclipse.hyades.execution.security.ISecureClientParameters;

public final class SecureClient {
    private SSLSocket sslsocket;

    private IKeystoreManager loadKeystore(ISecureClientParameters params) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException, IOException {
        IKeystoreManager manager = params.getKeystoreManager();
        manager.loadKeystore(params.getKeystoreFileName(), params.getKeystoreFilepassword());
        return manager;
    }

    public void init(ISecureClientParameters params, String host, int port) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException, IOException {
        int protocolOffset = 0;
        IKeystoreManager keyManager = null;
        keyManager = this.loadKeystore(params);
        SSLContext sslContext = null;
        String[] sslProtocols = params.getEnabledProtocols();
        while (true) {
            try {
                sslContext = SSLContext.getInstance(sslProtocols[protocolOffset]);
            }
            catch (NoSuchAlgorithmException e) {
                if (++protocolOffset != sslProtocols.length) continue;
                throw e;
                if (protocolOffset < sslProtocols.length) continue;
            }
            break;
        }
        sslContext.init(keyManager.getKeyManagers(), keyManager.getTrustManagers(), null);
        this.sslsocket = (SSLSocket)sslContext.getSocketFactory().createSocket(host, port);
        this.sslsocket.setEnabledCipherSuites(params.getEnabledCipherSuites());
        this.sslsocket.startHandshake();
        SSLSession session = this.sslsocket.getSession();
        if (session == null) {
            System.out.println("Session is null. Socket connection failed");
            throw new IOException("No socket session created");
        }
    }

    public SSLSocket getSocket() {
        return this.sslsocket;
    }
}

