/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local.testservices;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.local.testservices.ITestService;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;

public class TestServiceAgentListener
implements AgentListener {
    public void agentActive(Agent agent) {
    }

    public void agentInactive(Agent agent) {
    }

    public void error(Agent agent, String errorId, String errorMessage) {
    }

    public void handleCommand(Agent agent, CommandElement command) {
        if (command instanceof CustomCommand) {
            CustomCommand customCommand = (CustomCommand)command;
            String commandData = customCommand.getData();
            StringBuffer returnCommand = new StringBuffer();
            if (commandData.startsWith("TestServiceCall:")) {
                Pattern pattern = Pattern.compile("TestServiceCall:([^#]+)##(\\d+)##(.*)");
                Matcher matcher = pattern.matcher(commandData);
                if (matcher.find()) {
                    String service = matcher.group(1);
                    String id = matcher.group(2);
                    String args = matcher.group(3);
                    ITestService serviceImpl = TestServiceAgentListener.getTestService(service);
                    if (serviceImpl != null) {
                        String result = serviceImpl.run(args, agent);
                        returnCommand.append("TestServiceReturn:");
                        returnCommand.append(id);
                        returnCommand.append("##");
                        returnCommand.append(result);
                    } else {
                        returnCommand.append("TestServiceUnknown:");
                        returnCommand.append(id);
                    }
                } else {
                    returnCommand.append("TestServiceMalformed:");
                    returnCommand.append(commandData);
                }
                customCommand.setData(returnCommand.toString());
                try {
                    agent.invokeCustomCommand(customCommand);
                }
                catch (InactiveAgentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static ITestService getTestService(String service) {
        ITestService serviceImpl = null;
        IExtension extension2 = Platform.getExtensionRegistry().getExtension("org.eclipse.hyades.execution.testService", service);
        if (extension2 != null) {
            IConfigurationElement[] elements = extension2.getConfigurationElements();
            try {
                int i = 0;
                while (i < elements.length) {
                    Object executableExtension;
                    IConfigurationElement element = elements[i];
                    if (element.getName().equalsIgnoreCase("testservice") && (executableExtension = element.createExecutableExtension("class")) instanceof ITestService) {
                        serviceImpl = (ITestService)executableExtension;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        return serviceImpl;
    }
}

