/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import java.io.IOException;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.invocation.CallData;
import org.eclipse.hyades.execution.invocation.IRemoteObject;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.execution.local.SessionImpl;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;

public abstract class RemoteObjectStub
implements IRemoteObject {
    protected Integer uniqueId = new Integer(this.hashCode());
    protected ISession sessionContext;
    protected Object delegate;

    public Integer getUniqueId() {
        return this.uniqueId;
    }

    public ReturnData delegateRemoteCall(Class[] argTypes, Object[] callArgs, String call) throws RemoteInvocationException {
        ReturnData tmp;
        CallData callData = new CallData(this.getUniqueId(), argTypes, callArgs, call);
        BinaryCustomCommand command = new BinaryCustomCommand();
        try {
            command.setData(Marshaller.marshalMethodCall(callData));
        }
        catch (IOException e) {
            throw new RemoteInvocationException(e);
        }
        try {
            SessionStub sessStub = (SessionStub)this.getSessionContext();
            ((SessionImpl)sessStub.getDelegate()).invokeRemote(command);
        }
        catch (ClassCastException classCastException) {
            throw new RemoteInvocationException("Class is not a child of a ISession instance");
        }
        ReturnData returnData = null;
        do {
            try {
                Marshaller.waitForReturnDataWithTimeout();
            }
            catch (InterruptedException e) {
                throw new RemoteInvocationException(e);
            }
        } while (!callData.isForSameCallAs(tmp = Marshaller.peekReturnValue()));
        returnData = Marshaller.unqueueReturnValue();
        return returnData;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public void init() {
    }

    public ISession getSessionContext() {
        return this.sessionContext;
    }

    public void setSessionContext(ISession session) {
        this.sessionContext = session;
    }
}

