/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.invocation;

public abstract class MarshalData {
    protected Integer targetId;
    protected Class[] argTypes;
    protected String call;

    protected MarshalData(Integer targetId, Class[] argTypes, String call) {
        this.targetId = targetId;
        this.argTypes = argTypes;
        this.call = call;
    }

    private MarshalData() {
    }

    public Integer getTargetId() {
        return this.targetId;
    }

    public Class[] getArgTypes() {
        return this.argTypes;
    }

    public String getCall() {
        return this.call;
    }

    public boolean isForSameCallAs(MarshalData comp) {
        if (comp == null) {
            return false;
        }
        if (!this.targetId.equals(comp.targetId)) {
            return false;
        }
        if (!this.call.equals(comp.call)) {
            return false;
        }
        if (this.argTypes.length != comp.argTypes.length) {
            return false;
        }
        int idx = 0;
        while (idx < this.argTypes.length) {
            if (!this.argTypes[idx].equals(comp.argTypes[idx])) {
                return false;
            }
            ++idx;
        }
        return true;
    }
}

