/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.util;

import java.io.File;
import java.rmi.dgc.VMID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;

public final class Guid {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] STRING_BUFFER = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final long UTC_OFFSET = 122192928000000000L;
    private static final short GUID_VERSION_1 = 4096;
    private static final byte GUID_RESERVED = -128;
    private static final int MAX_CLOCK_SEQ_ADJUST = 9999;
    private static final Object _internalsLock = new Object();
    private static byte[] _ieee802Addr = new byte[6];
    private static boolean _internalsSet = false;
    private static long _lastTimestamp = 0L;
    private static int _clock_seq_adjust = 0;
    private static Random randomNumberGenerator = null;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private int time_low = 0;
    private short time_mid = 0;
    private short time_hi_and_version = 0;
    private byte clock_seq_hi_and_reserved = 0;
    private byte clock_seq_low = 0;
    private byte[] node = new byte[6];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Guid() {
        long adjustedTimestamp = 0L;
        long clockSeq = 0L;
        this.initialize();
        Object object = _internalsLock;
        synchronized (object) {
            if (!_internalsSet) {
                this.getPseudoIEEE802Address(_ieee802Addr);
                adjustedTimestamp = Guid.getAdjustedTimestamp();
                try {
                    randomNumberGenerator = SecureRandom.getInstance("MD5");
                    randomNumberGenerator.setSeed(adjustedTimestamp);
                }
                catch (Throwable throwable) {
                    randomNumberGenerator = new Random(adjustedTimestamp);
                }
                clockSeq = randomNumberGenerator.nextLong();
                _internalsSet = true;
            }
            boolean timeIsValid = true;
            do {
                if ((adjustedTimestamp = Guid.getAdjustedTimestamp()) < _lastTimestamp) {
                    clockSeq = randomNumberGenerator.nextLong();
                    _clock_seq_adjust = 0;
                }
                if (adjustedTimestamp > _lastTimestamp) {
                    _clock_seq_adjust = 0;
                }
                if (adjustedTimestamp != _lastTimestamp) continue;
                if (_clock_seq_adjust < 9999) {
                    ++_clock_seq_adjust;
                    continue;
                }
                timeIsValid = false;
            } while (!timeIsValid);
            _lastTimestamp = adjustedTimestamp;
            if (_clock_seq_adjust != 0) {
                adjustedTimestamp += (long)_clock_seq_adjust;
            }
        }
        long tempValue = adjustedTimestamp & 0xFFFFFFFFL;
        this.time_low = (int)tempValue;
        tempValue = adjustedTimestamp >> 32 & 0xFFFL;
        this.time_mid = (short)tempValue;
        tempValue = adjustedTimestamp >> 48 & 0xFFFL;
        this.time_hi_and_version = (short)tempValue;
        this.time_hi_and_version = (short)(this.time_hi_and_version + 4096);
        tempValue = clockSeq & 0xFFL;
        this.clock_seq_low = (byte)tempValue;
        tempValue = (clockSeq & 0x3F00L) >> 8;
        this.clock_seq_hi_and_reserved = (byte)tempValue;
        this.clock_seq_hi_and_reserved = (byte)(this.clock_seq_hi_and_reserved + -128);
        System.arraycopy(_ieee802Addr, 0, this.node, 0, this.node.length);
    }

    private static long getAdjustedTimestamp() {
        long currentTimestamp = System.currentTimeMillis();
        long adjustedTimestamp = currentTimestamp * 10000L + 122192928000000000L;
        return adjustedTimestamp;
    }

    private void initialize() {
        this.time_low = 0;
        this.time_mid = 0;
        this.time_hi_and_version = 0;
        this.clock_seq_low = 0;
        this.clock_seq_hi_and_reserved = 0;
        int j = 0;
        while (j < this.node.length) {
            this.node[j] = 0;
            ++j;
        }
    }

    private void getPseudoIEEE802Address(byte[] ieee802Addr) {
        byte[] freeMemory = Guid.getByteArrayFromString(String.valueOf(Runtime.getRuntime().freeMemory()));
        byte[] totalMemory = Guid.getByteArrayFromString(String.valueOf(Runtime.getRuntime().totalMemory()));
        byte[] numberOfRoots = Guid.getByteArrayFromString(String.valueOf(File.listRoots().length));
        byte[] currentTime = Guid.getByteArrayFromString(String.valueOf(System.currentTimeMillis()));
        byte[] numberOfThreads = Guid.getByteArrayFromString(String.valueOf(Thread.currentThread().getThreadGroup().getParent().activeCount()));
        byte[] vmid = new VMID().toString().getBytes();
        long count = 0L;
        File rootDirectory = new File("/");
        File[] files = rootDirectory.listFiles();
        byte[] totalRootFilesSize = new byte[1];
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                count += files[i].length();
                ++i;
            }
            totalRootFilesSize = Guid.getByteArrayFromString(String.valueOf(count));
        }
        byte[] hashcode = null;
        byte[] bytes = new byte[freeMemory.length + totalMemory.length + numberOfRoots.length + currentTime.length + numberOfThreads.length + vmid.length + totalRootFilesSize.length];
        int bytesPos = 0;
        System.arraycopy(freeMemory, 0, bytes, bytesPos, freeMemory.length);
        System.arraycopy(totalMemory, 0, bytes, bytesPos += freeMemory.length, totalMemory.length);
        System.arraycopy(numberOfRoots, 0, bytes, bytesPos += totalMemory.length, numberOfRoots.length);
        System.arraycopy(currentTime, 0, bytes, bytesPos += numberOfRoots.length, currentTime.length);
        System.arraycopy(numberOfThreads, 0, bytes, bytesPos += currentTime.length, numberOfThreads.length);
        System.arraycopy(vmid, 0, bytes, bytesPos += numberOfThreads.length, vmid.length);
        System.arraycopy(totalRootFilesSize, 0, bytes, bytesPos += vmid.length, totalRootFilesSize.length);
        bytesPos += totalRootFilesSize.length;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            hashcode = md5.digest(bytes);
        }
        catch (NoSuchAlgorithmException nsax) {
            nsax.printStackTrace();
        }
        System.arraycopy(hashcode, 0, ieee802Addr, 0, 6);
        ieee802Addr[0] = (byte)(ieee802Addr[0] | 0xFFFFFF80);
    }

    private static byte[] getByteArrayFromString(String s) {
        int dataLength = s.length();
        s = String.valueOf(s) + "  ";
        String hcs = new String(hexChars);
        byte[] data = new byte[dataLength / 2];
        int j = 0;
        while (j < dataLength - 1) {
            data[j / 2] = (byte)(hcs.indexOf(s.substring(j, j + 1)) << 4);
            int n = j / 2;
            data[n] = (byte)(data[n] + hcs.indexOf(s.substring(j + 1, j + 2)));
            j += 2;
        }
        return data;
    }

    public String toString() {
        int pos = 0;
        int shift = 28;
        pos = 0;
        while (pos < 8) {
            Guid.STRING_BUFFER[pos] = pos == 0 ? 78 : HEX_CHARS[this.time_low >> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        shift = 12;
        pos = 8;
        while (pos < 12) {
            Guid.STRING_BUFFER[pos] = HEX_CHARS[this.time_mid >> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        shift = 12;
        pos = 12;
        while (pos < 16) {
            Guid.STRING_BUFFER[pos] = HEX_CHARS[this.time_hi_and_version >> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        Guid.STRING_BUFFER[16] = HEX_CHARS[this.clock_seq_hi_and_reserved >> 4 & 0xF];
        Guid.STRING_BUFFER[17] = HEX_CHARS[this.clock_seq_hi_and_reserved & 0xF];
        Guid.STRING_BUFFER[18] = HEX_CHARS[this.clock_seq_low >> 4 & 0xF];
        Guid.STRING_BUFFER[19] = HEX_CHARS[this.clock_seq_low & 0xF];
        int i = 0;
        pos = 20;
        while (pos < 32) {
            Guid.STRING_BUFFER[pos] = HEX_CHARS[this.node[i] >> 4 & 0xF];
            Guid.STRING_BUFFER[pos + 1] = HEX_CHARS[this.node[i] & 0xF];
            ++i;
            pos += 2;
        }
        String hexString = new String(STRING_BUFFER);
        return hexString.trim();
    }

    public static void main(String[] args) {
        Hashtable<String, Integer> generatedGuids = new Hashtable<String, Integer>();
        String guid = "";
        int counter = 0;
        while (counter < 10) {
            guid = new Guid().toString();
            if (generatedGuids.containsKey(guid)) {
                generatedGuids.put(guid, new Integer((Integer)generatedGuids.get(guid) + 1));
            } else {
                generatedGuids.put(guid, new Integer(1));
            }
            ++counter;
        }
        Enumeration enumeration = generatedGuids.keys();
        while (enumeration.hasMoreElements()) {
            guid = (String)enumeration.nextElement();
            System.out.println("'" + guid + "' has been duplicated " + generatedGuids.get(guid) + " time(s).");
        }
    }
}

