/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.task;

class ReusableThread
implements Runnable {
    private boolean isComplete;
    private boolean isDeathRequested;
    private boolean isStartable;
    private Runnable runnable;
    private final Thread thread = new Thread((Runnable)this, this.toString());

    ReusableThread() {
        this.thread.setDaemon(false);
        this.thread.start();
    }

    public void attach(Runnable runnable) {
        this.runnable = runnable;
        this.isComplete = false;
    }

    private void interrupt() {
        this.thread.interrupt();
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void kill() {
        this.isDeathRequested = true;
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isDeathRequested) {
            try {
                ReusableThread reusableThread = this;
                synchronized (reusableThread) {
                    this.isStartable = true;
                    this.notify();
                    this.wait();
                    this.isStartable = false;
                }
                this.isComplete = false;
                this.runnable.run();
                this.isComplete = true;
                reusableThread = this;
                synchronized (reusableThread) {
                    this.notify();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ReusableThread reusableThread;
        while (!this.isStartable) {
            try {
                reusableThread = this;
                synchronized (reusableThread) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        reusableThread = this;
        synchronized (reusableThread) {
            this.notify();
        }
    }

    public void stop() {
        this.interrupt();
    }
}

