/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.file;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.internal.execution.core.file.ServerNotAvailableException;

public interface IFileManagerExtended
extends IFileManager {
    public void deleteDirectory(FileIdentifierList var1) throws IOException, ServerNotAvailableException;

    public void deleteDirectory(FileIdentifierList var1, IProgressMonitor var2) throws IOException, ServerNotAvailableException;

    public void deleteFile(Cookie var1, IProgressMonitor var2) throws IOException, ServerNotAvailableException;

    public void deleteFile(FileIdentifierList var1) throws IOException, ServerNotAvailableException;

    public void deleteFile(FileIdentifierList var1, IProgressMonitor var2) throws IOException, ServerNotAvailableException;

    public void deleteFile(Cookie var1) throws IOException, ServerNotAvailableException;

    public boolean determineServerReach(String var1, int var2);

    public void getFile(FileIdentifierList var1, FileIdentifierList var2) throws IOException, ServerNotAvailableException;

    public void getFile(FileIdentifierList var1, FileIdentifierList var2, Option[] var3) throws IOException, ServerNotAvailableException;

    public void getFile(FileIdentifierList var1, FileIdentifierList var2, Option[] var3, IProgressMonitor var4) throws IOException, ServerNotAvailableException;

    public void getFile(FileIdentifierList var1, FileIdentifierList var2, IProgressMonitor var3) throws IOException, ServerNotAvailableException;

    public boolean[] isDirectoryExistent(FileIdentifierList var1) throws IOException, ServerNotAvailableException;

    public boolean[] isDirectoryExistent(FileIdentifierList var1, IProgressMonitor var2) throws IOException, ServerNotAvailableException;

    public boolean isServerAvailable() throws IOException;

    public FileIdentifierList listContent(FileIdentifierList var1) throws IOException, ServerNotAvailableException;

    public FileIdentifierList listContent(FileIdentifierList var1, IProgressMonitor var2) throws IOException, ServerNotAvailableException;

    public void modifyPermission(FileIdentifierList var1, String var2) throws IOException, ServerNotAvailableException;

    public void modifyPermission(FileIdentifierList var1, String var2, IProgressMonitor var3) throws IOException, ServerNotAvailableException;

    public void putFile(Cookie var1, FileIdentifierList var2, FileIdentifierList var3) throws IOException, ServerNotAvailableException;

    public void putFile(Cookie var1, FileIdentifierList var2, FileIdentifierList var3, Option[] var4) throws IOException, ServerNotAvailableException;

    public void putFile(Cookie var1, FileIdentifierList var2, FileIdentifierList var3, Option[] var4, IProgressMonitor var5) throws IOException, ServerNotAvailableException;

    public void putFile(Cookie var1, FileIdentifierList var2, FileIdentifierList var3, IProgressMonitor var4) throws IOException, ServerNotAvailableException;

    public void putFile(FileIdentifierList var1, FileIdentifierList var2) throws IOException, ServerNotAvailableException;

    public void putFile(FileIdentifierList var1, FileIdentifierList var2, Option[] var3) throws IOException, ServerNotAvailableException;

    public void putFile(FileIdentifierList var1, FileIdentifierList var2, Option[] var3, IProgressMonitor var4) throws IOException, ServerNotAvailableException;

    public void putFile(FileIdentifierList var1, FileIdentifierList var2, IProgressMonitor var3) throws IOException, ServerNotAvailableException;

    public void reset();

    public static class Cookie {
        public static final Cookie NONE = new Cookie();

        public static Cookie create() {
            return new Cookie();
        }

        private Cookie() {
        }
    }

    public static class FileIdentifierList {
        private static final long serialVersionUID = 3977859592212198201L;
        private List list;

        public static FileIdentifierList create() {
            return new FileIdentifierList();
        }

        public static FileIdentifierList create(String name) {
            return new FileIdentifierList(new String[]{name});
        }

        public static FileIdentifierList create(String[] names) {
            return new FileIdentifierList(names);
        }

        public static void filter(FileIdentifierList originalListA, FileIdentifierList resultantListA, FileIdentifierList originalListB, FileIdentifierList resultantListB, Filter filter) {
            Iterator iteratorA = originalListA.iterator();
            Iterator iteratorB = originalListB.iterator();
            while (iteratorA.hasNext() && iteratorB.hasNext()) {
                String identifierB;
                String identifierA = (String)iteratorA.next();
                if (filter.filter(identifierA, identifierB = (String)iteratorB.next())) continue;
                resultantListA.add(identifierA);
                resultantListB.add(identifierB);
            }
        }

        public static void filter(FileIdentifierList listA, FileIdentifierList listB, Filter filter) {
            int i = listA.size() - 1;
            while (i >= 0) {
                if (filter.filter(listA.get(i), listB.get(i))) {
                    listA.remove(i);
                    listB.remove(i);
                }
                --i;
            }
        }

        private FileIdentifierList() {
            this.list = new LinkedList();
        }

        private FileIdentifierList(String[] names) {
            this.list = new LinkedList<String>(Arrays.asList(names));
        }

        public void add(File file) {
            if (file == null) {
                file = new File("");
            }
            this.list.add(file.getAbsolutePath());
        }

        public void add(int index, String identifier) {
            this.list.add(index, identifier);
        }

        public void add(String identifier) {
            this.list.add(identifier);
        }

        public String get(int index) {
            return (String)this.list.get(index);
        }

        public FileIdentifierList getParentIdentifiers() {
            FileIdentifierList parentIdentifiers = FileIdentifierList.create();
            Iterator identifiers = this.list.iterator();
            while (identifiers.hasNext()) {
                String identifier = (String)identifiers.next();
                File parentFile = new File(identifier).getParentFile();
                parentIdentifiers.add(parentFile);
            }
            return parentIdentifiers;
        }

        public String[] getArray() {
            String[] identifiers = new String[this.size()];
            return this.list.toArray(identifiers);
        }

        public Iterator iterator() {
            return this.list.iterator();
        }

        public String remove(int index) {
            return (String)this.list.remove(index);
        }

        public boolean remove(String identifier) {
            return this.list.remove(identifier);
        }

        public int size() {
            return this.list.size();
        }

        public static interface Filter {
            public boolean filter(String var1, String var2);
        }
    }

    public static final class Option {
        public static final Option ENABLE_VERIFICATION = new Option();
        public static final Option[] NONE = new Option[0];
        public static final Option OPERATE_WITH_ATOMICITY = new Option();
        public static final Option OVERWRITE_ALL_EXISTING = new Option();
        public static final Option OVERWRITE_PARTIAL_EXISTING = new Option();
        public static final Option USE_TRANSFER_PACKAGING = new Option();

        Option() {
        }
    }
}

