/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.correlation;

import org.eclipse.hyades.collection.correlation.IApplication;
import org.eclipse.hyades.collection.correlation.ICorrelatorData;
import org.eclipse.hyades.collection.correlation.exceptions.InsufficientBufferLengthException;

public class BaseCorrelatorDataImpl
implements ICorrelatorData {
    private long applicationCounter = 0L;
    private long operationCounter = 0L;
    protected IApplication application = null;

    public void invalidate() {
        this.operationCounter = 0L;
        this.applicationCounter = 0L;
        this.application = null;
    }

    public void setApplicationCounter(long n) {
        this.applicationCounter = n;
    }

    public long getApplicationCounter() {
        return this.applicationCounter;
    }

    public void setOperationCounter(long n) {
        this.operationCounter = n;
    }

    public long getOperationCounter() {
        return this.operationCounter;
    }

    public long convertBytesToInteger(byte[] buffer, int offset) {
        return ((long)buffer[offset] & 0xFFL) << 24 | ((long)buffer[offset + 1] & 0xFFL) << 16 | ((long)buffer[offset + 2] & 0xFFL) << 8 | (long)buffer[offset + 3] & 0xFFL;
    }

    public void convertIntegerToBytes(long n, byte[] buffer, int offset) {
        buffer[offset] = (byte)(n >> 24);
        buffer[offset + 1] = (byte)(n >> 16);
        buffer[offset + 2] = (byte)(n >> 8);
        buffer[offset + 3] = (byte)n;
    }

    public int readBinary(byte[] buffer, int offset, int length) throws InsufficientBufferLengthException {
        if (length - offset < 8) {
            throw new InsufficientBufferLengthException(offset + 8);
        }
        this.applicationCounter = this.convertBytesToInteger(buffer, offset);
        this.operationCounter = this.convertBytesToInteger(buffer, offset + 4);
        return offset + 8;
    }

    public int writeBinary(byte[] buffer, int offset, int length) throws InsufficientBufferLengthException {
        if (length - offset < 8) {
            throw new InsufficientBufferLengthException(offset + 8);
        }
        this.convertIntegerToBytes(this.applicationCounter, buffer, offset);
        this.convertIntegerToBytes(this.operationCounter, buffer, offset + 4);
        return offset + 8;
    }

    public int readXML(StringBuffer data, int offset, int length) {
        String buffer = new String(data);
        int n = buffer.indexOf("<CorrelationData applicationCounter=\"") + 37;
        int m = buffer.indexOf("\" operationCounter=\"", n);
        this.applicationCounter = Long.parseLong(buffer.substring(n, m));
        n = buffer.indexOf("\"/>", m += 20);
        this.operationCounter = Long.parseLong(data.substring(m, n));
        return n + 3;
    }

    public StringBuffer writeXML(StringBuffer data) {
        data.append("<CorrelatorData applicationCounter=\"" + this.applicationCounter + "\" " + "operationCounter=\"" + this.operationCounter + "\"/>");
        return data;
    }

    void setApplication(IApplication application) {
        this.application = application;
    }

    public IApplication getApplication() {
        return this.application;
    }
}

