/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade.ast;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.merge.java.facade.JField;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJMember;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class ASTJField
extends ASTJMember
implements JField {
    protected static final Pattern CLEAR_INITIALIZER_MULTI_LINE = Pattern.compile("\\s*;(\\s*//.*)?$", 8);

    public ASTJField(FieldDeclaration fieldDeclaration) {
        super((BodyDeclaration)fieldDeclaration);
    }

    protected FieldDeclaration getASTFieldDeclaration() {
        return (FieldDeclaration)this.getASTBodyDeclaration();
    }

    public String getName() {
        List fragments = this.getASTFieldDeclaration().fragments();
        if (fragments.size() == 1) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
            return ASTFacadeHelper.toString((Name)fragment.getName());
        }
        return null;
    }

    public String getInitializer() {
        String contents = this.getContents();
        if (contents != null) {
            int index = contents.indexOf(61) + 1;
            if (index > 0 && index < contents.length()) {
                String initializer = contents.substring(index);
                String[] ret = CLEAR_INITIALIZER_MULTI_LINE.split(initializer);
                return ret[0];
            }
            return null;
        }
        return this.getInitializerFromAST();
    }

    protected String getInitializerFromAST() {
        List fragments = this.getASTFieldDeclaration().fragments();
        if (fragments.size() == 1) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
            Expression expression = fragment.getInitializer();
            return ASTFacadeHelper.toString(expression);
        }
        return null;
    }

    public void setInitializer(String initializer) {
    }

    public String getType() {
        return ASTFacadeHelper.toString(this.getASTFieldDeclaration().getType());
    }

    public void setType(String typeName) {
    }
}

