/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade.ast;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJField;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJImport;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJInitializer;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJMethod;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJNode;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJPackage;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class ASTFacadeHelper
extends FacadeHelper {
    protected ASTParser astParser;

    public static ASTNode getASTNode(JNode node) {
        return node instanceof ASTJNode ? ((ASTJNode)node).getASTNode() : null;
    }

    public static String toString(Name name) {
        return name == null ? null : name.getFullyQualifiedName();
    }

    public static String toString(Javadoc javadoc) {
        if (javadoc != null) {
            StringBuffer sb = new StringBuffer();
            String nl = System.getProperties().getProperty("line.separator");
            List tags = javadoc.tags();
            Iterator i = tags.iterator();
            while (i.hasNext()) {
                TagElement tagElement = (TagElement)i.next();
                Iterator j = tagElement.fragments().iterator();
                while (j.hasNext()) {
                    TextElement element = (TextElement)j.next();
                    sb.append(nl).append(element.getText());
                }
            }
            sb.delete(0, nl.length());
            return sb.toString();
        }
        return null;
    }

    public static String toString(Type type) {
        if (type != null) {
            String string = null;
            String dimensions = "";
            if (type.isArrayType()) {
                int i = ((ArrayType)type).getDimensions();
                while (i > 0) {
                    dimensions = String.valueOf(dimensions) + "[]";
                    --i;
                }
                while (type.isArrayType()) {
                    type = ((ArrayType)type).getComponentType();
                }
            }
            if (type.isSimpleType()) {
                string = ASTFacadeHelper.toString(((SimpleType)type).getName());
            } else if (type.isPrimitiveType()) {
                string = ((PrimitiveType)type).getPrimitiveTypeCode().toString();
            }
            if (dimensions.length() != 0) {
                string = String.valueOf(string) + dimensions;
            }
            return string;
        }
        return null;
    }

    public static String toString(Expression expression) {
        if (expression instanceof ArrayCreation) {
            ArrayCreation arrayCreation = (ArrayCreation)expression;
            arrayCreation.toString();
            String initializer = "new " + ASTFacadeHelper.toString((Type)arrayCreation.getType());
            Iterator i = arrayCreation.dimensions().iterator();
            while (i.hasNext()) {
                NumberLiteral numberLiteral = (NumberLiteral)i.next();
                initializer = initializer.replaceFirst("\\[\\]", "[" + numberLiteral.getToken() + "]");
            }
            return initializer;
        }
        if (expression instanceof NumberLiteral) {
            return ((NumberLiteral)expression).getToken();
        }
        if (expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getEscapedValue();
        }
        if (expression instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)expression;
            StringBuffer sb = new StringBuffer();
            sb.append(ASTFacadeHelper.toString(infixExpression.getLeftOperand()));
            sb.append(infixExpression.getOperator());
            sb.append(ASTFacadeHelper.toString(infixExpression.getRightOperand()));
            return sb.toString();
        }
        return null;
    }

    public void reset() {
        this.astParser = null;
        super.reset();
    }

    protected ASTParser getASTParser() {
        if (this.astParser == null) {
            this.astParser = ASTParser.newParser((int)3);
        }
        return this.astParser;
    }

    public JCompilationUnit createCompilationUnit(String name, String content) {
        char[] contentAsCharArray = content.toCharArray();
        this.getASTParser().setSource(contentAsCharArray);
        CompilationUnit astCompilationUnit = (CompilationUnit)this.astParser.createAST(null);
        astCompilationUnit.setProperty("ASTJCompilationUnit.name", (Object)name);
        JCompilationUnit compilationUnit = (JCompilationUnit)this.convertToNode(astCompilationUnit);
        ((ASTJCompilationUnit)compilationUnit).setOriginalContents(contentAsCharArray);
        return compilationUnit;
    }

    public Object getContext(JNode node) {
        return ASTFacadeHelper.getASTNode(node).getAST();
    }

    public JNode cloneNode(Object context, JNode node) {
        ASTNode astNode = null;
        if (node instanceof JCompilationUnit) {
            String content = this.applyFormatRules(node.getContents());
            return this.createCompilationUnit(node.getName(), content);
        }
        ASTNode originalASTNode = ASTFacadeHelper.getASTNode(node);
        if (originalASTNode != null) {
            astNode = ASTNode.copySubtree((AST)((AST)context), (ASTNode)originalASTNode);
        }
        return astNode != null ? this.convertToNode(astNode) : null;
    }

    protected JNode doConvertToNode(Object object) {
        ASTJNode node = null;
        if (object instanceof CompilationUnit) {
            node = new ASTJCompilationUnit((CompilationUnit)object);
        }
        if (object instanceof FieldDeclaration) {
            node = new ASTJField((FieldDeclaration)object);
        }
        if (object instanceof ImportDeclaration) {
            node = new ASTJImport((ImportDeclaration)object);
        }
        if (object instanceof Initializer) {
            node = new ASTJInitializer((Initializer)object);
        }
        if (object instanceof MethodDeclaration) {
            node = new ASTJMethod((MethodDeclaration)object);
        }
        if (object instanceof PackageDeclaration) {
            node = new ASTJPackage((PackageDeclaration)object);
        }
        if (object instanceof TypeDeclaration) {
            node = new ASTJType((TypeDeclaration)object);
        }
        if (node != null) {
            node.setFacadeHelper(this);
        }
        return node;
    }

    public boolean remove(JNode node) {
        ASTNode astNode = ASTFacadeHelper.getASTNode(node);
        ASTNode parent = astNode.getParent();
        if (parent != null) {
            astNode.delete();
            return true;
        }
        return false;
    }
}

