/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JETEmitter {
    protected String projectName = ".JETEmitters";
    protected Method method;
    protected Object object;
    protected String[] templateURIPath;
    protected String templateURI;
    protected ClassLoader classLoader;
    protected String encoding;
    protected List classpathEntries = new ArrayList();

    public JETEmitter(String templateURI) {
        this.templateURI = templateURI;
        this.classLoader = this.getClass().getClassLoader();
    }

    public JETEmitter(String[] templateURIPath, String relativeTemplateURI) {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        this.classLoader = this.getClass().getClassLoader();
    }

    public JETEmitter(String templateURI, ClassLoader classLoader) {
        this.templateURI = templateURI;
        this.classLoader = classLoader;
    }

    public JETEmitter(String[] templateURIPath, String relativeTemplateURI, ClassLoader classLoader) {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        this.classLoader = classLoader;
    }

    public JETEmitter(String[] templateURIPath, String relativeTemplateURI, ClassLoader classLoader, String encoding) {
        this.templateURIPath = templateURIPath;
        this.templateURI = relativeTemplateURI;
        this.classLoader = classLoader;
        this.encoding = encoding;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public List getClasspathEntries() {
        return this.classpathEntries;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        if ((method.getModifiers() & 8) == 0 && this.object == null) {
            try {
                this.object = method.getDeclaringClass().newInstance();
            }
            catch (IllegalAccessException exception) {
                exception.printStackTrace();
            }
            catch (InstantiationException exception) {
                exception.printStackTrace();
            }
        }
    }

    public void initialize(IProgressMonitor progressMonitor) throws JETException {
        this.initialize(BasicMonitor.toMonitor(progressMonitor));
    }

    public void initialize(Monitor progressMonitor) throws JETException {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            EclipseHelper.initialize(progressMonitor, this);
        }
    }

    public void addVariable(String variableName, String pluginID) throws JETException {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            EclipseHelper.addVariable(this, variableName, pluginID);
        }
    }

    public String generate(IProgressMonitor progressMonitor, Object[] arguments) throws JETException {
        return this.generate(BasicMonitor.toMonitor(progressMonitor), arguments);
    }

    public String generate(Monitor progressMonitor, Object[] arguments) throws JETException {
        if (this.method == null) {
            this.initialize(progressMonitor);
        }
        String result = "";
        if (this.method != null) {
            try {
                result = (String)this.method.invoke(this.object, arguments);
            }
            catch (IllegalAccessException exception) {
                throw new JETException(exception);
            }
            catch (InvocationTargetException exception) {
                throw new JETException(exception);
            }
        }
        return result;
    }

    protected static class MyBaseJETCompiler
    extends JETCompiler {
        protected ClassLoader classLoader;

        public MyBaseJETCompiler(String templateURI, ClassLoader classLoader) throws JETException {
            super(templateURI);
            this.classLoader = classLoader;
        }

        public MyBaseJETCompiler(String templateURI, String encoding, ClassLoader classLoader) throws JETException {
            super(templateURI, encoding);
            this.classLoader = classLoader;
        }

        public MyBaseJETCompiler(String[] templateURIPath, String relativeTemplateURI, ClassLoader classLoader) throws JETException {
            super(templateURIPath, relativeTemplateURI);
            this.classLoader = classLoader;
        }

        public MyBaseJETCompiler(String[] templateURIPath, String relativeTemplateURI, String encoding, ClassLoader classLoader) throws JETException {
            super(templateURIPath, relativeTemplateURI, encoding);
            this.classLoader = classLoader;
        }

        protected void handleNewSkeleton() {
            String packageName = this.skeleton.getPackageName();
            String skeletonClassName = this.skeleton.getClassName();
            String qualifiedSkeletonClassName = String.valueOf(packageName.length() == 0 ? "" : String.valueOf(packageName) + ".") + skeletonClassName;
            if (this.classLoader != null) {
                try {
                    Class<?> theClass = this.classLoader.loadClass(qualifiedSkeletonClassName);
                    if (theClass != null) {
                        skeletonClassName = String.valueOf(skeletonClassName) + "_";
                        this.skeleton.setClassName(skeletonClassName);
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    protected class MyJETCompiler
    extends MyBaseJETCompiler {
        public MyJETCompiler(String templateURI) throws JETException {
            super(templateURI, JETEmitter.this.classLoader);
        }

        public MyJETCompiler(String templateURI, String encoding) throws JETException {
            super(templateURI, encoding, JETEmitter.this.classLoader);
        }

        public MyJETCompiler(String[] templateURIPath, String relativeTemplateURI) throws JETException {
            super(templateURIPath, relativeTemplateURI, JETEmitter.this.classLoader);
        }

        public MyJETCompiler(String[] templateURIPath, String relativeTemplateURI, String encoding) throws JETException {
            super(templateURIPath, relativeTemplateURI, encoding, JETEmitter.this.classLoader);
        }
    }

    private static class EclipseHelper {
        private EclipseHelper() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static void initialize(Monitor monitor, JETEmitter jetEmitter) throws JETException {
            IProgressMonitor progressMonitor = BasicMonitor.toIProgressMonitor(monitor);
            progressMonitor.beginTask("", 10);
            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_GeneratingJETEmitterFor_message", new Object[]{jetEmitter.templateURI}));
            try {
                try {
                    SubProgressMonitor subProgressMonitor;
                    block23: {
                        URLClassLoader theClassLoader;
                        IFile targetFile;
                        String packageName;
                        IJavaProject javaProject;
                        IProject project;
                        MyBaseJETCompiler jetCompiler;
                        block22: {
                            IFolder runtimeFolder;
                            IProjectDescription description;
                            jetCompiler = jetEmitter.templateURIPath == null ? new MyBaseJETCompiler(jetEmitter.templateURI, jetEmitter.encoding, jetEmitter.classLoader) : new MyBaseJETCompiler(jetEmitter.templateURIPath, jetEmitter.templateURI, jetEmitter.encoding, jetEmitter.classLoader);
                            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETParsing_message", new Object[]{jetCompiler.getResolvedTemplateURI()}));
                            jetCompiler.parse();
                            progressMonitor.worked(1);
                            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                            jetCompiler.generate(outputStream);
                            ByteArrayInputStream contents = new ByteArrayInputStream(outputStream.toByteArray());
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                            if (!javaModel.isOpen()) {
                                javaModel.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            } else {
                                progressMonitor.worked(1);
                            }
                            project = workspace.getRoot().getProject(jetEmitter.getProjectName());
                            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETPreparingProject_message", new Object[]{project.getName()}));
                            if (!project.exists()) {
                                progressMonitor.subTask("JET creating project " + project.getName());
                                project.create((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCreatingProject_message", new Object[]{project.getName()}));
                                description = workspace.newProjectDescription(project.getName());
                                description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
                                description.setLocation(null);
                                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            } else {
                                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
                                description = project.getDescription();
                                description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
                                project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            }
                            javaProject = JavaCore.create((IProject)project);
                            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETInitializingProject_message", new Object[]{project.getName()}));
                            IClasspathEntry classpathEntry = JavaCore.newSourceEntry((IPath)new Path("/" + project.getName() + "/src"));
                            IClasspathEntry jreClasspathEntry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"));
                            ArrayList<IClasspathEntry> classpath = new ArrayList<IClasspathEntry>();
                            classpath.add(classpathEntry);
                            classpath.add(jreClasspathEntry);
                            classpath.addAll(jetEmitter.classpathEntries);
                            IFolder sourceFolder = project.getFolder((IPath)new Path("src"));
                            if (!sourceFolder.exists()) {
                                sourceFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            }
                            if (!(runtimeFolder = project.getFolder((IPath)new Path("runtime"))).exists()) {
                                runtimeFolder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            }
                            IClasspathEntry[] classpathEntryArray = classpath.toArray(new IClasspathEntry[classpath.size()]);
                            javaProject.setRawClasspath(classpathEntryArray, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            javaProject.setOutputLocation((IPath)new Path("/" + project.getName() + "/runtime"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            javaProject.close();
                            progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETOpeningJavaProject_message", new Object[]{project.getName()}));
                            javaProject.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                            IPackageFragmentRoot sourcePackageFragmentRoot = null;
                            int j = 0;
                            while (j < packageFragmentRoots.length) {
                                IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[j];
                                if (packageFragmentRoot.getKind() == 1) {
                                    sourcePackageFragmentRoot = packageFragmentRoot;
                                    break;
                                }
                                ++j;
                            }
                            packageName = jetCompiler.getSkeleton().getPackageName();
                            StringTokenizer stringTokenizer = new StringTokenizer(packageName, ".");
                            subProgressMonitor = new SubProgressMonitor(progressMonitor, 1);
                            subProgressMonitor.beginTask("", stringTokenizer.countTokens() + 4);
                            subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_CreateTargetFile_message"));
                            IContainer sourceContainer = (IContainer)sourcePackageFragmentRoot.getCorrespondingResource();
                            while (true) {
                                if (!stringTokenizer.hasMoreElements()) {
                                    targetFile = sourceContainer.getFile((IPath)new Path(String.valueOf(jetCompiler.getSkeleton().getClassName()) + ".java"));
                                    if (targetFile.exists()) break;
                                    subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCreating_message", new Object[]{targetFile.getFullPath()}));
                                    targetFile.create((InputStream)contents, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                                    break block22;
                                }
                                String folderName = stringTokenizer.nextToken();
                                if ((sourceContainer = sourceContainer.getFolder((IPath)new Path(folderName))).exists()) continue;
                                ((IFolder)sourceContainer).create(false, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                            }
                            subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETUpdating_message", new Object[]{targetFile.getFullPath()}));
                            targetFile.setContents((InputStream)contents, true, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                        }
                        subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETBuilding_message", new Object[]{project.getName()}));
                        project.build(10, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                        IMarker[] markers = targetFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                        boolean errors = false;
                        int i = 0;
                        while (true) {
                            if (i >= markers.length) {
                                if (!errors) {
                                    subProgressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETLoadingClass_message", new Object[]{String.valueOf(jetCompiler.getSkeleton().getClassName()) + ".class"}));
                                    URL url = new File(project.getLocation() + "/" + javaProject.getOutputLocation().removeFirstSegments(1) + "/").toURL();
                                    theClassLoader = new URLClassLoader(new URL[]{url}, jetEmitter.classLoader);
                                }
                                break block23;
                            }
                            IMarker marker = markers[i];
                            if (marker.getAttribute("severity", 0) == 2) {
                                errors = true;
                                subProgressMonitor.subTask(marker.getAttribute("message") + " : " + CodeGenPlugin.getPlugin().getString("jet.mark.file.line", new Object[]{targetFile.getLocation(), marker.getAttribute("lineNumber")}));
                            }
                            ++i;
                        }
                        Class<?> theClass = theClassLoader.loadClass(String.valueOf(packageName.length() == 0 ? "" : String.valueOf(packageName) + ".") + jetCompiler.getSkeleton().getClassName());
                        String methodName = jetCompiler.getSkeleton().getMethodName();
                        Method[] methods = theClass.getDeclaredMethods();
                        int i2 = 0;
                        while (i2 < methods.length) {
                            if (methods[i2].getName().equals(methodName)) {
                                jetEmitter.setMethod(methods[i2]);
                                break;
                            }
                            ++i2;
                        }
                    }
                    subProgressMonitor.done();
                }
                catch (CoreException exception) {
                    throw new JETException(exception);
                }
                catch (Exception exception) {
                    throw new JETException(exception);
                }
            }
            catch (Throwable throwable) {
                Object var31_36 = null;
                progressMonitor.done();
                throw throwable;
            }
            {
                Object var31_37 = null;
            }
            progressMonitor.done();
        }

        public static void addVariable(JETEmitter jetEmitter, String variableName, String pluginID) throws JETException {
            Bundle bundle = Platform.getBundle((String)pluginID);
            URL classpathURL = Platform.inDevelopmentMode() ? bundle.getEntry(".classpath") : null;
            boolean addClasspathEntries = true;
            if (classpathURL != null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setValidating(false);
                try {
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(new InputSource(classpathURL.toString()));
                    Node child = document.getDocumentElement().getFirstChild();
                    while (child != null) {
                        Element classpathEntryElement;
                        if (child.getNodeType() == 1 && "classpathentry".equals((classpathEntryElement = (Element)child).getNodeName()) && "output".equals(classpathEntryElement.getAttribute("kind"))) {
                            IFolder folder;
                            URI uri = URI.createURI(classpathEntryElement.getAttribute("path")).resolve(URI.createURI(classpathURL.toString()));
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IProject project = workspace.getRoot().getProject(jetEmitter.getProjectName());
                            if (!project.exists()) {
                                project.create((IProgressMonitor)new NullProgressMonitor());
                            }
                            if (!project.isOpen()) {
                                project.open((IProgressMonitor)new NullProgressMonitor());
                            }
                            if (!(folder = project.getFolder("." + pluginID)).exists()) {
                                folder.createLink(new Path(CommonPlugin.asLocalURI(uri).toFileString()).removeTrailingSeparator(), 16, (IProgressMonitor)new NullProgressMonitor());
                            }
                            folder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                            IPath path = folder.getFullPath();
                            jetEmitter.getClasspathEntries().add(JavaCore.newLibraryEntry((IPath)path, null, null));
                            addClasspathEntries = false;
                            break;
                        }
                        child = child.getNextSibling();
                    }
                }
                catch (Exception exception) {
                    CodeGenPlugin.INSTANCE.log(exception);
                }
            }
            if (addClasspathEntries) {
                CodeGenUtil.EclipseUtil.addClasspathEntries(jetEmitter.getClasspathEntries(), variableName, pluginID);
            }
        }
    }
}

