/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.jet.JETSkeleton;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;

public class JETCompileTemplateOperation
implements IWorkspaceRunnable {
    protected static final String JET_EXTENSION = "jet";
    protected IProject project;
    protected Collection containers;
    protected List files = new ArrayList();
    protected boolean inBuild;

    public JETCompileTemplateOperation(IProject project, Collection containers) throws CoreException {
        this.project = project;
        this.containers = containers;
        Iterator i = containers.iterator();
        while (i.hasNext()) {
            Object container2 = i.next();
            if (container2 instanceof IContainer) {
                this.consider((IContainer)container2);
                continue;
            }
            this.consider(container2.toString());
        }
    }

    public JETCompileTemplateOperation(IProject project, Collection containers, Collection resources) throws CoreException {
        this.project = project;
        this.containers = containers;
        Iterator i = resources.iterator();
        block0: while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof IFile) {
                IFile file = (IFile)object;
                IContainer container2 = file.getParent();
                while (container2 != null) {
                    if (containers.contains(container2)) {
                        this.consider(file);
                        continue block0;
                    }
                    container2 = container2.getParent();
                }
                continue;
            }
            if (!(object instanceof IContainer)) continue;
            IContainer container3 = (IContainer)object;
            while (container3 != null) {
                if (containers.contains(container3)) {
                    this.consider(container3);
                    continue block0;
                }
                container3 = container3.getParent();
            }
        }
    }

    public boolean shouldCompile() {
        return !this.files.isEmpty();
    }

    protected void consider(String uri) {
        URI baseURI = URI.createURI(uri);
        URI localURI = CommonPlugin.asLocalURI(baseURI);
        if (localURI.isFile() && !localURI.isRelative()) {
            File file = new File(localURI.toFileString());
            if (file.isDirectory() && !uri.endsWith("/")) {
                baseURI = URI.createURI(String.valueOf(uri) + "/");
            }
            this.consider(baseURI, localURI, new File(localURI.toFileString()));
        }
    }

    protected void consider(URI baseURI, URI localURI, File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.consider(baseURI, localURI, files[i]);
                ++i;
            }
        } else if (file.isFile() && file.getName().endsWith(JET_EXTENSION) && file.getName().indexOf(46) != -1) {
            this.files.add(URI.createFileURI(file.getAbsolutePath()).deresolve(localURI).resolve(baseURI));
        }
    }

    protected void consider(IFile file) {
        if (file.getFileExtension() != null && file.getFileExtension().endsWith(JET_EXTENSION)) {
            this.files.add(file);
        }
    }

    protected void consider(IContainer container2) throws CoreException {
        IResource[] children = container2.members();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile) {
                    this.consider((IFile)resource);
                } else if (resource instanceof IContainer) {
                    this.consider((IContainer)resource);
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor progressMonitor) throws CoreException {
        try {
            try {
                progressMonitor.beginTask("", 3 * this.files.size());
                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCompilingTemplates_message"));
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                HashSet<IProject> jetProjects = new HashSet<IProject>();
                HashSet<String> visitedRelativePaths = new HashSet<String>();
                Iterator i = this.files.iterator();
                block9: while (i.hasNext()) {
                    Object container2;
                    Object file = i.next();
                    String fileName = file instanceof IFile ? ((IFile)file).getName() : file.toString();
                    progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCompile_message", new Object[]{fileName}));
                    JETNature nature = JETNature.getRuntime(this.project);
                    IContainer directory = nature.getJavaSourceContainer();
                    Path filePath = file instanceof IFile ? ((IFile)file).getFullPath() : new Path(file.toString());
                    List templateContainers = nature.getTemplateContainers();
                    List templateSourceContainers = nature.getTemplateSourceContainers();
                    String[] containerLocations = new String[templateContainers.size()];
                    Iterator j = templateContainers.listIterator();
                    while (j.hasNext()) {
                        container2 = j.next();
                        containerLocations[j.previousIndex()] = container2 instanceof IContainer ? "platform:/resource" + ((IContainer)container2).getFullPath() : container2.toString();
                    }
                    j = templateSourceContainers.iterator();
                    while (j.hasNext()) {
                        byte[] bytes;
                        String relativePath;
                        Path containerPath;
                        container2 = j.next();
                        Object object = containerPath = container2 instanceof IContainer ? ((IContainer)container2).getFullPath() : new Path(container2.toString());
                        if (!containerPath.isPrefixOf((IPath)filePath) || !visitedRelativePaths.add(relativePath = filePath.removeFirstSegments(containerPath.segmentCount()).setDevice(null).toString())) continue;
                        JETCompiler compiler = new JETCompiler(containerLocations, relativePath);
                        compiler.parse();
                        StringWriter stringWriter = new StringWriter();
                        compiler.generate(stringWriter);
                        JETSkeleton skeleton = compiler.getSkeleton();
                        if (skeleton.getClassName().equals("")) {
                            skeleton.setClassName(fileName.substring(0, fileName.indexOf(46)));
                        }
                        if (skeleton.getPackageName() != null) {
                            directory = this.getPackageContainer(directory, skeleton.getPackageName(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        } else {
                            progressMonitor.worked(1);
                        }
                        IFile outputFile = workspaceRoot.getFile(directory.getFullPath().append(String.valueOf(skeleton.getClassName()) + ".java"));
                        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETUpdate_message", new Object[]{fileName}));
                        String encoding = outputFile.getCharset();
                        String result = stringWriter.getBuffer().toString();
                        try {
                            bytes = encoding == null ? result.getBytes() : result.getBytes(encoding);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            bytes = result.getBytes();
                        }
                        if (!outputFile.exists()) {
                            outputFile.create((InputStream)new ByteArrayInputStream(bytes), true, progressMonitor);
                        } else {
                            boolean changed = true;
                            try {
                                InputStream inputStream = outputFile.getContents();
                                byte[] oldBytes = new byte[inputStream.available()];
                                inputStream.read(oldBytes);
                                inputStream.close();
                                changed = !Arrays.equals(oldBytes, bytes);
                            }
                            catch (IOException iOException) {}
                            if (changed) {
                                outputFile.setContents((InputStream)new ByteArrayInputStream(bytes), true, true, progressMonitor);
                            }
                        }
                        jetProjects.add(outputFile.getProject());
                        progressMonitor.worked(1);
                        continue block9;
                    }
                }
                if (!this.isInBuild()) {
                    Iterator projects = jetProjects.iterator();
                    while (projects.hasNext()) {
                        IProject project = (IProject)projects.next();
                        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETJavaCompileProject_message", new Object[]{project.getFullPath()}));
                        project.build(10, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                }
            }
            catch (JETException exception) {
                throw DiagnosticException.toCoreException(exception);
            }
            Object var28_31 = null;
        }
        catch (Throwable throwable) {
            Object var28_30 = null;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
    }

    protected IContainer getPackageContainer(IContainer root, String packagename, IProgressMonitor monitor) throws CoreException {
        StringTokenizer stringTokenizer = new StringTokenizer(packagename, ".");
        while (stringTokenizer.hasMoreTokens()) {
            IFolder newContainer = root.getFolder((IPath)new Path(stringTokenizer.nextToken()));
            if (!newContainer.exists()) {
                newContainer.create(true, true, monitor);
            }
            root = newContainer;
        }
        return root;
    }

    public boolean isInBuild() {
        return this.inBuild;
    }

    public void setInBuild(boolean build) {
        this.inBuild = build;
    }
}

