/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.DynamicAttributeNS;
import org.apache.tools.ant.DynamicElement;
import org.apache.tools.ant.DynamicElementNS;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.UnsupportedAttributeException;
import org.apache.tools.ant.UnsupportedElementException;
import org.apache.tools.ant.taskdefs.PreSetDef;
import org.apache.tools.ant.types.EnumeratedAttribute;

public final class IntrospectionHelper
implements BuildListener {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    private Hashtable attributeTypes = new Hashtable();
    private Hashtable attributeSetters = new Hashtable();
    private Hashtable nestedTypes = new Hashtable();
    private Hashtable nestedCreators = new Hashtable();
    private List addTypeMethods = new ArrayList();
    private Method addText = null;
    private Class bean;
    private static Hashtable helpers = new Hashtable();
    private static final Hashtable PRIMITIVE_TYPE_MAP = new Hashtable(8);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;
    static /* synthetic */ Class class$org$apache$tools$ant$Location;
    static /* synthetic */ Class class$org$apache$tools$ant$DynamicElement;
    static /* synthetic */ Class class$org$apache$tools$ant$DynamicElementNS;
    static /* synthetic */ Class class$org$apache$tools$ant$TaskContainer;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$apache$tools$ant$types$EnumeratedAttribute;

    private IntrospectionHelper(Class bean) {
        this.bean = bean;
        Method[] methods = bean.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            String name = m.getName();
            Class<?> returnType = m.getReturnType();
            Class<?>[] args = m.getParameterTypes();
            if (args.length == 1 && Void.TYPE.equals(returnType) && ("add".equals(name) || "addConfigured".equals(name))) {
                this.insertAddTypeMethod(m);
            } else if (!((class$org$apache$tools$ant$Task == null ? IntrospectionHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).isAssignableFrom(bean) && args.length == 1 && this.isHiddenSetMethod(name, args[0]) || this.isContainer() && args.length == 1 && "addTask".equals(name) && (class$org$apache$tools$ant$Task == null ? IntrospectionHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).equals(args[0]))) {
                String propName;
                Constructor<?> constructor;
                String propName2;
                if ("addText".equals(name) && Void.TYPE.equals(returnType) && args.length == 1 && (class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0])) {
                    this.addText = methods[i];
                } else if (name.startsWith("set") && Void.TYPE.equals(returnType) && args.length == 1 && !args[0].isArray()) {
                    AttributeSetter as;
                    propName2 = this.getPropertyName(name, "set");
                    if (!(this.attributeSetters.get(propName2) != null && (class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) || (as = this.createAttributeSetter(m, args[0], propName2)) == null)) {
                        this.attributeTypes.put(propName2, args[0]);
                        this.attributeSetters.put(propName2, as);
                    }
                } else if (name.startsWith("create") && !returnType.isArray() && !returnType.isPrimitive() && args.length == 0) {
                    propName2 = this.getPropertyName(name, "create");
                    if (this.nestedCreators.get(propName2) == null) {
                        this.nestedTypes.put(propName2, returnType);
                        this.nestedCreators.put(propName2, new CreateNestedCreator(m));
                    }
                } else if (name.startsWith("addConfigured") && Void.TYPE.equals(returnType) && args.length == 1 && !(class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) && !args[0].isArray() && !args[0].isPrimitive()) {
                    try {
                        constructor = null;
                        try {
                            constructor = args[0].getConstructor(new Class[0]);
                        }
                        catch (NoSuchMethodException ex) {
                            constructor = args[0].getConstructor(class$org$apache$tools$ant$Project == null ? IntrospectionHelper.class$("org.apache.tools.ant.Project") : class$org$apache$tools$ant$Project);
                        }
                        propName = this.getPropertyName(name, "addConfigured");
                        this.nestedTypes.put(propName, args[0]);
                        this.nestedCreators.put(propName, new AddNestedCreator(m, constructor, 2));
                    }
                    catch (NoSuchMethodException nse) {}
                } else if (name.startsWith("add") && Void.TYPE.equals(returnType) && args.length == 1 && !(class$java$lang$String == null ? IntrospectionHelper.class$("java.lang.String") : class$java$lang$String).equals(args[0]) && !args[0].isArray() && !args[0].isPrimitive()) {
                    try {
                        constructor = null;
                        try {
                            constructor = args[0].getConstructor(new Class[0]);
                        }
                        catch (NoSuchMethodException ex) {
                            constructor = args[0].getConstructor(class$org$apache$tools$ant$Project == null ? IntrospectionHelper.class$("org.apache.tools.ant.Project") : class$org$apache$tools$ant$Project);
                        }
                        propName = this.getPropertyName(name, "add");
                        this.nestedTypes.put(propName, args[0]);
                        this.nestedCreators.put(propName, new AddNestedCreator(m, constructor, 1));
                    }
                    catch (NoSuchMethodException nse) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    private boolean isHiddenSetMethod(String name, Class type) {
        if ("setLocation".equals(name) && (class$org$apache$tools$ant$Location == null ? (class$org$apache$tools$ant$Location = IntrospectionHelper.class$("org.apache.tools.ant.Location")) : class$org$apache$tools$ant$Location).equals(type)) {
            return true;
        }
        return "setTaskType".equals(name) && (class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String).equals(type);
    }

    public static synchronized IntrospectionHelper getHelper(Class c) {
        IntrospectionHelper ih = (IntrospectionHelper)helpers.get(c);
        if (ih == null) {
            ih = new IntrospectionHelper(c);
            helpers.put(c, ih);
        }
        return ih;
    }

    public static IntrospectionHelper getHelper(Project p, Class c) {
        IntrospectionHelper ih = IntrospectionHelper.getHelper(c);
        p.addBuildListener(ih);
        return ih;
    }

    public void setAttribute(Project p, Object element, String attributeName, String value) throws BuildException {
        AttributeSetter as = (AttributeSetter)this.attributeSetters.get(attributeName.toLowerCase(Locale.US));
        if (as == null) {
            if (element instanceof DynamicAttributeNS) {
                DynamicAttributeNS dc = (DynamicAttributeNS)element;
                String uriPlusPrefix = ProjectHelper.extractUriFromComponentName(attributeName);
                String uri = ProjectHelper.extractUriFromComponentName(uriPlusPrefix);
                String localName = ProjectHelper.extractNameFromComponentName(attributeName);
                String qName = "".equals(uri) ? localName : uri + ":" + localName;
                dc.setDynamicAttribute(uri, localName, qName, value);
                return;
            }
            if (element instanceof DynamicAttribute) {
                DynamicAttribute dc = (DynamicAttribute)element;
                dc.setDynamicAttribute(attributeName.toLowerCase(Locale.US), value);
                return;
            }
            if (attributeName.indexOf(58) != -1) {
                return;
            }
            String msg = this.getElementName(p, element) + " doesn't support the \"" + attributeName + "\" attribute.";
            throw new UnsupportedAttributeException(msg, attributeName);
        }
        try {
            as.set(p, element, value);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public void addText(Project project, Object element, String text) throws BuildException {
        if (this.addText == null) {
            if (text.trim().length() == 0) {
                return;
            }
            String msg = project.getElementName(element) + " doesn't support nested text data.";
            throw new BuildException(msg);
        }
        try {
            this.addText.invoke(element, text);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public void throwNotSupported(Project project, Object parent, String elementName) {
        String msg = project.getElementName(parent) + " doesn't support the nested \"" + elementName + "\" element.";
        throw new UnsupportedElementException(msg, elementName);
    }

    private NestedCreator getNestedCreator(Project project, String parentUri, Object parent, String elementName, UnknownElement child) throws BuildException {
        Object nestedElement;
        String qName;
        Object dc;
        Object nestedElement2;
        String uri = ProjectHelper.extractUriFromComponentName(elementName);
        String name = ProjectHelper.extractNameFromComponentName(elementName);
        if (uri.equals("antlib:org.apache.tools.ant")) {
            uri = "";
        }
        if (parentUri.equals("antlib:org.apache.tools.ant")) {
            parentUri = "";
        }
        NestedCreator nc = null;
        if (uri.equals(parentUri) || uri.equals("")) {
            nc = (NestedCreator)this.nestedCreators.get(name.toLowerCase(Locale.US));
        }
        if (nc == null) {
            nc = this.createAddTypeCreator(project, parent, elementName);
        }
        if (nc == null && parent instanceof DynamicElementNS && (nestedElement2 = (dc = (DynamicElementNS)parent).createDynamicElement(child == null ? "" : child.getNamespace(), name, qName = child == null ? name : child.getQName())) != null) {
            nc = new NestedCreator(null){

                Object create(Project project, Object parent, Object ignore) {
                    return nestedElement2;
                }
            };
        }
        if (nc == null && parent instanceof DynamicElement && (nestedElement = (dc = (DynamicElement)parent).createDynamicElement(name.toLowerCase(Locale.US))) != null) {
            nc = new NestedCreator(null){

                Object create(Project project, Object parent, Object ignore) {
                    return nestedElement;
                }
            };
        }
        if (nc == null) {
            this.throwNotSupported(project, parent, elementName);
        }
        return nc;
    }

    public Object createElement(Project project, Object parent, String elementName) throws BuildException {
        NestedCreator nc = this.getNestedCreator(project, "", parent, elementName, null);
        try {
            Object nestedElement = nc.create(project, parent, null);
            if (project != null) {
                project.setProjectReference(nestedElement);
            }
            return nestedElement;
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InstantiationException ine) {
            throw new BuildException(ine);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public Creator getElementCreator(Project project, String parentUri, Object parent, String elementName, UnknownElement ue) {
        NestedCreator nc = this.getNestedCreator(project, parentUri, parent, elementName, ue);
        return new Creator(project, parent, nc);
    }

    public boolean isDynamic() {
        return (class$org$apache$tools$ant$DynamicElement == null ? (class$org$apache$tools$ant$DynamicElement = IntrospectionHelper.class$("org.apache.tools.ant.DynamicElement")) : class$org$apache$tools$ant$DynamicElement).isAssignableFrom(this.bean) || (class$org$apache$tools$ant$DynamicElementNS == null ? (class$org$apache$tools$ant$DynamicElementNS = IntrospectionHelper.class$("org.apache.tools.ant.DynamicElementNS")) : class$org$apache$tools$ant$DynamicElementNS).isAssignableFrom(this.bean);
    }

    public boolean isContainer() {
        return (class$org$apache$tools$ant$TaskContainer == null ? (class$org$apache$tools$ant$TaskContainer = IntrospectionHelper.class$("org.apache.tools.ant.TaskContainer")) : class$org$apache$tools$ant$TaskContainer).isAssignableFrom(this.bean);
    }

    public boolean supportsNestedElement(String elementName) {
        return this.nestedCreators.containsKey(elementName.toLowerCase(Locale.US)) || this.isDynamic() || this.addTypeMethods.size() != 0;
    }

    public boolean supportsNestedElement(String parentUri, String elementName) {
        String name;
        String uri;
        if (parentUri.equals("antlib:org.apache.tools.ant")) {
            parentUri = "";
        }
        if ((uri = ProjectHelper.extractUriFromComponentName(elementName)).equals("antlib:org.apache.tools.ant")) {
            uri = "";
        }
        return this.nestedCreators.containsKey((name = ProjectHelper.extractNameFromComponentName(elementName)).toLowerCase(Locale.US)) && (uri.equals(parentUri) || "".equals(uri)) || this.isDynamic() || this.addTypeMethods.size() != 0;
    }

    public void storeElement(Project project, Object parent, Object child, String elementName) throws BuildException {
        if (elementName == null) {
            return;
        }
        NestedCreator ns = (NestedCreator)this.nestedCreators.get(elementName.toLowerCase(Locale.US));
        if (ns == null) {
            return;
        }
        try {
            ns.store(parent, child);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InstantiationException ine) {
            throw new BuildException(ine);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public Class getElementType(String elementName) throws BuildException {
        Class nt = (Class)this.nestedTypes.get(elementName);
        if (nt == null) {
            throw new UnsupportedElementException("Class " + this.bean.getName() + " doesn't support the nested \"" + elementName + "\" element.", elementName);
        }
        return nt;
    }

    public Class getAttributeType(String attributeName) throws BuildException {
        Class at = (Class)this.attributeTypes.get(attributeName);
        if (at == null) {
            throw new UnsupportedAttributeException("Class " + this.bean.getName() + " doesn't support the \"" + attributeName + "\" attribute.", attributeName);
        }
        return at;
    }

    public Method getAddTextMethod() throws BuildException {
        if (!this.supportsCharacters()) {
            throw new BuildException("Class " + this.bean.getName() + " doesn't support nested text data.");
        }
        return this.addText;
    }

    public Method getElementMethod(String elementName) throws BuildException {
        Object creator = this.nestedCreators.get(elementName);
        if (creator == null) {
            throw new UnsupportedElementException("Class " + this.bean.getName() + " doesn't support the nested \"" + elementName + "\" element.", elementName);
        }
        return ((NestedCreator)creator).method;
    }

    public Method getAttributeMethod(String attributeName) throws BuildException {
        Object setter = this.attributeSetters.get(attributeName);
        if (setter == null) {
            throw new UnsupportedAttributeException("Class " + this.bean.getName() + " doesn't support the \"" + attributeName + "\" attribute.", attributeName);
        }
        return ((AttributeSetter)setter).method;
    }

    public boolean supportsCharacters() {
        return this.addText != null;
    }

    public Enumeration getAttributes() {
        return this.attributeSetters.keys();
    }

    public Map getAttributeMap() {
        return this.attributeTypes.size() < 1 ? EMPTY_MAP : Collections.unmodifiableMap(this.attributeTypes);
    }

    public Enumeration getNestedElements() {
        return this.nestedTypes.keys();
    }

    public Map getNestedElementMap() {
        return this.nestedTypes.size() < 1 ? EMPTY_MAP : Collections.unmodifiableMap(this.nestedTypes);
    }

    public List getExtensionPoints() {
        return this.addTypeMethods.size() < 1 ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.addTypeMethods);
    }

    private AttributeSetter createAttributeSetter(final Method m, Class arg, final String attrName) {
        boolean includeProject;
        Constructor c;
        Class reflectedArg;
        if ((class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String).equals(reflectedArg = PRIMITIVE_TYPE_MAP.containsKey(arg) ? (Class)PRIMITIVE_TYPE_MAP.get(arg) : arg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new String[]{value});
                }
            };
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = IntrospectionHelper.class$("java.lang.Character")) : class$java$lang$Character).equals(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    if (value.length() == 0) {
                        throw new BuildException("The value \"\" is not a legal value for attribute \"" + attrName + "\"");
                    }
                    m.invoke(parent, (Object[])new Character[]{new Character(value.charAt(0))});
                }
            };
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntrospectionHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Boolean[]{Project.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE});
                }
            };
        }
        if ((class$java$lang$Class == null ? (class$java$lang$Class = IntrospectionHelper.class$("java.lang.Class")) : class$java$lang$Class).equals(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        m.invoke(parent, Class.forName(value));
                    }
                    catch (ClassNotFoundException ce) {
                        throw new BuildException(ce);
                    }
                }
            };
        }
        if ((class$java$io$File == null ? (class$java$io$File = IntrospectionHelper.class$("java.io.File")) : class$java$io$File).equals(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, p.resolveFile(value));
                }
            };
        }
        if ((class$org$apache$tools$ant$types$EnumeratedAttribute == null ? (class$org$apache$tools$ant$types$EnumeratedAttribute = IntrospectionHelper.class$("org.apache.tools.ant.types.EnumeratedAttribute")) : class$org$apache$tools$ant$types$EnumeratedAttribute).isAssignableFrom(reflectedArg)) {
            return new AttributeSetter(m){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        EnumeratedAttribute ea = (EnumeratedAttribute)reflectedArg.newInstance();
                        ea.setValue(value);
                        m.invoke(parent, ea);
                    }
                    catch (InstantiationException ie) {
                        throw new BuildException(ie);
                    }
                }
            };
        }
        try {
            c = reflectedArg.getConstructor(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = IntrospectionHelper.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project, class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String);
            includeProject = true;
        }
        catch (NoSuchMethodException nme) {
            try {
                c = reflectedArg.getConstructor(class$java$lang$String == null ? (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")) : class$java$lang$String);
                includeProject = false;
            }
            catch (NoSuchMethodException nme2) {
                return null;
            }
        }
        final boolean finalIncludeProject = includeProject;
        final Constructor finalConstructor = c;
        return new AttributeSetter(m){

            public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                try {
                    Object[] objectArray;
                    if (finalIncludeProject) {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = p;
                        objectArray = objectArray2;
                        objectArray2[1] = value;
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = value;
                    }
                    Object[] args = objectArray;
                    Object attribute = finalConstructor.newInstance(args);
                    if (p != null) {
                        p.setProjectReference(attribute);
                    }
                    m.invoke(parent, attribute);
                }
                catch (InstantiationException ie) {
                    throw new BuildException(ie);
                }
            }
        };
    }

    protected String getElementName(Project project, Object element) {
        return project.getElementName(element);
    }

    private String getPropertyName(String methodName, String prefix) {
        return methodName.substring(prefix.length()).toLowerCase(Locale.US);
    }

    public void buildFinished(BuildEvent event2) {
        this.attributeTypes.clear();
        this.attributeSetters.clear();
        this.nestedTypes.clear();
        this.nestedCreators.clear();
        this.addText = null;
        helpers.clear();
    }

    public void buildStarted(BuildEvent event2) {
    }

    public void targetStarted(BuildEvent event2) {
    }

    public void targetFinished(BuildEvent event2) {
    }

    public void taskStarted(BuildEvent event2) {
    }

    public void taskFinished(BuildEvent event2) {
    }

    public void messageLogged(BuildEvent event2) {
    }

    private NestedCreator createAddTypeCreator(Project project, Object parent, String elementName) throws BuildException {
        if (this.addTypeMethods.size() == 0) {
            return null;
        }
        ComponentHelper helper = ComponentHelper.getComponentHelper(project);
        Object addedObject = null;
        Method addMethod = null;
        Class clazz = helper.getComponentClass(elementName);
        if (clazz == null) {
            return null;
        }
        addMethod = this.findMatchingMethod(clazz, this.addTypeMethods);
        if (addMethod == null) {
            return null;
        }
        addedObject = helper.createComponent(elementName);
        if (addedObject == null) {
            return null;
        }
        Object rObject = addedObject;
        if (addedObject instanceof PreSetDef.PreSetDefinition) {
            rObject = ((PreSetDef.PreSetDefinition)addedObject).createObject(project);
        }
        final Object nestedObject = addedObject;
        final Object realObject = rObject;
        return new NestedCreator(addMethod){

            Object create(Project project, Object parent, Object ignore) throws InvocationTargetException, IllegalAccessException {
                if (!this.method.getName().endsWith("Configured")) {
                    this.method.invoke(parent, realObject);
                }
                return nestedObject;
            }

            Object getRealObject() {
                return realObject;
            }

            void store(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                if (this.method.getName().endsWith("Configured")) {
                    this.method.invoke(parent, realObject);
                }
            }
        };
    }

    private void insertAddTypeMethod(Method method) {
        Class<?> argClass = method.getParameterTypes()[0];
        int c = 0;
        while (c < this.addTypeMethods.size()) {
            Method current = (Method)this.addTypeMethods.get(c);
            if (current.getParameterTypes()[0].equals(argClass)) {
                return;
            }
            if (current.getParameterTypes()[0].isAssignableFrom(argClass)) {
                this.addTypeMethods.add(c, method);
                return;
            }
            ++c;
        }
        this.addTypeMethods.add(method);
    }

    private Method findMatchingMethod(Class paramClass, List methods) {
        Class<?> matchedClass = null;
        Method matchedMethod = null;
        int i = 0;
        while (i < methods.size()) {
            Method method = (Method)methods.get(i);
            Class<?> methodClass = method.getParameterTypes()[0];
            if (methodClass.isAssignableFrom(paramClass)) {
                if (matchedClass == null) {
                    matchedClass = methodClass;
                    matchedMethod = method;
                } else if (!methodClass.isAssignableFrom(matchedClass)) {
                    throw new BuildException("ambiguous: types " + matchedClass.getName() + " and " + methodClass.getName() + " match " + paramClass.getName());
                }
            }
            ++i;
        }
        return matchedMethod;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        Class[] wrappers = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntrospectionHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Byte == null ? (class$java$lang$Byte = IntrospectionHelper.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Character == null ? (class$java$lang$Character = IntrospectionHelper.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Short == null ? (class$java$lang$Short = IntrospectionHelper.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = IntrospectionHelper.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = IntrospectionHelper.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = IntrospectionHelper.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = IntrospectionHelper.class$("java.lang.Double")) : class$java$lang$Double};
        int i = 0;
        while (i < primitives.length) {
            PRIMITIVE_TYPE_MAP.put(primitives[i], wrappers[i]);
            ++i;
        }
    }

    private static abstract class AttributeSetter {
        Method method;

        AttributeSetter(Method m) {
            this.method = m;
        }

        abstract void set(Project var1, Object var2, String var3) throws InvocationTargetException, IllegalAccessException, BuildException;
    }

    private class AddNestedCreator
    extends NestedCreator {
        static final int ADD = 1;
        static final int ADD_CONFIGURED = 2;
        protected Constructor constructor;
        protected int behavior;

        AddNestedCreator(Method m, Constructor c, int behavior) {
            super(m);
            this.constructor = c;
            this.behavior = behavior;
        }

        boolean isPolyMorphic() {
            return true;
        }

        Class getElementClass() {
            return this.constructor.getDeclaringClass();
        }

        Object create(Project project, Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            if (child == null) {
                Object[] objectArray;
                if (this.constructor.getParameterTypes().length == 0) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = project;
                }
                child = this.constructor.newInstance(objectArray);
            }
            if (child instanceof PreSetDef.PreSetDefinition) {
                child = ((PreSetDef.PreSetDefinition)child).createObject(project);
            }
            if (this.behavior == 1) {
                this.istore(parent, child);
            }
            return child;
        }

        void store(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            if (this.behavior == 2) {
                this.istore(parent, child);
            }
        }

        private void istore(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            this.method.invoke(parent, child);
        }
    }

    private class CreateNestedCreator
    extends NestedCreator {
        CreateNestedCreator(Method m) {
            super(m);
        }

        Object create(Project project, Object parent, Object ignore) throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(parent, new Object[0]);
        }
    }

    private static abstract class NestedCreator {
        Method method;

        NestedCreator(Method m) {
            this.method = m;
        }

        boolean isPolyMorphic() {
            return false;
        }

        Class getElementClass() {
            return null;
        }

        Object getRealObject() {
            return null;
        }

        abstract Object create(Project var1, Object var2, Object var3) throws InvocationTargetException, IllegalAccessException, InstantiationException;

        void store(Object parent, Object child) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        }
    }

    public static final class Creator {
        private NestedCreator nestedCreator;
        private Object parent;
        private Project project;
        private Object nestedObject;
        private String polyType;

        private Creator(Project project, Object parent, NestedCreator nestedCreator) {
            this.project = project;
            this.parent = parent;
            this.nestedCreator = nestedCreator;
        }

        public void setPolyType(String polyType) {
            this.polyType = polyType;
        }

        public Object create() {
            if (this.polyType != null) {
                if (!this.nestedCreator.isPolyMorphic()) {
                    throw new BuildException("Not allowed to use the polymorphic form for this element");
                }
                Class elementClass = this.nestedCreator.getElementClass();
                ComponentHelper helper = ComponentHelper.getComponentHelper(this.project);
                this.nestedObject = helper.createComponent(this.polyType);
                if (this.nestedObject == null) {
                    throw new BuildException("Unable to create object of type " + this.polyType);
                }
            }
            try {
                this.nestedObject = this.nestedCreator.create(this.project, this.parent, this.nestedObject);
                if (this.project != null) {
                    this.project.setProjectReference(this.nestedObject);
                }
                return this.nestedObject;
            }
            catch (IllegalAccessException ex) {
                throw new BuildException(ex);
            }
            catch (InstantiationException ex) {
                throw new BuildException(ex);
            }
            catch (IllegalArgumentException ex) {
                if (this.polyType != null) {
                    throw new BuildException("Invalid type used " + this.polyType);
                }
                throw ex;
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getTargetException();
                if (t instanceof BuildException) {
                    throw (BuildException)t;
                }
                throw new BuildException(t);
            }
        }

        public Object getRealObject() {
            return this.nestedCreator.getRealObject();
        }

        public void store() {
            try {
                this.nestedCreator.store(this.parent, this.nestedObject);
            }
            catch (IllegalAccessException ex) {
                throw new BuildException(ex);
            }
            catch (InstantiationException ex) {
                throw new BuildException(ex);
            }
            catch (IllegalArgumentException ex) {
                if (this.polyType != null) {
                    throw new BuildException("Invalid type used " + this.polyType);
                }
                throw ex;
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getTargetException();
                if (t instanceof BuildException) {
                    throw (BuildException)t;
                }
                throw new BuildException(t);
            }
        }
    }
}

