/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.IndexedValueExpression;
import javax.servlet.jsp.jstl.core.IteratedExpression;
import javax.servlet.jsp.jstl.core.IteratedValueExpression;
import javax.servlet.jsp.jstl.core.LoopTagSupport;
import org.apache.taglibs.standard.resources.Resources;

public abstract class ForEachSupport
extends LoopTagSupport {
    protected ForEachIterator items;
    protected Object rawItems;

    protected boolean hasNext() throws JspTagException {
        return this.items.hasNext();
    }

    protected Object next() throws JspTagException {
        return this.items.next();
    }

    protected void prepare() throws JspTagException {
        if (this.rawItems != null) {
            if (this.rawItems instanceof ValueExpression) {
                this.deferredExpression = (ValueExpression)this.rawItems;
                ELContext myELContext = this.pageContext.getELContext();
                VariableMapper vm = myELContext.getVariableMapper();
                this.items = this.toDeferredForEachIterator(this.deferredExpression);
            } else {
                this.items = this.supportedTypeForEachIterator(this.rawItems);
            }
        } else {
            this.items = this.beginEndForEachIterator();
        }
    }

    public void release() {
        super.release();
        this.items = null;
        this.rawItems = null;
    }

    protected ForEachIterator supportedTypeForEachIterator(Object o) throws JspTagException {
        ForEachIterator items = o instanceof Object[] ? this.toForEachIterator((Object[])o) : (o instanceof boolean[] ? this.toForEachIterator((boolean[])o) : (o instanceof byte[] ? this.toForEachIterator((byte[])o) : (o instanceof char[] ? this.toForEachIterator((char[])o) : (o instanceof short[] ? this.toForEachIterator((short[])o) : (o instanceof int[] ? this.toForEachIterator((int[])o) : (o instanceof long[] ? this.toForEachIterator((long[])o) : (o instanceof float[] ? this.toForEachIterator((float[])o) : (o instanceof double[] ? this.toForEachIterator((double[])o) : (o instanceof Collection ? this.toForEachIterator((Collection)o) : (o instanceof Iterator ? this.toForEachIterator((Iterator)o) : (o instanceof Enumeration ? this.toForEachIterator((Enumeration)o) : (o instanceof Map ? this.toForEachIterator((Map)o) : (o instanceof String ? this.toForEachIterator((String)o) : this.toForEachIterator(o))))))))))))));
        return items;
    }

    private ForEachIterator beginEndForEachIterator() {
        Integer[] ia = new Integer[this.end + 1];
        for (int i = 0; i <= this.end; ++i) {
            ia[i] = new Integer(i);
        }
        return new SimpleForEachIterator(Arrays.asList(ia).iterator());
    }

    protected ForEachIterator toDeferredForEachIterator(ValueExpression o) throws JspTagException {
        return new DeferredForEachIterator(o);
    }

    protected ForEachIterator toForEachIterator(Object o) throws JspTagException {
        throw new JspTagException(Resources.getMessage("FOREACH_BAD_ITEMS"));
    }

    protected ForEachIterator toForEachIterator(Object[] a) {
        return new SimpleForEachIterator(Arrays.asList(a).iterator());
    }

    protected ForEachIterator toForEachIterator(boolean[] a) {
        Boolean[] wrapped = new Boolean[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = new Boolean(a[i]);
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(byte[] a) {
        Byte[] wrapped = new Byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = new Byte(a[i]);
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(char[] a) {
        Character[] wrapped = new Character[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = new Character(a[i]);
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(short[] a) {
        Short[] wrapped = new Short[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = new Short(a[i]);
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(int[] a) {
        Integer[] wrapped = new Integer[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = new Integer(a[i]);
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(long[] a) {
        Long[] wrapped = new Long[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = new Long(a[i]);
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(float[] a) {
        Float[] wrapped = new Float[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = new Float(a[i]);
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(double[] a) {
        Double[] wrapped = new Double[a.length];
        for (int i = 0; i < a.length; ++i) {
            wrapped[i] = new Double(a[i]);
        }
        return new SimpleForEachIterator(Arrays.asList(wrapped).iterator());
    }

    protected ForEachIterator toForEachIterator(Collection c) {
        return new SimpleForEachIterator(c.iterator());
    }

    protected ForEachIterator toForEachIterator(Iterator i) {
        return new SimpleForEachIterator(i);
    }

    protected ForEachIterator toForEachIterator(Enumeration e) {
        class EnumerationAdapter
        implements ForEachIterator {
            private Enumeration e;

            public EnumerationAdapter(Enumeration e) {
                this.e = e;
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public Object next() {
                return this.e.nextElement();
            }
        }
        return new EnumerationAdapter(e);
    }

    protected ForEachIterator toForEachIterator(Map m) {
        return new SimpleForEachIterator(m.entrySet().iterator());
    }

    protected ForEachIterator toForEachIterator(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        return this.toForEachIterator(st);
    }

    protected class DeferredForEachIterator
    implements ForEachIterator {
        private ValueExpression itemsValueExpression;
        private IteratedExpression itemsValueIteratedExpression;
        private int length = -1;
        private int currentIndex = 0;
        private boolean isIndexedValueExpression = false;
        private boolean anIterator = false;
        private Iterator myIterator;
        private boolean anEnumeration = false;
        private Enumeration myEnumeration;

        public DeferredForEachIterator(ValueExpression o) throws JspTagException {
            this.itemsValueExpression = o;
            this.determineLengthAndType();
        }

        public boolean hasNext() throws JspTagException {
            if (this.isIndexedValueExpression) {
                return this.currentIndex < this.length;
            }
            if (this.length != -1) {
                return this.currentIndex < this.length;
            }
            if (this.anIterator) {
                return this.myIterator.hasNext();
            }
            if (this.anEnumeration) {
                return this.myEnumeration.hasMoreElements();
            }
            return false;
        }

        public Object next() throws JspTagException {
            ValueExpression nextValue = null;
            if (this.isIndexedValueExpression) {
                nextValue = new IndexedValueExpression(this.itemsValueExpression, this.currentIndex);
                ++this.currentIndex;
            } else {
                if (this.itemsValueIteratedExpression == null) {
                    this.itemsValueIteratedExpression = new IteratedExpression(this.itemsValueExpression, ForEachSupport.this.getDelims());
                }
                nextValue = new IteratedValueExpression(this.itemsValueIteratedExpression, this.currentIndex);
                ++this.currentIndex;
                if (this.length == -1) {
                    if (this.anIterator) {
                        this.myIterator.next();
                    } else if (this.anEnumeration) {
                        this.myEnumeration.nextElement();
                    }
                }
            }
            return nextValue;
        }

        private void determineLengthAndType() throws JspTagException {
            ELContext myELContext = ForEachSupport.this.pageContext.getELContext();
            Object o = this.itemsValueExpression.getValue(myELContext);
            if (o instanceof Object[]) {
                this.length = ((Object[])o).length;
                this.isIndexedValueExpression = true;
            } else if (o instanceof boolean[]) {
                this.length = ((boolean[])o).length;
                this.isIndexedValueExpression = true;
            } else if (o instanceof byte[]) {
                this.length = ((byte[])o).length;
                this.isIndexedValueExpression = true;
            } else if (o instanceof char[]) {
                this.length = ((char[])o).length;
                this.isIndexedValueExpression = true;
            } else if (o instanceof short[]) {
                this.length = ((short[])o).length;
                this.isIndexedValueExpression = true;
            } else if (o instanceof int[]) {
                this.length = ((int[])o).length;
                this.isIndexedValueExpression = true;
            } else if (o instanceof long[]) {
                this.length = ((long[])o).length;
                this.isIndexedValueExpression = true;
            } else if (o instanceof float[]) {
                this.length = ((float[])o).length;
                this.isIndexedValueExpression = true;
            } else if (o instanceof double[]) {
                this.length = ((double[])o).length;
                this.isIndexedValueExpression = true;
            } else if (o instanceof Collection) {
                this.length = ((Collection)o).size();
                this.isIndexedValueExpression = false;
            } else if (o instanceof Iterator) {
                this.isIndexedValueExpression = false;
                this.anIterator = true;
                this.myIterator = (Iterator)o;
            } else if (o instanceof Enumeration) {
                this.isIndexedValueExpression = false;
                this.anEnumeration = true;
                this.myEnumeration = (Enumeration)o;
            } else if (o instanceof Map) {
                this.length = ((Map)o).size();
                this.isIndexedValueExpression = false;
            } else if (o instanceof String) {
                StringTokenizer st = new StringTokenizer((String)o, ",");
                this.length = st.countTokens();
                this.isIndexedValueExpression = false;
            } else {
                this.length = 0;
            }
        }
    }

    protected class SimpleForEachIterator
    implements ForEachIterator {
        private Iterator i;

        public SimpleForEachIterator(Iterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return this.i.next();
        }
    }

    protected static interface ForEachIterator {
        public boolean hasNext() throws JspTagException;

        public Object next() throws JspTagException;
    }
}

