/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.util.Enumeration;
import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.util.ContainerUtils;
import org.apache.myfaces.webapp.AbstractMyFacesListener;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.Jsp20FacesInitializer;
import org.apache.myfaces.webapp.Jsp21FacesInitializer;

public class StartupServletContextListener
extends AbstractMyFacesListener
implements ServletContextListener {
    static final String FACES_INIT_DONE = StartupServletContextListener.class.getName() + ".FACES_INIT_DONE";
    private static final Log log = LogFactory.getLog(StartupServletContextListener.class);
    private FacesInitializer _facesInitializer;
    private ServletContext _servletContext;

    public boolean WASConfig() {
        return true;
    }

    public void contextInitialized(ServletContextEvent event2) {
        if (this._servletContext != null) {
            throw new IllegalStateException("context is already initialized");
        }
        this._servletContext = event2.getServletContext();
        Boolean b = (Boolean)this._servletContext.getAttribute(FACES_INIT_DONE);
        if (b == null || !b.booleanValue()) {
            this.getFacesInitializer().initFaces(this._servletContext);
            this._servletContext.setAttribute(FACES_INIT_DONE, Boolean.TRUE);
        } else {
            log.info((Object)"MyFaces already initialized");
        }
    }

    protected FacesInitializer getFacesInitializer() {
        if (this._facesInitializer == null) {
            this._facesInitializer = ContainerUtils.isJsp21() ? new Jsp21FacesInitializer() : new Jsp20FacesInitializer();
        }
        return this._facesInitializer;
    }

    public void setFacesInitializer(FacesInitializer facesInitializer) {
        if (this._facesInitializer != null && this._facesInitializer != facesInitializer && this._servletContext != null) {
            this._facesInitializer.destroyFaces(this._servletContext);
        }
        this._facesInitializer = facesInitializer;
        if (this._servletContext != null) {
            facesInitializer.initFaces(this._servletContext);
        }
    }

    public void contextDestroyed(ServletContextEvent event2) {
        this.doPredestroy(event2);
        if (this._facesInitializer != null && this._servletContext != null) {
            this._facesInitializer.destroyFaces(this._servletContext);
        }
        FactoryFinder.releaseFactories();
        this._servletContext = null;
    }

    private void doPredestroy(ServletContextEvent event2) {
        ServletContext ctx = event2.getServletContext();
        Enumeration attributes = ctx.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String name = (String)attributes.nextElement();
            Object value = ctx.getAttribute(name);
            this.doPreDestroy(value, name, "application");
        }
    }
}

