/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.webapp.AbstractFacesInitializer;

public class Jsp20FacesInitializer
extends AbstractFacesInitializer {
    private static final Log log = LogFactory.getLog(Jsp20FacesInitializer.class);
    private static final String EXPRESSION_FACTORY = "org.apache.myfaces.EXPRESSION_FACTORY";
    private static final String EL_RI_EXPRESSION_FACTORY_IMPL = "com.sun.el.ExpressionFactoryImpl";
    private static final String JASPER_EL_EXPRESSION_FACTORY_IMPL = "org.apache.el.ExpressionFactoryImpl";
    private static final String[] KNOWN_EXPRESSION_FACTORIES = new String[]{"com.sun.el.ExpressionFactoryImpl", "org.apache.el.ExpressionFactoryImpl"};

    protected void initContainerIntegration(ServletContext servletContext, ExternalContext externalContext) {
        if (log.isInfoEnabled()) {
            log.info((Object)"This application isn't running in a JSP 2.1 container.");
        }
        ExpressionFactory expressionFactory = null;
        String expressionFactoryClassName = externalContext.getInitParameter(EXPRESSION_FACTORY);
        if (expressionFactoryClassName != null && expressionFactoryClassName.trim().length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to load the ExpressionFactory implementation you've specified: '" + expressionFactoryClassName + "'."));
            }
            expressionFactory = Jsp20FacesInitializer.loadExpressionFactory(expressionFactoryClassName);
        }
        if (expressionFactory == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Either you haven't specified the ExpressionFactory implementation, or an error occured while instantiating the implementation you've specified. However, attempting to load a known implementation.");
            }
            if ((expressionFactory = Jsp20FacesInitializer.findExpressionFactory(KNOWN_EXPRESSION_FACTORIES)) == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"No valid ExpressionFactory implementation is available but that's required as this application isn't running in a JSP 2.1 container.");
                }
                expressionFactory = new ErrorExpressionFactory();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The following ExpressionFactory implementation will be used: '" + expressionFactory + "'."));
        }
        this.buildConfiguration(servletContext, externalContext, expressionFactory);
    }

    private static ExpressionFactory loadExpressionFactory(String expressionFactoryClassName) {
        try {
            Class<?> expressionFactoryClass = Class.forName(expressionFactoryClassName);
            return (ExpressionFactory)expressionFactoryClass.newInstance();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("An error occured while instantiating a new ExpressionFactory. Attempted to load class '" + expressionFactoryClassName + "'."), (Throwable)ex);
            }
            return null;
        }
    }

    private static ExpressionFactory findExpressionFactory(String[] expressionFactoryClassNames) {
        for (String expressionFactoryClassName : expressionFactoryClassNames) {
            ExpressionFactory expressionFactory = Jsp20FacesInitializer.loadExpressionFactory(expressionFactoryClassName);
            if (expressionFactory == null) continue;
            return expressionFactory;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ErrorExpressionFactory
    extends ExpressionFactory {
        private ErrorExpressionFactory() {
        }

        @Override
        public Object coerceToType(Object obj, Class<?> targetType) {
            throw new FacesException("No valid ExpressionFactory implementation is available but that's required as this application isn't running in a JSP 2.1 container.");
        }

        @Override
        public MethodExpression createMethodExpression(ELContext context, String expression, Class<?> expectedReturnType, Class<?>[] expectedParamTypes) {
            throw new FacesException("No valid ExpressionFactory implementation is available but that's required as this application isn't running in a JSP 2.1 container.");
        }

        @Override
        public ValueExpression createValueExpression(Object instance, Class<?> expectedType) {
            throw new FacesException("No valid ExpressionFactory implementation is available but that's required as this application isn't running in a JSP 2.1 container.");
        }

        @Override
        public ValueExpression createValueExpression(ELContext context, String expression, Class<?> expectedType) {
            throw new FacesException("No valid ExpressionFactory implementation is available but that's required as this application isn't running in a JSP 2.1 container.");
        }
    }
}

