/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.component.EscapeCapable;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;

public class HtmlTextRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlTextRendererBase.class);
    private static final String AUTOCOMPLETE_VALUE_OFF = "off";

    public void encodeEnd(FacesContext facesContext, UIComponent component2) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component2, null);
        if (component2 instanceof UIInput) {
            this.renderInput(facesContext, component2);
        } else if (component2 instanceof UIOutput) {
            HtmlTextRendererBase.renderOutput(facesContext, component2);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component2.getClass().getName());
        }
    }

    protected static void renderOutput(FacesContext facesContext, UIComponent component2) throws IOException {
        String text = RendererUtils.getStringValue(facesContext, component2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("renderOutput '" + text + "'"));
        }
        boolean escape = component2 instanceof HtmlOutputText || component2 instanceof EscapeCapable ? ((HtmlOutputText)component2).isEscape() : RendererUtils.getBooleanAttribute(component2, "escape", true);
        HtmlTextRendererBase.renderOutputText(facesContext, component2, text, escape);
    }

    public static void renderOutputText(FacesContext facesContext, UIComponent component2, String text, boolean escape) throws IOException {
        if (text != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            boolean span = false;
            if (component2.getId() != null && !component2.getId().startsWith("j_id")) {
                span = true;
                writer.startElement("span", component2);
                HtmlRendererUtils.writeIdIfNecessary(writer, component2, facesContext);
                HtmlRendererUtils.renderHTMLAttributes(writer, component2, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component2, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
            if (escape) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("renderOutputText writing '" + text + "'"));
                }
                writer.writeText(text, "value");
            } else {
                writer.write(text);
            }
            if (span) {
                writer.endElement("span");
            }
        }
    }

    protected void renderInput(FacesContext facesContext, UIComponent component2) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component2.getClientId(facesContext);
        String value = RendererUtils.getStringValue(facesContext, component2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("renderInput '" + value + "'"));
        }
        writer.startElement("input", component2);
        writer.writeAttribute("id", clientId, null);
        writer.writeAttribute("name", clientId, null);
        writer.writeAttribute("type", "text", null);
        if (value != null) {
            writer.writeAttribute("value", value, "value");
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, component2, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (this.isDisabled(facesContext, component2)) {
            writer.writeAttribute("disabled", Boolean.TRUE, null);
        }
        if (this.isAutocompleteOff(facesContext, component2)) {
            writer.writeAttribute("autocomplete", AUTOCOMPLETE_VALUE_OFF, "autocomplete");
        }
        writer.endElement("input");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent component2) {
        if (component2 instanceof HtmlInputText) {
            return ((HtmlInputText)component2).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(component2, "disabled", false);
    }

    protected boolean isAutocompleteOff(FacesContext facesContext, UIComponent component2) {
        String autocomplete;
        if (component2 instanceof HtmlInputText && (autocomplete = ((HtmlInputText)component2).getAutocomplete()) != null) {
            return autocomplete.equals(AUTOCOMPLETE_VALUE_OFF);
        }
        return false;
    }

    public void decode(FacesContext facesContext, UIComponent component2) {
        RendererUtils.checkParamValidity(facesContext, component2, null);
        if (component2 instanceof UIInput) {
            HtmlRendererUtils.decodeUIInput(facesContext, component2);
        } else if (!(component2 instanceof UIOutput)) {
            throw new IllegalArgumentException("Unsupported component class " + component2.getClass().getName());
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component2, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, component2, UIOutput.class);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)component2, submittedValue);
    }
}

