/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.html.HtmlColumn;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.util.ArrayUtils;
import org.apache.myfaces.shared_impl.util.StringUtils;

public class HtmlTableRendererBase
extends HtmlRenderer {
    protected static final String HEADER_FACET_NAME = "header";
    protected static final String FOOTER_FACET_NAME = "footer";
    protected static final String CAPTION_FACET_NAME = "caption";
    private static final Log log = LogFactory.getLog(HtmlTableRendererBase.class);

    protected int getNewspaperColumns(UIComponent component2) {
        return 1;
    }

    protected UIComponent getNewspaperTableSpacer(UIComponent component2) {
        return null;
    }

    protected boolean hasNewspaperTableSpacer(UIComponent component2) {
        return false;
    }

    protected boolean isNewspaperHorizontalOrientation(UIComponent component2) {
        return false;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIData.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        this.beforeTable(facesContext, (UIData)uiComponent);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("table", uiComponent);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component2) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component2, UIData.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        this.beforeBody(facesContext, (UIData)component2);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        this.renderCaptionFacet(facesContext, writer, component2);
        writer.startElement("tbody", component2);
        writer.writeAttribute("id", component2.getClientId(facesContext) + ":tbody_element", null);
        this.encodeInnerHtml(facesContext, component2);
        writer.endElement("tbody");
        this.afterBody(facesContext, (UIData)component2);
    }

    protected void renderCaptionFacet(FacesContext facesContext, ResponseWriter writer, UIComponent component2) throws IOException {
        UIComponent facet = component2.getFacets().get(CAPTION_FACET_NAME);
        if (facet != null) {
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement(CAPTION_FACET_NAME, component2);
            RendererUtils.renderChild(facesContext, facet);
            writer.endElement(CAPTION_FACET_NAME);
        }
    }

    protected static Styles getStyles(UIData uiData) {
        String columnClasses;
        String rowClasses;
        if (uiData instanceof HtmlDataTable) {
            rowClasses = ((HtmlDataTable)uiData).getRowClasses();
            columnClasses = ((HtmlDataTable)uiData).getColumnClasses();
        } else {
            rowClasses = (String)uiData.getAttributes().get("rowClasses");
            columnClasses = (String)uiData.getAttributes().get("columnClasses");
        }
        return new Styles(rowClasses, columnClasses);
    }

    public void encodeInnerHtml(FacesContext facesContext, UIComponent component2) throws IOException {
        int last;
        UIData uiData = (UIData)component2;
        ResponseWriter writer = facesContext.getResponseWriter();
        int rowCount = uiData.getRowCount();
        if (rowCount == 0) {
            writer.startElement("tr", uiData);
            writer.startElement("td", uiData);
            writer.endElement("td");
            writer.endElement("tr");
            return;
        }
        Styles styles = HtmlTableRendererBase.getStyles(uiData);
        int first = uiData.getFirst();
        int rows = uiData.getRows();
        if (rows <= 0) {
            last = rowCount;
        } else {
            last = first + rows;
            if (last > rowCount) {
                last = rowCount;
            }
        }
        int newspaperColumns = this.getNewspaperColumns(component2);
        int newspaperRows = (last - first) % newspaperColumns == 0 ? (last - first) / newspaperColumns : (last - first) / newspaperColumns + 1;
        boolean newspaperHorizontalOrientation = this.isNewspaperHorizontalOrientation(component2);
        for (int nr = 0; nr < newspaperRows; ++nr) {
            this.beforeRow(facesContext, uiData);
            for (int nc = 0; nc < newspaperColumns; ++nc) {
                int currentRow = newspaperHorizontalOrientation ? nr * newspaperColumns + nc + first : nc * newspaperRows + nr + first;
                if (currentRow >= last) continue;
                uiData.setRowIndex(currentRow);
                if (!uiData.isRowAvailable()) {
                    log.error((Object)("Row is not available. Rowindex = " + currentRow));
                    break;
                }
                if (nc == 0) {
                    this.beforeRow(facesContext, uiData);
                    HtmlRendererUtils.writePrettyLineSeparator(facesContext);
                    this.renderRowStart(facesContext, writer, uiData, styles, nr);
                }
                List children = this.getChildren(component2);
                int size = this.getChildCount(component2);
                for (int j = 0; j < size; ++j) {
                    UIComponent child = (UIComponent)children.get(j);
                    if (!child.isRendered()) continue;
                    boolean columnRendering = child instanceof UIColumn;
                    if (columnRendering) {
                        this.beforeColumn(facesContext, uiData, j);
                    }
                    this.encodeColumnChild(facesContext, writer, uiData, child, styles, nc * uiData.getChildCount() + j);
                    if (!columnRendering) continue;
                    this.afterColumn(facesContext, uiData, j);
                }
                if (!this.hasNewspaperTableSpacer(uiData) || nc >= newspaperColumns - 1) continue;
                this.renderSpacerCell(facesContext, writer, uiData);
            }
            this.renderRowEnd(facesContext, writer, uiData);
            this.afterRow(facesContext, uiData);
        }
    }

    protected void encodeColumnChild(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component2, Styles styles, int columnStyleIndex) throws IOException {
        if (component2 instanceof UIColumn) {
            this.renderColumnBody(facesContext, writer, uiData, component2, styles, columnStyleIndex);
        }
    }

    protected void renderColumnBody(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component2, Styles styles, int columnStyleIndex) throws IOException {
        writer.startElement("td", uiData);
        if (styles.hasColumnStyle()) {
            writer.writeAttribute("class", styles.getColumnStyle(columnStyleIndex), null);
        }
        RendererUtils.renderChild(facesContext, component2);
        writer.endElement("td");
    }

    protected void renderRowStart(FacesContext facesContext, ResponseWriter writer, UIData uiData, Styles styles, int rowStyleIndex) throws IOException {
        writer.startElement("tr", uiData);
        this.renderRowStyle(facesContext, writer, uiData, styles, rowStyleIndex);
        Object rowId = uiData.getAttributes().get("org.apache.myfaces.dataTable.ROW_ID");
        if (rowId != null) {
            writer.writeAttribute("id", rowId.toString(), null);
        }
    }

    protected void renderRowStyle(FacesContext facesContext, ResponseWriter writer, UIData uiData, Styles styles, int rowStyleIndex) throws IOException {
        if (styles.hasRowStyle()) {
            String rowStyle = styles.getRowStyle(rowStyleIndex);
            writer.writeAttribute("class", rowStyle, null);
        }
    }

    protected void renderRowEnd(FacesContext facesContext, ResponseWriter writer, UIData uiData) throws IOException {
        writer.endElement("tr");
    }

    protected void beforeTable(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void beforeBody(FacesContext facesContext, UIData uiData) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlRendererUtils.renderTableCaption(facesContext, writer, uiData);
        this.renderFacet(facesContext, writer, uiData, true);
        this.renderFacet(facesContext, writer, uiData, false);
    }

    protected void beforeRow(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterRow(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void beforeColumn(FacesContext facesContext, UIData uiData, int columnIndex) throws IOException {
    }

    protected void afterColumn(FacesContext facesContext, UIData uiData, int columnIndex) throws IOException {
    }

    protected void beforeColumnHeaderOrFooter(FacesContext facesContext, UIData uiData, boolean header, int columnIndex) throws IOException {
    }

    protected void afterColumnHeaderOrFooter(FacesContext facesContext, UIData uiData, boolean header, int columnIndex) throws IOException {
    }

    protected void inBodyStart(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterBody(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterTable(FacesContext facesContext, UIData uiData) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIData.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("table");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        this.afterTable(facesContext, (UIData)uiComponent);
    }

    protected void renderFacet(FacesContext facesContext, ResponseWriter writer, UIComponent component2, boolean header) throws IOException {
        UIComponent facet;
        int colspan = 0;
        boolean hasColumnFacet = false;
        for (UIComponent uiComponent : this.getChildren(component2)) {
            if (!uiComponent.isRendered()) continue;
            colspan += this.determineChildColSpan(uiComponent);
            if (hasColumnFacet) continue;
            hasColumnFacet = this.hasFacet(header, uiComponent);
        }
        UIComponent uIComponent = facet = header ? component2.getFacets().get(HEADER_FACET_NAME) : component2.getFacets().get(FOOTER_FACET_NAME);
        if (facet != null || hasColumnFacet) {
            String elemName = header ? "thead" : "tfoot";
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement(elemName, component2);
            if (header) {
                String headerStyleClass = HtmlTableRendererBase.getHeaderClass(component2);
                if (facet != null) {
                    this.renderTableHeaderRow(facesContext, writer, component2, facet, headerStyleClass, colspan);
                }
                if (hasColumnFacet) {
                    this.renderColumnHeaderRow(facesContext, writer, component2, headerStyleClass);
                }
            } else {
                String footerStyleClass = HtmlTableRendererBase.getFooterClass(component2);
                if (hasColumnFacet) {
                    this.renderColumnFooterRow(facesContext, writer, component2, footerStyleClass);
                }
                if (facet != null) {
                    this.renderTableFooterRow(facesContext, writer, component2, facet, footerStyleClass, colspan);
                }
            }
            writer.endElement(elemName);
        }
    }

    protected boolean hasFacet(boolean header, UIComponent uiComponent) {
        if (uiComponent instanceof UIColumn) {
            UIColumn uiColumn = (UIColumn)uiComponent;
            return header ? uiColumn.getHeader() != null : uiColumn.getFooter() != null;
        }
        return false;
    }

    protected int determineChildColSpan(UIComponent uiComponent) {
        if (uiComponent instanceof UIColumn) {
            return 1;
        }
        return 0;
    }

    protected void renderTableHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component2, UIComponent headerFacet, String headerStyleClass, int colspan) throws IOException {
        this.renderTableHeaderOrFooterRow(facesContext, writer, component2, headerFacet, headerStyleClass, "th", colspan, true);
    }

    protected void renderTableFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component2, UIComponent footerFacet, String footerStyleClass, int colspan) throws IOException {
        this.renderTableHeaderOrFooterRow(facesContext, writer, component2, footerFacet, footerStyleClass, "td", colspan, false);
    }

    protected void renderColumnHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component2, String headerStyleClass) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component2, headerStyleClass, true);
    }

    protected void renderColumnFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component2, String footerStyleClass) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component2, footerStyleClass, false);
    }

    private void renderTableHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component2, UIComponent facet, String styleClass, String colElementName, int colspan, boolean isHeader) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", component2);
        writer.startElement(colElementName, component2);
        if (colElementName.equals("th") && isHeader) {
            writer.writeAttribute("scope", "colgroup", null);
        }
        int newsPaperColumns = this.getNewspaperColumns(component2);
        int totalColumns = colspan * newsPaperColumns;
        if (this.hasNewspaperTableSpacer(component2)) {
            totalColumns = totalColumns + newsPaperColumns - 1;
        }
        writer.writeAttribute("colspan", new Integer(totalColumns), null);
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, null);
        }
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement(colElementName);
        writer.endElement("tr");
    }

    private void renderColumnHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component2, String styleClass, boolean header) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", component2);
        int columnIndex = 0;
        int newspaperColumns = this.getNewspaperColumns(component2);
        for (int nc = 0; nc < newspaperColumns; ++nc) {
            for (UIComponent uiComponent : this.getChildren(component2)) {
                if (uiComponent.isRendered()) {
                    if (component2 instanceof UIData && uiComponent instanceof UIColumn) {
                        this.beforeColumnHeaderOrFooter(facesContext, (UIData)component2, header, columnIndex);
                    }
                    this.renderColumnChildHeaderOrFooterRow(facesContext, writer, uiComponent, styleClass, header);
                    if (component2 instanceof UIData && uiComponent instanceof UIColumn) {
                        this.afterColumnHeaderOrFooter(facesContext, (UIData)component2, header, columnIndex);
                    }
                }
                ++columnIndex;
            }
            if (!this.hasNewspaperTableSpacer(component2) || nc >= newspaperColumns - 1) continue;
            this.renderSpacerCell(facesContext, writer, component2);
        }
        writer.endElement("tr");
    }

    protected void renderSpacerCell(FacesContext facesContext, ResponseWriter writer, UIComponent component2) throws IOException {
        UIComponent spacer = this.getNewspaperTableSpacer(component2);
        if (spacer == null) {
            return;
        }
        writer.startElement("td", component2);
        RendererUtils.renderChild(facesContext, spacer);
        writer.endElement("td");
    }

    protected void renderColumnChildHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String styleClass, boolean isHeader) throws IOException {
        if (uiComponent instanceof UIColumn) {
            if (uiComponent instanceof HtmlColumn) {
                HtmlColumn column = (HtmlColumn)uiComponent;
                if (isHeader && column.getHeaderClass() != null) {
                    styleClass = column.getHeaderClass();
                } else if (!isHeader && column.getFooterClass() != null) {
                    styleClass = column.getFooterClass();
                }
            } else {
                UIColumn column = (UIColumn)uiComponent;
                if (isHeader) {
                    String headerClass = (String)column.getAttributes().get("headerClass");
                    if (headerClass != null) {
                        styleClass = headerClass;
                    }
                } else {
                    String footerClass = (String)column.getAttributes().get("footerClass");
                    if (footerClass != null) {
                        styleClass = footerClass;
                    }
                }
            }
            if (isHeader) {
                this.renderColumnHeaderCell(facesContext, writer, uiComponent, ((UIColumn)uiComponent).getHeader(), styleClass, 0);
            } else {
                this.renderColumnFooterCell(facesContext, writer, uiComponent, ((UIColumn)uiComponent).getFooter(), styleClass, 0);
            }
        }
    }

    protected void renderColumnHeaderCell(FacesContext facesContext, ResponseWriter writer, UIColumn uiColumn, String headerStyleClass, int colspan) throws IOException {
        this.renderColumnHeaderCell(facesContext, writer, uiColumn, uiColumn.getHeader(), headerStyleClass, colspan);
    }

    protected void renderColumnHeaderCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String headerStyleClass, int colspan) throws IOException {
        writer.startElement("th", uiComponent);
        if (colspan > 1) {
            writer.writeAttribute("colspan", new Integer(colspan), null);
        }
        if (headerStyleClass != null) {
            writer.writeAttribute("class", headerStyleClass, null);
        }
        writer.writeAttribute("scope", "col", null);
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement("th");
    }

    protected void renderColumnFooterCell(FacesContext facesContext, ResponseWriter writer, UIColumn uiColumn, String footerStyleClass, int colspan) throws IOException {
        this.renderColumnFooterCell(facesContext, writer, uiColumn, uiColumn.getFooter(), footerStyleClass, colspan);
    }

    protected void renderColumnFooterCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String footerStyleClass, int colspan) throws IOException {
        writer.startElement("td", uiComponent);
        if (colspan > 1) {
            writer.writeAttribute("colspan", new Integer(colspan), null);
        }
        if (footerStyleClass != null) {
            writer.writeAttribute("class", footerStyleClass, null);
        }
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement("td");
    }

    protected static String getHeaderClass(UIComponent component2) {
        if (component2 instanceof HtmlDataTable) {
            return ((HtmlDataTable)component2).getHeaderClass();
        }
        return (String)component2.getAttributes().get("headerClass");
    }

    protected static String getFooterClass(UIComponent component2) {
        if (component2 instanceof HtmlDataTable) {
            return ((HtmlDataTable)component2).getFooterClass();
        }
        return (String)component2.getAttributes().get("footerClass");
    }

    public void decode(FacesContext context, UIComponent component2) {
        super.decode(context, component2);
    }

    protected static class Styles {
        private String[] _columnStyle;
        private String[] _rowStyle;

        Styles(String rowStyles, String columnStyles) {
            this._rowStyle = rowStyles == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowStyles, ','));
            this._columnStyle = columnStyles == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnStyles, ','));
        }

        public String getRowStyle(int idx) {
            if (!this.hasRowStyle()) {
                return null;
            }
            return this._rowStyle[idx % this._rowStyle.length];
        }

        public String getColumnStyle(int idx) {
            if (!this.hasColumnStyle()) {
                return null;
            }
            return this._columnStyle[idx % this._columnStyle.length];
        }

        public boolean hasRowStyle() {
            return this._rowStyle.length > 0;
        }

        public boolean hasColumnStyle() {
            return this._columnStyle.length > 0;
        }
    }
}

