/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.component.html.HtmlMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlMessageRendererBase;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.util.NullIterator;

public abstract class HtmlMessagesRendererBase
extends HtmlMessageRendererBase {
    private static final Log log = LogFactory.getLog(HtmlMessagesRendererBase.class);
    protected static final String LAYOUT_LIST = "list";
    protected static final String LAYOUT_TABLE = "table";

    protected void renderMessages(FacesContext facesContext, UIComponent messages2) throws IOException {
        MessagesIterator messagesIterator = new MessagesIterator(facesContext, this.isGlobalOnly(messages2));
        if (messagesIterator.hasNext()) {
            String layout = this.getLayout(messages2);
            if (layout == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No messages layout given, using default layout 'list'.");
                }
                this.renderList(facesContext, messages2, messagesIterator);
            } else if (layout.equalsIgnoreCase(LAYOUT_TABLE)) {
                this.renderTable(facesContext, messages2, messagesIterator);
            } else {
                if (log.isWarnEnabled() && !layout.equalsIgnoreCase(LAYOUT_LIST)) {
                    log.warn((Object)("Unsupported messages layout '" + layout + "' - using default layout 'list'."));
                }
                this.renderList(facesContext, messages2, messagesIterator);
            }
        }
    }

    private void renderList(FacesContext facesContext, UIComponent messages2, MessagesIterator messagesIterator) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("ul", messages2);
        HtmlRendererUtils.writeIdIfNecessary(writer, messages2, facesContext);
        HtmlRendererUtils.renderHTMLAttributes(writer, messages2, HTML.UNIVERSAL_ATTRIBUTES);
        while (messagesIterator.hasNext()) {
            writer.startElement("li", messages2);
            this.renderSingleFacesMessage(facesContext, messages2, (FacesMessage)messagesIterator.next(), messagesIterator.getClientId());
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    private void renderTable(FacesContext facesContext, UIComponent messages2, MessagesIterator messagesIterator) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement(LAYOUT_TABLE, messages2);
        HtmlRendererUtils.writeIdIfNecessary(writer, messages2, facesContext);
        HtmlRendererUtils.renderHTMLAttributes(writer, messages2, HTML.UNIVERSAL_ATTRIBUTES);
        while (messagesIterator.hasNext()) {
            writer.startElement("tr", messages2);
            writer.startElement("td", messages2);
            this.renderSingleFacesMessage(facesContext, messages2, (FacesMessage)messagesIterator.next(), messagesIterator.getClientId());
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement(LAYOUT_TABLE);
    }

    public static String[] getStyleAndStyleClass(UIComponent messages2, FacesMessage.Severity severity) {
        String style = null;
        String styleClass = null;
        if (messages2 instanceof HtmlMessages) {
            if (severity == FacesMessage.SEVERITY_INFO) {
                style = ((HtmlMessages)messages2).getInfoStyle();
                styleClass = ((HtmlMessages)messages2).getInfoClass();
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                style = ((HtmlMessages)messages2).getWarnStyle();
                styleClass = ((HtmlMessages)messages2).getWarnClass();
            } else if (severity == FacesMessage.SEVERITY_ERROR) {
                style = ((HtmlMessages)messages2).getErrorStyle();
                styleClass = ((HtmlMessages)messages2).getErrorClass();
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                style = ((HtmlMessages)messages2).getFatalStyle();
                styleClass = ((HtmlMessages)messages2).getFatalClass();
            }
            if (style == null) {
                style = ((HtmlMessages)messages2).getStyle();
            }
            if (styleClass == null) {
                styleClass = ((HtmlMessages)messages2).getStyleClass();
            }
        } else {
            Map<String, Object> attr = messages2.getAttributes();
            if (severity == FacesMessage.SEVERITY_INFO) {
                style = (String)attr.get("infoStyle");
                styleClass = (String)attr.get("infoClass");
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                style = (String)attr.get("warnStyle");
                styleClass = (String)attr.get("warnClass");
            } else if (severity == FacesMessage.SEVERITY_ERROR) {
                style = (String)attr.get("errorStyle");
                styleClass = (String)attr.get("errorClass");
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                style = (String)attr.get("fatalStyle");
                styleClass = (String)attr.get("fatalClass");
            }
            if (style == null) {
                style = (String)attr.get("style");
            }
            if (styleClass == null) {
                styleClass = (String)attr.get("styleClass");
            }
        }
        return new String[]{style, styleClass};
    }

    protected String getTitle(UIComponent component2) {
        if (component2 instanceof HtmlMessages) {
            return ((HtmlMessages)component2).getTitle();
        }
        return (String)component2.getAttributes().get("title");
    }

    protected boolean isTooltip(UIComponent component2) {
        if (component2 instanceof HtmlMessages) {
            return ((HtmlMessages)component2).isTooltip();
        }
        return RendererUtils.getBooleanAttribute(component2, "tooltip", false);
    }

    protected boolean isShowSummary(UIComponent component2) {
        if (component2 instanceof UIMessages) {
            return ((UIMessages)component2).isShowSummary();
        }
        return RendererUtils.getBooleanAttribute(component2, "showSummary", false);
    }

    protected boolean isShowDetail(UIComponent component2) {
        if (component2 instanceof UIMessages) {
            return ((UIMessages)component2).isShowDetail();
        }
        return RendererUtils.getBooleanAttribute(component2, "showDetail", false);
    }

    protected boolean isGlobalOnly(UIComponent component2) {
        if (component2 instanceof UIMessages) {
            return ((UIMessages)component2).isGlobalOnly();
        }
        return RendererUtils.getBooleanAttribute(component2, "globalOnly", false);
    }

    protected String getLayout(UIComponent component2) {
        if (component2 instanceof HtmlMessages) {
            return ((HtmlMessages)component2).getLayout();
        }
        return (String)component2.getAttributes().get("layout");
    }

    private static class MessagesIterator
    implements Iterator {
        private FacesContext _facesContext;
        private Iterator _globalMessagesIterator;
        private Iterator _clientIdsWithMessagesIterator;
        private Iterator _componentMessagesIterator = null;
        private String _clientId = null;

        public MessagesIterator(FacesContext facesContext, boolean globalOnly) {
            this._facesContext = facesContext;
            if (globalOnly) {
                this._globalMessagesIterator = facesContext.getMessages(null);
                this._clientIdsWithMessagesIterator = NullIterator.instance();
            } else {
                this._globalMessagesIterator = NullIterator.instance();
                this._clientIdsWithMessagesIterator = facesContext.getClientIdsWithMessages();
            }
            this._componentMessagesIterator = null;
            this._clientId = null;
        }

        public boolean hasNext() {
            return this._globalMessagesIterator.hasNext() || this._clientIdsWithMessagesIterator.hasNext() || this._componentMessagesIterator != null && this._componentMessagesIterator.hasNext();
        }

        public Object next() {
            if (this._globalMessagesIterator.hasNext()) {
                return this._globalMessagesIterator.next();
            }
            if (this._componentMessagesIterator != null && this._componentMessagesIterator.hasNext()) {
                return this._componentMessagesIterator.next();
            }
            this._clientId = (String)this._clientIdsWithMessagesIterator.next();
            this._componentMessagesIterator = this._facesContext.getMessages(this._clientId);
            return this._componentMessagesIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        public String getClientId() {
            return this._clientId;
        }
    }
}

