/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlFormRendererBase;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared_impl.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.shared_impl.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_impl.util._ComponentUtils;

public abstract class HtmlLinkRendererBase
extends HtmlRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent component2) {
        super.decode(facesContext, component2);
        if (component2 instanceof UICommand) {
            String clientId = component2.getClientId(facesContext);
            FormInfo formInfo = this.findNestingForm(component2, facesContext);
            String reqValue = facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName(formInfo));
            if (reqValue != null && reqValue.equals(clientId)) {
                component2.queueEvent(new ActionEvent(component2));
                RendererUtils.initPartialValidationAndModelUpdate(component2, facesContext);
            }
        } else if (!(component2 instanceof UIOutput)) {
            throw new IllegalArgumentException("Unsupported component class " + component2.getClass().getName());
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component2) throws IOException {
        super.encodeBegin(facesContext, component2);
        if (component2 instanceof UICommand) {
            this.renderCommandLinkStart(facesContext, component2, component2.getClientId(facesContext), ((UICommand)component2).getValue(), this.getStyle(facesContext, component2), this.getStyleClass(facesContext, component2));
        } else if (component2 instanceof UIOutput) {
            this.renderOutputLinkStart(facesContext, (UIOutput)component2);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component2.getClass().getName());
        }
    }

    protected String getStyle(FacesContext facesContext, UIComponent link) {
        if (link instanceof HtmlCommandLink) {
            return ((HtmlCommandLink)link).getStyle();
        }
        return (String)link.getAttributes().get("style");
    }

    protected String getStyleClass(FacesContext facesContext, UIComponent link) {
        if (link instanceof HtmlCommandLink) {
            return ((HtmlCommandLink)link).getStyleClass();
        }
        return (String)link.getAttributes().get("styleClass");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component2) throws IOException {
        RendererUtils.renderChildren(facesContext, component2);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component2) throws IOException {
        super.encodeEnd(facesContext, component2);
        if (component2 instanceof UICommand) {
            this.renderCommandLinkEnd(facesContext, component2);
            HtmlFormRendererBase.renderScrollHiddenInputIfNecessary(this.findNestingForm(component2, facesContext).getForm(), facesContext, facesContext.getResponseWriter());
        } else if (component2 instanceof UIOutput) {
            this.renderOutputLinkEnd(facesContext, component2);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component2.getClass().getName());
        }
    }

    protected void renderCommandLinkStart(FacesContext facesContext, UIComponent component2, String clientId, Object value, String style, String styleClass) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisabled(component2)) {
            writer.startElement("span", component2);
            HtmlRendererUtils.writeIdIfNecessary(writer, component2, facesContext);
            HtmlRendererUtils.renderHTMLAttributes(writer, component2, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES);
        } else {
            String[] anchorAttrsToRender;
            if (JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
                this.renderJavaScriptAnchorStart(facesContext, writer, component2, clientId);
                anchorAttrsToRender = HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_ONCLICK_WITHOUT_STYLE;
            } else {
                this.renderNonJavaScriptAnchorStart(facesContext, writer, component2, clientId);
                anchorAttrsToRender = HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_STYLE;
            }
            HtmlRendererUtils.writeIdIfNecessary(writer, component2, facesContext);
            HtmlRendererUtils.renderHTMLAttributes(writer, component2, anchorAttrsToRender);
            HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", (Object)style);
            HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", (Object)styleClass);
        }
        if (value != null) {
            writer.writeText(value.toString(), "value");
        }
    }

    protected void renderJavaScriptAnchorStart(FacesContext facesContext, ResponseWriter writer, UIComponent component2, String clientId) throws IOException {
        FormInfo formInfo = this.findNestingForm(component2, facesContext);
        if (formInfo == null) {
            String path = RendererUtils.getPathToComponent(component2);
            String msg = "Link is not embedded in a form. Change component/tag '" + clientId + "' from javax.faces.*/<h:tagName /> " + "to org.apache.myfaces.*/<t:tagName />, or embed it in a form.  This is not a bug. " + "Please see: http://wiki.apache.org/myfaces/Upgrading_to_Tomahawk_1.1.3 " + "The path to this component is " + path + ". If you need to render a special form and a JSF-form's attributes are not enough," + "consider using the s:form tag of the MyFaces sandbox.";
            throw new IllegalArgumentException(msg);
        }
        UIComponent nestingForm = formInfo.getForm();
        String formName = formInfo.getFormName();
        StringBuffer onClick = new StringBuffer();
        String commandOnclick = component2 instanceof HtmlCommandLink ? ((HtmlCommandLink)component2).getOnclick() : (String)component2.getAttributes().get("onclick");
        if (commandOnclick != null) {
            onClick.append("var cf = function(){");
            onClick.append(commandOnclick);
            onClick.append('}');
            onClick.append(';');
            onClick.append("var oamSF = function(){");
        }
        if (RendererUtils.isAdfOrTrinidadForm(formInfo.getForm())) {
            onClick.append("submitForm('");
            onClick.append(formInfo.getForm().getClientId(facesContext));
            onClick.append("',1,{source:'");
            onClick.append(component2.getClientId(facesContext));
            onClick.append("'});return false;");
        } else {
            HtmlRendererUtils.renderFormSubmitScript(facesContext);
            StringBuffer params = this.addChildParameters(component2, nestingForm);
            String target = this.getTarget(component2);
            onClick.append("return ").append("oamSubmitForm").append("('").append(formName).append("','").append(clientId).append("'");
            if (params.length() > 2 || target != null) {
                onClick.append(",").append(target == null ? "null" : "'" + target + "'").append(",").append(params);
            }
            onClick.append(");");
        }
        if (commandOnclick != null) {
            onClick.append('}');
            onClick.append(';');
            onClick.append("return (cf()==false)? false : oamSF();");
        }
        writer.startElement("a", component2);
        writer.writeURIAttribute("href", "#", null);
        writer.writeAttribute("onclick", onClick.toString(), null);
    }

    private String getTarget(UIComponent component2) {
        String target = component2 instanceof HtmlCommandLink ? ((HtmlCommandLink)component2).getTarget() : (String)component2.getAttributes().get("target");
        return target;
    }

    private StringBuffer addChildParameters(UIComponent component2, UIComponent nestingForm) {
        StringBuffer params = new StringBuffer();
        params.append("[");
        for (UIComponent child : this.getChildren(component2)) {
            String strParamValue;
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            if (name == null) {
                throw new IllegalArgumentException("Unnamed parameter value not allowed within command link.");
            }
            Object value = ((UIParameter)child).getValue();
            String string = strParamValue = value != null ? HTMLEncoder.encode(value.toString(), false, false) : "";
            if (params.length() > 1) {
                params.append(",");
            }
            params.append("['");
            params.append(name);
            params.append("','");
            params.append(strParamValue);
            params.append("']");
        }
        params.append("]");
        return params;
    }

    protected FormInfo findNestingForm(UIComponent uiComponent, FacesContext facesContext) {
        return _ComponentUtils.findNestingForm(uiComponent, facesContext);
    }

    protected void addHiddenCommandParameter(FacesContext facesContext, UIComponent nestingForm, String hiddenFieldName) {
        if (nestingForm != null) {
            HtmlFormRendererBase.addHiddenCommandParameter(facesContext, nestingForm, hiddenFieldName);
        }
    }

    protected void renderNonJavaScriptAnchorStart(FacesContext facesContext, ResponseWriter writer, UIComponent component2, String clientId) throws IOException {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        String path = viewHandler.getActionURL(facesContext, viewId);
        boolean strictXhtmlLinks = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isStrictXhtmlLinks();
        StringBuffer hrefBuf = new StringBuffer(path);
        if (path.indexOf(63) == -1) {
            hrefBuf.append('?');
        } else if (strictXhtmlLinks) {
            hrefBuf.append("&amp;");
        } else {
            hrefBuf.append('&');
        }
        String hiddenFieldName = HtmlRendererUtils.getHiddenCommandLinkFieldName(this.findNestingForm(component2, facesContext));
        hrefBuf.append(hiddenFieldName);
        hrefBuf.append('=');
        hrefBuf.append(clientId);
        if (this.getChildCount(component2) > 0) {
            this.addChildParametersToHref(facesContext, component2, hrefBuf, false, writer.getCharacterEncoding());
        }
        String href = facesContext.getExternalContext().encodeActionURL(hrefBuf.toString());
        writer.startElement("a", component2);
        writer.writeURIAttribute("href", facesContext.getExternalContext().encodeActionURL(href), null);
    }

    private void addChildParametersToHref(FacesContext facesContext, UIComponent linkComponent, StringBuffer hrefBuf, boolean firstParameter, String charEncoding) throws IOException {
        boolean strictXhtmlLinks = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isStrictXhtmlLinks();
        for (UIComponent child : this.getChildren(linkComponent)) {
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            Object value = ((UIParameter)child).getValue();
            HtmlLinkRendererBase.addParameterToHref(name, value, hrefBuf, firstParameter, charEncoding, strictXhtmlLinks);
            firstParameter = false;
        }
    }

    protected void renderOutputLinkStart(FacesContext facesContext, UIOutput output) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisabled(output)) {
            writer.startElement("span", output);
            HtmlRendererUtils.writeIdIfNecessary(writer, output, facesContext);
            HtmlRendererUtils.renderHTMLAttributes(writer, output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES);
        } else {
            String href = RendererUtils.getStringValue(facesContext, output);
            if (this.getChildCount(output) > 0) {
                StringBuffer hrefBuf = new StringBuffer(href);
                this.addChildParametersToHref(facesContext, output, hrefBuf, href.indexOf(63) == -1, writer.getCharacterEncoding());
                href = hrefBuf.toString();
            }
            href = facesContext.getExternalContext().encodeResourceURL(href);
            writer.startElement("a", output);
            HtmlRendererUtils.writeIdAndNameIfNecessary(writer, output, facesContext);
            writer.writeURIAttribute("href", href, null);
            HtmlRendererUtils.renderHTMLAttributes(writer, output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES);
            writer.flush();
        }
    }

    private void renderLinkParameter(String name, Object value, StringBuffer onClick, String jsForm, UIComponent nestingForm) {
        if (name == null) {
            throw new IllegalArgumentException("Unnamed parameter value not allowed within command link.");
        }
        onClick.append(jsForm);
        onClick.append(".elements['").append(name).append("']");
        String strParamValue = value != null ? HTMLEncoder.encode(value.toString(), false, false) : "";
        onClick.append(".value='").append(strParamValue).append("';");
        this.addHiddenCommandParameter(FacesContext.getCurrentInstance(), nestingForm, name);
    }

    private static void addParameterToHref(String name, Object value, StringBuffer hrefBuf, boolean firstParameter, String charEncoding, boolean strictXhtmlLinks) throws UnsupportedEncodingException {
        if (name == null) {
            throw new IllegalArgumentException("Unnamed parameter value not allowed within command link.");
        }
        if (firstParameter) {
            hrefBuf.append('?');
        } else if (strictXhtmlLinks) {
            hrefBuf.append("&amp;");
        } else {
            hrefBuf.append('&');
        }
        hrefBuf.append(URLEncoder.encode(name, charEncoding));
        hrefBuf.append('=');
        if (value != null) {
            hrefBuf.append(URLEncoder.encode(value.toString(), charEncoding));
        }
    }

    protected void renderOutputLinkEnd(FacesContext facesContext, UIComponent component2) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisabled(component2)) {
            writer.endElement("span");
        } else {
            writer.writeText("", null);
            writer.endElement("a");
        }
    }

    protected void renderCommandLinkEnd(FacesContext facesContext, UIComponent component2) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisabled(component2)) {
            writer.endElement("span");
        } else {
            writer.writeText("", null);
            writer.endElement("a");
        }
    }
}

