/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;
import javax.faces.model.SelectItem;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit._SharedRendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared_impl.util.HashMapUtils;
import org.apache.myfaces.shared_impl.util.SelectItemsIterator;

public final class RendererUtils {
    private static final Log log = LogFactory.getLog(RendererUtils.class);
    public static final String SELECT_ITEM_LIST_ATTR = RendererUtils.class.getName() + ".LIST";
    public static final String EMPTY_STRING = "";
    public static final Object NOTHING = new Serializable(){};
    public static final String ACTION_FOR_LIST = "org.apache.myfaces.ActionForList";
    public static final String ACTION_FOR_PHASE_LIST = "org.apache.myfaces.ActionForPhaseList";
    public static final String SEQUENCE_PARAM = "jsf_sequence";
    private static final String RENDER_KIT_IMPL = RendererUtils.class.getName() + ".RenderKitImpl";
    private static final String TRINIDAD_FORM_COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Form";
    private static final String ADF_FORM_COMPONENT_FAMILY = "oracle.adf.Form";

    private RendererUtils() {
    }

    public static String getPathToComponent(UIComponent component2) {
        StringBuffer buf = new StringBuffer();
        if (component2 == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        RendererUtils.getPathToComponent(component2, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component2, StringBuffer buf) {
        if (component2 == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component2.getClass().getName());
        if (component2 instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component2).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component2.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        RendererUtils.getPathToComponent(component2.getParent(), buf);
    }

    public static String getConcatenatedId(FacesContext context, UIComponent container2, String clientId) {
        UIComponent child = container2.findComponent(clientId);
        if (child == null) {
            return clientId;
        }
        return RendererUtils.getConcatenatedId(context, child);
    }

    public static String getConcatenatedId(FacesContext context, UIComponent component2) {
        UIComponent parent;
        if (context == null) {
            throw new NullPointerException("context");
        }
        StringBuffer idBuf = new StringBuffer();
        idBuf.append(component2.getId());
        while ((parent = component2.getParent()) != null) {
            if (!(parent instanceof NamingContainer)) continue;
            idBuf.insert(0, ':');
            idBuf.insert(0, parent.getId());
        }
        return idBuf.toString();
    }

    public static Boolean getBooleanValue(UIComponent component2) {
        Object value = RendererUtils.getObjectValue(component2);
        if (value instanceof String) {
            value = Boolean.valueOf((String)value);
        }
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("Expected submitted value of type Boolean for Component : " + RendererUtils.getPathToComponent(component2));
    }

    public static Date getDateValue(UIComponent component2) {
        Object value = RendererUtils.getObjectValue(component2);
        if (value == null || value instanceof Date) {
            return (Date)value;
        }
        throw new IllegalArgumentException("Expected submitted value of type Date for component : " + RendererUtils.getPathToComponent(component2));
    }

    public static Object getObjectValue(UIComponent component2) {
        Object value;
        if (!(component2 instanceof ValueHolder)) {
            throw new IllegalArgumentException("Component : " + RendererUtils.getPathToComponent(component2) + "is not a ValueHolder");
        }
        if (component2 instanceof EditableValueHolder && (value = ((EditableValueHolder)((Object)component2)).getSubmittedValue()) != null && !NOTHING.equals(value)) {
            return value;
        }
        return ((ValueHolder)((Object)component2)).getValue();
    }

    @Deprecated
    public static String getStringValue(FacesContext context, ValueBinding vb) {
        Object value = vb.getValue(context);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static String getStringValue(FacesContext context, ValueExpression ve) {
        Object value = ve.getValue(context.getELContext());
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static String getStringValue(FacesContext facesContext, UIComponent component2) {
        try {
            EditableValueHolder holder;
            Object submittedValue;
            if (!(component2 instanceof ValueHolder)) {
                throw new IllegalArgumentException("Component : " + RendererUtils.getPathToComponent(component2) + "is not a ValueHolder");
            }
            if (component2 instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)((Object)component2)).getSubmittedValue()) != null) {
                if (submittedValue instanceof String) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("returning 1 '" + submittedValue + "'"));
                    }
                    return (String)submittedValue;
                }
                throw new IllegalArgumentException("Expected submitted value of type String for component : " + RendererUtils.getPathToComponent(component2));
            }
            Object value = component2 instanceof EditableValueHolder ? ((holder = (EditableValueHolder)((Object)component2)).isLocalValueSet() ? holder.getLocalValue() : RendererUtils.getValue(component2)) : RendererUtils.getValue(component2);
            Converter converter = ((ValueHolder)((Object)component2)).getConverter();
            if (converter == null && value != null) {
                try {
                    converter = facesContext.getApplication().createConverter(value.getClass());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("the created converter is " + converter));
                    }
                }
                catch (FacesException e) {
                    log.error((Object)("No converter for class " + value.getClass().getName() + " found (component id=" + component2.getId() + ")."));
                }
            }
            if (converter == null) {
                if (value == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"returning an empty string");
                    }
                    return EMPTY_STRING;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"returning an .toString");
                }
                return value.toString();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("returning converter get as string " + converter));
            }
            return converter.getAsString(facesContext, component2, value);
        }
        catch (PropertyNotFoundException ex) {
            log.error((Object)("Property not found - called by component : " + RendererUtils.getPathToComponent(component2)), (Throwable)ex);
            throw ex;
        }
    }

    private static Object getValue(UIComponent component2) {
        Object value;
        try {
            value = ((ValueHolder)((Object)component2)).getValue();
        }
        catch (Exception ex) {
            throw new FacesException("Could not retrieve value of component with path : " + RendererUtils.getPathToComponent(component2), ex);
        }
        return value;
    }

    public static boolean isDefaultAttributeValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return ((Number)value).intValue() == Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return ((Number)value).doubleValue() == Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return ((Number)value).longValue() == Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return ((Number)value).byteValue() == -128;
            }
            if (value instanceof Float) {
                return ((Number)value).floatValue() == Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return ((Number)value).shortValue() == Short.MIN_VALUE;
            }
        }
        return false;
    }

    public static Converter findUIOutputConverter(FacesContext facesContext, UIOutput component2) throws FacesException {
        return _SharedRendererUtils.findUIOutputConverter(facesContext, component2);
    }

    public static Converter findUISelectManyConverter(FacesContext facesContext, UISelectMany component2) {
        Converter converter = component2.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression vb = component2.getValueExpression("value");
        if (vb == null) {
            return null;
        }
        Class<?> valueType = null;
        Object value = vb.getValue(facesContext.getELContext());
        Class<?> clazz = valueType = value != null ? value.getClass() : vb.getType(facesContext.getELContext());
        if (valueType == null) {
            return null;
        }
        if (List.class.isAssignableFrom(valueType)) {
            List selectItems = RendererUtils.internalGetSelectItemList(component2);
            if (selectItems != null && selectItems.size() > 0) {
                SelectItem selectItem = (SelectItem)selectItems.get(0);
                Class<?> listComponentType = selectItem.getValue().getClass();
                try {
                    return facesContext.getApplication().createConverter(listComponentType);
                }
                catch (FacesException e) {
                    log.error((Object)("No Converter for type " + listComponentType.getName() + " found"), (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        if (!valueType.isArray()) {
            throw new IllegalArgumentException("ValueBinding for UISelectMany : " + RendererUtils.getPathToComponent(component2) + " must be of type List or Array");
        }
        Class<?> arrayComponentType = valueType.getComponentType();
        if (String.class.equals(arrayComponentType)) {
            return null;
        }
        if (Object.class.equals(arrayComponentType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(arrayComponentType);
        }
        catch (FacesException e) {
            log.error((Object)("No Converter for type " + arrayComponentType.getName() + " found"), (Throwable)e);
            return null;
        }
    }

    public static void checkParamValidity(FacesContext facesContext, UIComponent uiComponent, Class compClass) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext may not be null");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent may not be null");
        }
        if (compClass != null && !compClass.isInstance(uiComponent)) {
            throw new IllegalArgumentException("uiComponent : " + RendererUtils.getPathToComponent(uiComponent) + " is not instance of " + compClass.getName() + " as it should be");
        }
    }

    public static void renderChildren(FacesContext facesContext, UIComponent component2) throws IOException {
        if (component2.getChildCount() > 0) {
            for (UIComponent child : component2.getChildren()) {
                RendererUtils.renderChild(facesContext, child);
            }
        }
    }

    public static void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            RendererUtils.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public static List getSelectItemList(UISelectOne uiSelectOne) {
        return RendererUtils.internalGetSelectItemList(uiSelectOne);
    }

    public static List getSelectItemList(UISelectMany uiSelectMany) {
        return RendererUtils.internalGetSelectItemList(uiSelectMany);
    }

    private static List internalGetSelectItemList(UIComponent uiComponent) {
        ArrayList list = new ArrayList();
        SelectItemsIterator iter = new SelectItemsIterator(uiComponent);
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static Set getSubmittedValuesAsSet(FacesContext context, UIComponent component2, Converter converter, UISelectMany uiSelectMany) {
        Object submittedValues = uiSelectMany.getSubmittedValue();
        if (submittedValues == null) {
            return null;
        }
        if (converter != null) {
            converter = new PassThroughAsStringConverter(converter);
        }
        return RendererUtils.internalSubmittedOrSelectedValuesAsSet(context, component2, converter, uiSelectMany, submittedValues);
    }

    public static Set getSelectedValuesAsSet(FacesContext context, UIComponent component2, Converter converter, UISelectMany uiSelectMany) {
        Object selectedValues = uiSelectMany.getValue();
        return RendererUtils.internalSubmittedOrSelectedValuesAsSet(context, component2, converter, uiSelectMany, selectedValues);
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component2, Converter converter, Object value) {
        if (converter == null) {
            if (value == null) {
                return EMPTY_STRING;
            }
            if (value instanceof String) {
                return (String)value;
            }
            throw new IllegalArgumentException("Value is no String (class=" + value.getClass().getName() + ", value=" + value + ") and component " + component2.getClientId(context) + "with path: " + RendererUtils.getPathToComponent(component2) + " does not have a Converter");
        }
        return converter.getAsString(context, component2, value);
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component2, Converter converter, SelectItem selectItem) {
        return RendererUtils.getConvertedStringValue(context, component2, converter, selectItem.getValue());
    }

    private static Set internalSubmittedOrSelectedValuesAsSet(FacesContext context, UIComponent component2, Converter converter, UISelectMany uiSelectMany, Object values) {
        if (values == null || EMPTY_STRING.equals(values)) {
            return Collections.EMPTY_SET;
        }
        if (values instanceof Object[]) {
            Object[] ar = (Object[])values;
            if (ar.length == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(ar.length));
            for (int i = 0; i < ar.length; ++i) {
                set.add(RendererUtils.getConvertedStringValue(context, component2, converter, ar[i]));
            }
            return set;
        }
        if (values.getClass().isArray()) {
            int len = Array.getLength(values);
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(len));
            for (int i = 0; i < len; ++i) {
                set.add(RendererUtils.getConvertedStringValue(context, component2, converter, Array.get(values, i)));
            }
            return set;
        }
        if (values instanceof List) {
            List lst = (List)values;
            if (lst.size() == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(lst.size()));
            Iterator i = lst.iterator();
            while (i.hasNext()) {
                set.add(RendererUtils.getConvertedStringValue(context, component2, converter, i.next()));
            }
            return set;
        }
        throw new IllegalArgumentException("Value of UISelectMany component with path : " + RendererUtils.getPathToComponent(uiSelectMany) + " is not of type Array or List");
    }

    public static Object getConvertedUISelectOneValue(FacesContext facesContext, UISelectOne output, Object submittedValue) {
        Converter converter;
        if (submittedValue != null && !(submittedValue instanceof String)) {
            if (NOTHING.equals(submittedValue)) {
                return null;
            }
            throw new IllegalArgumentException("Submitted value of type String for component : " + RendererUtils.getPathToComponent(output) + "expected");
        }
        if (submittedValue != null && submittedValue instanceof String && EMPTY_STRING.equals(submittedValue)) {
            submittedValue = null;
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, output);
        }
        catch (FacesException e) {
            throw new ConverterException(e);
        }
        return converter == null ? submittedValue : converter.getAsObject(facesContext, output, (String)submittedValue);
    }

    public static Object getConvertedUIOutputValue(FacesContext facesContext, UIOutput output, Object submittedValue) throws ConverterException {
        Converter converter;
        if (submittedValue != null && !(submittedValue instanceof String)) {
            if (NOTHING.equals(submittedValue)) {
                return null;
            }
            throw new IllegalArgumentException("Submitted value of type String for component : " + RendererUtils.getPathToComponent(output) + "expected");
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, output);
        }
        catch (FacesException e) {
            throw new ConverterException(e);
        }
        return converter == null ? submittedValue : converter.getAsObject(facesContext, output, (String)submittedValue);
    }

    public static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany selectMany, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            return null;
        }
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value of type String[] for component : " + RendererUtils.getPathToComponent(selectMany) + "expected");
        }
        return _SharedRendererUtils.getConvertedUISelectManyValue(facesContext, selectMany, (String[])submittedValue);
    }

    public static boolean getBooleanAttribute(UIComponent component2, String attrName, boolean defaultValue) {
        Boolean b = (Boolean)component2.getAttributes().get(attrName);
        return b != null ? b : defaultValue;
    }

    public static int getIntegerAttribute(UIComponent component2, String attrName, int defaultValue) {
        Integer i = (Integer)component2.getAttributes().get(attrName);
        return i != null ? i : defaultValue;
    }

    public static FormInfo findNestingForm(UIComponent uiComponent, FacesContext facesContext) {
        UIComponent parent;
        for (parent = uiComponent.getParent(); !(parent == null || ADF_FORM_COMPONENT_FAMILY.equals(parent.getFamily()) || TRINIDAD_FORM_COMPONENT_FAMILY.equals(parent.getFamily()) || parent instanceof UIForm); parent = parent.getParent()) {
        }
        if (parent != null) {
            String formName = parent.getClientId(facesContext);
            return new FormInfo(parent, formName);
        }
        return null;
    }

    public static boolean getBooleanValue(String attribute, Object value, boolean defaultValue) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value != null) {
            log.error((Object)("value for attribute " + attribute + " must be instanceof 'Boolean' or 'String', is of type : " + value.getClass()));
            return defaultValue;
        }
        return defaultValue;
    }

    public static void copyHtmlInputTextAttributes(HtmlInputText src, HtmlInputText dest) {
        dest.setId(src.getId());
        boolean forceId = RendererUtils.getBooleanValue("forceId", src.getAttributes().get("forceId"), false);
        if (forceId) {
            dest.getAttributes().put("forceId", Boolean.TRUE);
        }
        dest.setImmediate(src.isImmediate());
        dest.setTransient(src.isTransient());
        dest.setAccesskey(src.getAccesskey());
        dest.setAlt(src.getAlt());
        dest.setConverter(src.getConverter());
        dest.setDir(src.getDir());
        dest.setDisabled(src.isDisabled());
        dest.setLang(src.getLang());
        dest.setLocalValueSet(src.isLocalValueSet());
        dest.setMaxlength(src.getMaxlength());
        dest.setOnblur(src.getOnblur());
        dest.setOnchange(src.getOnchange());
        dest.setOnclick(src.getOnclick());
        dest.setOndblclick(src.getOndblclick());
        dest.setOnfocus(src.getOnfocus());
        dest.setOnkeydown(src.getOnkeydown());
        dest.setOnkeypress(src.getOnkeypress());
        dest.setOnkeyup(src.getOnkeyup());
        dest.setOnmousedown(src.getOnmousedown());
        dest.setOnmousemove(src.getOnmousemove());
        dest.setOnmouseout(src.getOnmouseout());
        dest.setOnmouseover(src.getOnmouseover());
        dest.setOnmouseup(src.getOnmouseup());
        dest.setOnselect(src.getOnselect());
        dest.setReadonly(src.isReadonly());
        dest.setRendered(src.isRendered());
        dest.setRequired(src.isRequired());
        dest.setSize(src.getSize());
        dest.setStyle(src.getStyle());
        dest.setStyleClass(src.getStyleClass());
        dest.setTabindex(src.getTabindex());
        dest.setTitle(src.getTitle());
        dest.setValidator(src.getValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getViewSequence(FacesContext facescontext) {
        Map<String, Object> map = facescontext.getExternalContext().getRequestMap();
        Integer sequence = (Integer)map.get(SEQUENCE_PARAM);
        if (sequence == null) {
            sequence = new Integer(1);
            map.put(SEQUENCE_PARAM, sequence);
            Object object = facescontext.getExternalContext().getSession(true);
            synchronized (object) {
                facescontext.getExternalContext().getSessionMap().put(SEQUENCE_PARAM, sequence);
            }
        }
        return sequence;
    }

    public static UIComponent findComponent(UIComponent headerComp, Class clazz) {
        if (clazz.isAssignableFrom(headerComp.getClass())) {
            return headerComp;
        }
        List<UIComponent> li = headerComp.getChildren();
        for (int i = 0; i < li.size(); ++i) {
            UIComponent comp = li.get(i);
            UIComponent lookupComp = RendererUtils.findComponent(comp, clazz);
            if (lookupComp == null) continue;
            return lookupComp;
        }
        return null;
    }

    public static void addOrReplaceChild(UIInput component2, UIComponent child) {
        List<UIComponent> li = component2.getChildren();
        for (int i = 0; i < li.size(); ++i) {
            UIComponent oldChild = li.get(i);
            if (oldChild.getId() == null || !oldChild.getId().equals(child.getId())) continue;
            li.set(i, child);
            return;
        }
        component2.getChildren().add(child);
    }

    public static String getClientId(FacesContext facesContext, UIComponent uiComponent, String forAttr) {
        UIComponent forComponent = uiComponent.findComponent(forAttr);
        if (forComponent == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Unable to find component '" + forAttr + "' (calling findComponent on component '" + uiComponent.getClientId(facesContext) + "')." + " We'll try to return a guessed client-id anyways -" + " this will be a problem if you put the referenced component" + " into a different naming-container. If this is the case, you can always use the full client-id."));
            }
            if (forAttr.length() > 0 && forAttr.charAt(0) == ':') {
                return forAttr.substring(1);
            }
            String labelClientId = uiComponent.getClientId(facesContext);
            int colon = labelClientId.lastIndexOf(58);
            return colon == -1 ? forAttr : labelClientId.substring(0, colon + 1) + forAttr;
        }
        return forComponent.getClientId(facesContext);
    }

    public static List convertIdsToClientIds(String actionFor, FacesContext facesContext, UIComponent component2) {
        ArrayList<String> li = new ArrayList<String>();
        String[] ids = actionFor.split(",");
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals("none")) {
                li.add(ids[i]);
                continue;
            }
            li.add(RendererUtils.getClientId(facesContext, component2, ids[i]));
        }
        return li;
    }

    public static List convertPhasesToPhasesIds(String actionForPhase) {
        ArrayList<PhaseId> li = new ArrayList<PhaseId>();
        if (actionForPhase == null) {
            return li;
        }
        String[] ids = actionForPhase.split(",");
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals("PROCESS_VALIDATIONS")) {
                li.add(PhaseId.PROCESS_VALIDATIONS);
                continue;
            }
            if (!ids[i].equals("UPDATE_MODEL_VALUES")) continue;
            li.add(PhaseId.UPDATE_MODEL_VALUES);
        }
        return li;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadResourceFile(FacesContext ctx, String file) {
        ByteArrayOutputStream content = new ByteArrayOutputStream(10240);
        InputStream in = null;
        try {
            int read;
            in = ctx.getExternalContext().getResourceAsStream(file);
            if (in == null) {
                String string = null;
                return string;
            }
            byte[] fileBuffer = new byte[10240];
            while ((read = in.read(fileBuffer)) > -1) {
                content.write(fileBuffer, 0, read);
            }
        }
        catch (FileNotFoundException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("no such file " + file), (Throwable)e);
            }
            content = null;
        }
        catch (IOException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("problems during processing resource " + file), (Throwable)e);
            }
            content = null;
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return content.toString();
    }

    public static void initPartialValidationAndModelUpdate(UIComponent component2, FacesContext facesContext) {
        String actionFor = (String)component2.getAttributes().get("actionFor");
        if (actionFor != null) {
            List li = RendererUtils.convertIdsToClientIds(actionFor, facesContext, component2);
            facesContext.getExternalContext().getRequestMap().put(ACTION_FOR_LIST, li);
            String actionForPhase = (String)component2.getAttributes().get("actionForPhase");
            if (actionForPhase != null) {
                List phaseList = RendererUtils.convertPhasesToPhasesIds(actionForPhase);
                facesContext.getExternalContext().getRequestMap().put(ACTION_FOR_PHASE_LIST, phaseList);
            }
        }
    }

    public static boolean isAdfOrTrinidadForm(UIComponent component2) {
        if (component2 == null) {
            return false;
        }
        return ADF_FORM_COMPONENT_FAMILY.equals(component2.getFamily()) || TRINIDAD_FORM_COMPONENT_FAMILY.equals(component2.getFamily());
    }

    public static ResponseStateManager getResponseStateManager(FacesContext facesContext, String renderKitId) throws FacesException {
        RenderKit renderKit = facesContext.getRenderKit();
        if (renderKit == null) {
            Map<String, Object> requestMap = facesContext.getExternalContext().getRequestMap();
            RenderKitFactory factory = (RenderKitFactory)requestMap.get(RENDER_KIT_IMPL);
            if (factory != null) {
                renderKit = factory.getRenderKit(facesContext, renderKitId);
            } else {
                factory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
                if (factory == null) {
                    throw new IllegalStateException("Factory is null");
                }
                requestMap.put(RENDER_KIT_IMPL, factory);
                renderKit = factory.getRenderKit(facesContext, renderKitId);
            }
        }
        return renderKit.getResponseStateManager();
    }

    private static class PassThroughAsStringConverter
    implements Converter {
        private final Converter converter;

        public PassThroughAsStringConverter(Converter converter) {
            this.converter = converter;
        }

        public Object getAsObject(FacesContext context, UIComponent component2, String value) throws ConverterException {
            return this.converter.getAsObject(context, component2, value);
        }

        public String getAsString(FacesContext context, UIComponent component2, Object value) throws ConverterException {
            return (String)value;
        }
    }
}

