/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;

public class HtmlLabelRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlLabelRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String text;
        super.encodeBegin(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        this.encodeBefore(facesContext, writer, uiComponent);
        writer.startElement("label", uiComponent);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.LABEL_PASSTHROUGH_ATTRIBUTES);
        String forAttr = this.getFor(uiComponent);
        if (forAttr != null) {
            writer.writeAttribute("for", this.getClientId(facesContext, uiComponent, forAttr), "for");
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Attribute 'for' of label component with id " + uiComponent.getClientId(facesContext) + " is not defined"));
        }
        if (uiComponent instanceof ValueHolder && (text = RendererUtils.getStringValue(facesContext, uiComponent)) != null) {
            writer.writeText(text, "value");
        }
        writer.flush();
        this.encodeAfterStart(facesContext, writer, uiComponent);
    }

    protected void encodeAfterStart(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }

    protected void encodeBefore(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }

    protected String getFor(UIComponent component2) {
        if (component2 instanceof HtmlOutputLabel) {
            return ((HtmlOutputLabel)component2).getFor();
        }
        return (String)component2.getAttributes().get("for");
    }

    protected String getClientId(FacesContext facesContext, UIComponent uiComponent, String forAttr) {
        return RendererUtils.getClientId(facesContext, uiComponent, forAttr);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeEnd(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        this.encodeBeforeEnd(facesContext, writer, uiComponent);
        writer.endElement("label");
        this.encodeAfter(facesContext, writer, uiComponent);
    }

    protected void encodeBeforeEnd(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }

    protected void encodeAfter(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
    }
}

