/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.apache.myfaces.lifecycle.LifecycleImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleFactoryImpl
extends LifecycleFactory {
    private final Map<String, Lifecycle> _lifecycles = new HashMap<String, Lifecycle>();

    public LifecycleFactoryImpl() {
        this.addLifecycle("DEFAULT", new LifecycleImpl());
    }

    public void purgeLifecycle() {
        this._lifecycles.clear();
        this.addLifecycle("DEFAULT", new LifecycleImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycle(String id, Lifecycle lifecycle) {
        Map<String, Lifecycle> map = this._lifecycles;
        synchronized (map) {
            if (this._lifecycles.get(id) != null) {
                throw new IllegalArgumentException("Lifecycle with id '" + id + "' already exists.");
            }
            this._lifecycles.put(id, lifecycle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lifecycle getLifecycle(String id) throws FacesException {
        Map<String, Lifecycle> map = this._lifecycles;
        synchronized (map) {
            Lifecycle lifecycle = this._lifecycles.get(id);
            if (lifecycle == null) {
                throw new IllegalArgumentException("Unknown lifecycle '" + id + "'.");
            }
            return lifecycle;
        }
    }

    @Override
    public Iterator<String> getLifecycleIds() {
        return this._lifecycles.keySet().iterator();
    }
}

