/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified.resolver;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import org.apache.myfaces.config.RuntimeConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleResolver
extends ELResolver {
    private RuntimeConfig runtimeConfig;

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return;
        }
        ResourceBundle bundle = this.getResourceBundle(context, (String)property);
        if (bundle != null) {
            throw new PropertyNotWritableException("ResourceBundles are read-only");
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return false;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return false;
        }
        ResourceBundle bundle = this.getResourceBundle(context, (String)property);
        if (bundle != null) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return null;
        }
        ResourceBundle bundle = this.getResourceBundle(context, (String)property);
        if (bundle != null) {
            context.setPropertyResolved(true);
            return bundle;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return null;
        }
        ResourceBundle bundle = this.getResourceBundle(context, (String)property);
        if (bundle != null) {
            context.setPropertyResolved(true);
            return ResourceBundle.class;
        }
        return null;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
        Map<String, org.apache.myfaces.config.impl.digester.elements.ResourceBundle> resourceBundles = this.runtimeConfig(context).getResourceBundles();
        for (org.apache.myfaces.config.impl.digester.elements.ResourceBundle resourceBundle : resourceBundles.values()) {
            descriptors.add(this.makeDescriptor(resourceBundle));
        }
        return descriptors.iterator();
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        return String.class;
    }

    private FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    private ResourceBundle getResourceBundle(ELContext context, String property) {
        FacesContext facesContext = this.facesContext(context);
        if (facesContext != null) {
            Application application = facesContext.getApplication();
            return application.getResourceBundle(facesContext, property);
        }
        return null;
    }

    protected RuntimeConfig runtimeConfig(ELContext context) {
        FacesContext facesContext = this.facesContext(context);
        if (this.runtimeConfig == null) {
            this.runtimeConfig = RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
        }
        return this.runtimeConfig;
    }

    private FeatureDescriptor makeDescriptor(org.apache.myfaces.config.impl.digester.elements.ResourceBundle bundle) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setValue("resolvableAtDesignTime", Boolean.TRUE);
        fd.setName(bundle.getVar());
        fd.setDisplayName(bundle.getDisplayName());
        fd.setValue("type", ResourceBundle.class);
        fd.setShortDescription("");
        fd.setExpert(false);
        fd.setHidden(false);
        fd.setPreferred(true);
        return fd;
    }
}

