/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.portlet.PortletExternalContextImpl;
import org.apache.myfaces.context.servlet.ServletExternalContextImpl;
import org.apache.myfaces.el.unified.FacesELContext;
import org.apache.myfaces.shared_impl.util.NullIterator;

public class FacesContextImpl
extends FacesContext {
    private List _messageClientIds = null;
    private List _messages = null;
    private Application _application = ((ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory")).getApplication();
    private ReleaseableExternalContext _externalContext;
    private ResponseStream _responseStream = null;
    private ResponseWriter _responseWriter = null;
    private FacesMessage.Severity _maximumSeverity = null;
    private UIViewRoot _viewRoot;
    private boolean _renderResponse = false;
    private boolean _responseComplete = false;
    private RenderKitFactory _renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
    private boolean _released = false;
    private ELContext _elContext;

    public FacesContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        this(new PortletExternalContextImpl(portletContext, portletRequest, portletResponse));
    }

    public FacesContextImpl(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        this(new ServletExternalContextImpl(servletContext, servletRequest, servletResponse));
    }

    private FacesContextImpl(ReleaseableExternalContext externalContext) {
        this._externalContext = externalContext;
        FacesContext.setCurrentInstance(this);
    }

    public ExternalContext getExternalContext() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        return (ExternalContext)((Object)this._externalContext);
    }

    public FacesMessage.Severity getMaximumSeverity() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        return this._maximumSeverity;
    }

    public Iterator getMessages() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        return this._messages != null ? this._messages.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public Application getApplication() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        return this._application;
    }

    public Iterator getClientIdsWithMessages() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        if (this._messages == null || this._messages.isEmpty()) {
            return NullIterator.instance();
        }
        LinkedHashSet uniqueClientIds = new LinkedHashSet(this._messageClientIds);
        return uniqueClientIds.iterator();
    }

    public Iterator getMessages(String clientId) {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        if (this._messages == null) {
            return NullIterator.instance();
        }
        ArrayList lst = new ArrayList();
        for (int i = 0; i < this._messages.size(); ++i) {
            Object savedClientId = this._messageClientIds.get(i);
            if (clientId == null) {
                if (savedClientId != null) continue;
                lst.add(this._messages.get(i));
                continue;
            }
            if (!clientId.equals(savedClientId)) continue;
            lst.add(this._messages.get(i));
        }
        return lst.iterator();
    }

    public RenderKit getRenderKit() {
        if (this.getViewRoot() == null) {
            return null;
        }
        String renderKitId = this.getViewRoot().getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        return this._renderKitFactory.getRenderKit(this, renderKitId);
    }

    public boolean getRenderResponse() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        return this._renderResponse;
    }

    public boolean getResponseComplete() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        return this._responseComplete;
    }

    public void setResponseStream(ResponseStream responseStream) {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        if (responseStream == null) {
            throw new NullPointerException("responseStream");
        }
        this._responseStream = responseStream;
    }

    public ResponseStream getResponseStream() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        return this._responseStream;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        if (responseWriter == null) {
            throw new NullPointerException("responseWriter");
        }
        this._responseWriter = responseWriter;
    }

    public ResponseWriter getResponseWriter() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        return this._responseWriter;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        if (viewRoot == null) {
            throw new NullPointerException("viewRoot");
        }
        this._viewRoot = viewRoot;
    }

    public UIViewRoot getViewRoot() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        return this._viewRoot;
    }

    public void addMessage(String clientId, FacesMessage message) {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this._messages == null) {
            this._messages = new ArrayList();
            this._messageClientIds = new ArrayList();
        }
        this._messages.add(message);
        this._messageClientIds.add(clientId != null ? clientId : null);
        FacesMessage.Severity serSeverity = message.getSeverity();
        if (serSeverity != null) {
            if (this._maximumSeverity == null) {
                this._maximumSeverity = serSeverity;
            } else if (serSeverity.compareTo(this._maximumSeverity) > 0) {
                this._maximumSeverity = serSeverity;
            }
        }
    }

    public void release() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        if (this._externalContext != null) {
            this._externalContext.release();
            this._externalContext = null;
        }
        this._messageClientIds = null;
        this._messages = null;
        this._application = null;
        this._responseStream = null;
        this._responseWriter = null;
        this._viewRoot = null;
        this._released = true;
        FacesContext.setCurrentInstance(null);
    }

    public void renderResponse() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        this._renderResponse = true;
    }

    public void responseComplete() {
        if (this._released) {
            throw new IllegalStateException("FacesContext already released");
        }
        this._responseComplete = true;
    }

    public void setExternalContext(ReleaseableExternalContext extContext) {
        this._externalContext = extContext;
        FacesContext.setCurrentInstance(this);
    }

    public ELContext getELContext() {
        if (this._elContext != null) {
            return this._elContext;
        }
        this._elContext = new FacesELContext(this.getApplication().getELResolver(), this);
        ELContextEvent event2 = new ELContextEvent(this._elContext);
        for (ELContextListener listener : this.getApplication().getELContextListeners()) {
            listener.contextCreated(event2);
        }
        return this._elContext;
    }
}

