/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.impl.digester;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.impl.digester.elements.Application;
import org.apache.myfaces.config.impl.digester.elements.Converter;
import org.apache.myfaces.config.impl.digester.elements.FacesConfig;
import org.apache.myfaces.config.impl.digester.elements.Factory;
import org.apache.myfaces.config.impl.digester.elements.LocaleConfig;
import org.apache.myfaces.config.impl.digester.elements.RenderKit;
import org.apache.myfaces.config.impl.digester.elements.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigesterFacesConfigDispenserImpl
implements FacesConfigDispenser<FacesConfig> {
    private List<FacesConfig> configs = new ArrayList<FacesConfig>();
    private List<String> applicationFactories = new ArrayList<String>();
    private List<String> facesContextFactories = new ArrayList<String>();
    private List<String> lifecycleFactories = new ArrayList<String>();
    private List<String> renderKitFactories = new ArrayList<String>();
    private Map<String, String> components = new HashMap<String, String>();
    private Map<String, String> validators = new HashMap<String, String>();
    private String defaultRenderKitId;
    private LocaleConfig localeConfig;
    private List<String> actionListeners = new ArrayList<String>();
    private List<String> lifecyclePhaseListeners = new ArrayList<String>();
    private String messageBundle;
    private List<String> navigationHandlers = new ArrayList<String>();
    private List<String> viewHandlers = new ArrayList<String>();
    private List<String> stateManagers = new ArrayList<String>();
    private List<String> propertyResolver = new ArrayList<String>();
    private List<String> variableResolver = new ArrayList<String>();
    private Map<String, String> converterById = new HashMap<String, String>();
    private Map<String, String> converterByClass = new HashMap<String, String>();
    private Map<String, Converter> converterConfigurationByClassName = new HashMap<String, Converter>();
    private Map<String, RenderKit> renderKits = new LinkedHashMap<String, RenderKit>();
    private List<ManagedBean> managedBeans = new ArrayList<ManagedBean>();
    private List<NavigationRule> navigationRules = new ArrayList<NavigationRule>();
    private List<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
    private List<String> elResolvers = new ArrayList<String>();

    @Override
    public void feed(FacesConfig config) {
        this.configs.add(config);
        for (Factory factory : config.getFactories()) {
            this.applicationFactories.addAll(factory.getApplicationFactory());
            this.facesContextFactories.addAll(factory.getFacesContextFactory());
            this.lifecycleFactories.addAll(factory.getLifecycleFactory());
            this.renderKitFactories.addAll(factory.getRenderkitFactory());
        }
        this.components.putAll(config.getComponents());
        this.validators.putAll(config.getValidators());
        for (Application application : config.getApplications()) {
            if (!application.getDefaultRenderkitId().isEmpty()) {
                this.defaultRenderKitId = application.getDefaultRenderkitId().get(application.getDefaultRenderkitId().size() - 1);
            }
            if (!application.getMessageBundle().isEmpty()) {
                this.messageBundle = application.getMessageBundle().get(application.getMessageBundle().size() - 1);
            }
            if (!application.getLocaleConfig().isEmpty()) {
                this.localeConfig = application.getLocaleConfig().get(application.getLocaleConfig().size() - 1);
            }
            this.actionListeners.addAll(application.getActionListener());
            this.navigationHandlers.addAll(application.getNavigationHandler());
            this.viewHandlers.addAll(application.getViewHandler());
            this.stateManagers.addAll(application.getStateManager());
            this.propertyResolver.addAll(application.getPropertyResolver());
            this.variableResolver.addAll(application.getVariableResolver());
            this.resourceBundles.addAll(application.getResourceBundle());
            this.elResolvers.addAll(application.getElResolver());
        }
        for (Converter converter : config.getConverters()) {
            if (converter.getConverterId() != null) {
                this.converterById.put(converter.getConverterId(), converter.getConverterClass());
            } else {
                this.converterByClass.put(converter.getForClass(), converter.getConverterClass());
            }
            this.converterConfigurationByClassName.put(converter.getConverterClass(), converter);
        }
        for (RenderKit renderKit : config.getRenderKits()) {
            RenderKit existing;
            String renderKitId = renderKit.getId();
            if (renderKitId == null) {
                renderKitId = "HTML_BASIC";
            }
            if ((existing = this.renderKits.get(renderKitId)) == null) {
                this.renderKits.put(renderKit.getId(), renderKit);
                continue;
            }
            existing.merge(renderKit);
        }
        this.lifecyclePhaseListeners.addAll(config.getLifecyclePhaseListener());
        this.managedBeans.addAll(config.getManagedBeans());
        this.navigationRules.addAll(config.getNavigationRules());
    }

    @Override
    public void feedApplicationFactory(String factoryClassName) {
        this.applicationFactories.add(factoryClassName);
    }

    @Override
    public void feedFacesContextFactory(String factoryClassName) {
        this.facesContextFactories.add(factoryClassName);
    }

    @Override
    public void feedLifecycleFactory(String factoryClassName) {
        this.lifecycleFactories.add(factoryClassName);
    }

    @Override
    public void feedRenderKitFactory(String factoryClassName) {
        this.renderKitFactories.add(factoryClassName);
    }

    @Override
    public Iterator<String> getApplicationFactoryIterator() {
        return this.applicationFactories.iterator();
    }

    @Override
    public Iterator<String> getFacesContextFactoryIterator() {
        return this.facesContextFactories.iterator();
    }

    @Override
    public Iterator<String> getLifecycleFactoryIterator() {
        return this.lifecycleFactories.iterator();
    }

    @Override
    public Iterator<String> getRenderKitFactoryIterator() {
        return this.renderKitFactories.iterator();
    }

    @Override
    public Iterator<String> getActionListenerIterator() {
        ArrayList<String> listeners = new ArrayList<String>(this.actionListeners);
        return listeners.iterator();
    }

    @Override
    public String getDefaultRenderKitId() {
        return this.defaultRenderKitId;
    }

    @Override
    public String getMessageBundle() {
        return this.messageBundle;
    }

    @Override
    public Iterator<String> getNavigationHandlerIterator() {
        ArrayList<String> handlers = new ArrayList<String>(this.navigationHandlers);
        return handlers.iterator();
    }

    @Override
    public Iterator<String> getViewHandlerIterator() {
        ArrayList<String> handlers = new ArrayList<String>(this.viewHandlers);
        return handlers.iterator();
    }

    @Override
    public Iterator<String> getStateManagerIterator() {
        ArrayList<String> managers = new ArrayList<String>(this.stateManagers);
        return managers.iterator();
    }

    @Override
    public Iterator<String> getPropertyResolverIterator() {
        ArrayList<String> resolver = new ArrayList<String>(this.propertyResolver);
        return resolver.iterator();
    }

    @Override
    public Iterator<String> getVariableResolverIterator() {
        ArrayList<String> resolver = new ArrayList<String>(this.variableResolver);
        return resolver.iterator();
    }

    @Override
    public String getDefaultLocale() {
        if (this.localeConfig != null) {
            return this.localeConfig.getDefaultLocale();
        }
        return null;
    }

    @Override
    public Iterator getSupportedLocalesIterator() {
        if (this.localeConfig != null) {
            return this.localeConfig.getSupportedLocales().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public Iterator getComponentTypes() {
        return this.components.keySet().iterator();
    }

    @Override
    public String getComponentClass(String componentType) {
        return this.components.get(componentType);
    }

    @Override
    public Iterator<String> getConverterIds() {
        return this.converterById.keySet().iterator();
    }

    @Override
    public Iterator<String> getConverterClasses() {
        return this.converterByClass.keySet().iterator();
    }

    @Override
    public Iterator<String> getConverterConfigurationByClassName() {
        return this.converterConfigurationByClassName.keySet().iterator();
    }

    @Override
    public Converter getConverterConfiguration(String converterClassName) {
        return this.converterConfigurationByClassName.get(converterClassName);
    }

    @Override
    public String getConverterClassById(String converterId) {
        return this.converterById.get(converterId);
    }

    @Override
    public String getConverterClassByClass(String className) {
        return this.converterByClass.get(className);
    }

    @Override
    public Iterator getValidatorIds() {
        return this.validators.keySet().iterator();
    }

    @Override
    public String getValidatorClass(String validatorId) {
        return this.validators.get(validatorId);
    }

    @Override
    public Iterator<ManagedBean> getManagedBeans() {
        return this.managedBeans.iterator();
    }

    @Override
    public Iterator<NavigationRule> getNavigationRules() {
        return this.navigationRules.iterator();
    }

    @Override
    public Iterator<String> getRenderKitIds() {
        return this.renderKits.keySet().iterator();
    }

    @Override
    public String getRenderKitClass(String renderKitId) {
        RenderKit renderKit = this.renderKits.get(renderKitId);
        return renderKit.getRenderKitClass();
    }

    @Override
    public Iterator<Renderer> getRenderers(String renderKitId) {
        RenderKit renderKit = this.renderKits.get(renderKitId);
        return renderKit.getRenderer().iterator();
    }

    @Override
    public Iterator<String> getLifecyclePhaseListeners() {
        return this.lifecyclePhaseListeners.iterator();
    }

    @Override
    public Iterator<ResourceBundle> getResourceBundles() {
        return this.resourceBundles.iterator();
    }

    @Override
    public Iterator<String> getElResolvers() {
        return this.elResolvers.iterator();
    }
}

