/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.runtime.PageContextPool;
import com.ibm.ws.util.WSThreadLocal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspEngineInfo;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.PageContextImpl;

public class JspFactoryImpl
extends JspFactory {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "org.apache.jasper.runtime.JspFactoryImpl";
    private static final String SPEC_VERSION = "2.1";
    private static WSThreadLocal _threadLocal = new WSThreadLocal();
    private int bodyContentBufferSize = 512;

    public JspFactoryImpl() {
        this(512);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "JspFactoryImpl", "JspFactoryImpl ctor 1 buffsize=[512]  this=[" + this + "]");
        }
    }

    public JspFactoryImpl(int bodyContentBufferSize) {
        this.bodyContentBufferSize = bodyContentBufferSize;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "JspFactoryImpl", "JspFactoryImpl ctor 2 buffsize=[" + this.bodyContentBufferSize + "]  this=[" + this + "]");
        }
    }

    public PageContext getPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
        if (System.getSecurityManager() != null) {
            PrivilegedGetPageContext dp = new PrivilegedGetPageContext(this, servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
            return (PageContext)AccessController.doPrivileged(dp);
        }
        return this.internalGetPageContext(servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
    }

    public void releasePageContext(PageContext pc) {
        if (pc == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            PrivilegedReleasePageContext dp = new PrivilegedReleasePageContext(this, pc);
            AccessController.doPrivileged(dp);
        } else {
            this.internalReleasePageContext(pc);
        }
    }

    public JspEngineInfo getEngineInfo() {
        return new JspEngineInfo(){

            public String getSpecificationVersion() {
                return JspFactoryImpl.SPEC_VERSION;
            }
        };
    }

    private PageContext internalGetPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
        try {
            PageContext pc = this.getPool().remove();
            pc.initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
            return pc;
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.out);
            return null;
        }
    }

    private void internalReleasePageContext(PageContext pc) {
        pc.release();
    }

    void returnFreePageContext(PageContextImpl pc) {
        this.getPool().add(pc);
    }

    protected PageContextPool getPool() {
        PageContextPool pool = null;
        pool = (PageContextPool)_threadLocal.get();
        if (pool == null) {
            pool = new PageContextPool(8){

                protected PageContext createPageContext() {
                    return new PageContextImpl(JspFactoryImpl.this, JspFactoryImpl.this.bodyContentBufferSize);
                }
            };
            _threadLocal.set((Object)pool);
        }
        return pool;
    }

    public JspApplicationContext getJspApplicationContext(ServletContext context) {
        return JspApplicationContextImpl.getInstance(context);
    }

    private class PrivilegedReleasePageContext
    implements PrivilegedAction {
        private JspFactoryImpl factory;
        private PageContext pageContext;

        PrivilegedReleasePageContext(JspFactoryImpl factory, PageContext pageContext) {
            this.factory = factory;
            this.pageContext = pageContext;
        }

        public Object run() {
            this.factory.internalReleasePageContext(this.pageContext);
            return null;
        }
    }

    private class PrivilegedGetPageContext
    implements PrivilegedAction {
        private JspFactoryImpl factory;
        private Servlet servlet;
        private ServletRequest request;
        private ServletResponse response;
        private String errorPageURL;
        private boolean needsSession;
        private int bufferSize;
        private boolean autoflush;

        PrivilegedGetPageContext(JspFactoryImpl factory, Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
            this.factory = factory;
            this.servlet = servlet;
            this.request = request;
            this.response = response;
            this.errorPageURL = errorPageURL;
            this.needsSession = needsSession;
            this.bufferSize = bufferSize;
            this.autoflush = autoflush;
        }

        public Object run() {
            return this.factory.internalGetPageContext(this.servlet, this.request, this.response, this.errorPageURL, this.needsSession, this.bufferSize, this.autoflush);
        }
    }
}

